/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.Comparator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class SubClassesListComposite
extends Composite
implements ISelectionProvider {
    private DataBindingContext m_currentDataBindings;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private EClass eClass;
    private final TreeViewer treeViewerSubClasses;
    private ISelectionChangedListener treeViewerSelectionChangedListener;

    public SubClassesListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.treeViewerSubClasses = new TreeViewer((Composite)this, 2048);
        Tree treeTypes = this.treeViewerSubClasses.getTree();
        treeTypes.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewerSubClasses);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewerSubClasses, 0);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        treeColumn.setWidth(100);
        this.treeViewerSubClasses.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SubClassesListComposite.this.newSelection((TreeSelection)event.getSelection());
            }
        });
        this.treeViewerSubClasses.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewerSubClasses.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    protected StyledCellLabelProvider getLabelProvider() {
        return new TypesLabelProvider();
    }

    protected AdapterFactoryContentProvider getContentProvider() {
        return new typeContentProvider((AdapterFactory)this.adapterFactory);
    }

    public void setSuperClass(EClass superClass) {
        this.eClass = superClass;
        if (superClass != null) {
            if (this.m_currentDataBindings != null) {
                this.m_currentDataBindings.dispose();
            }
            this.m_currentDataBindings = this.initDataBindings();
        }
    }

    public void setSelectedEClass(EClass eClass) {
        TreeItem[] treeItemArray = this.treeViewerSubClasses.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item == eClass) {
                this.treeViewerSubClasses.setSelection((ISelection)new StructuredSelection((Object)eClass));
            }
            ++n2;
        }
    }

    public EClass getSuperClass() {
        return this.eClass;
    }

    public EClass getSelectedSubClass() {
        return (EClass)this.treeViewerSubClasses.getStructuredSelection().getFirstElement();
    }

    protected void newSelection(TreeSelection selection) {
    }

    protected DataBindingContext initDataBindings() {
        return this.initDataBindingsCustom();
    }

    protected DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.eClass != null && !this.treeViewerSubClasses.getTree().isDisposed()) {
            this.treeViewerSubClasses.setInput((Object)this.eClass);
        }
        return bindingContext;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewerSelectionChangedListener = listener;
        this.treeViewerSubClasses.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewerSubClasses.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewerSubClasses.removeSelectionChangedListener(this.treeViewerSelectionChangedListener);
    }

    public void setSelection(ISelection selection) {
        this.eClass = (EClass)selection;
    }

    public void refresh() {
        this.treeViewerSubClasses.refresh();
    }

    private class TypesLabelProvider
    extends StyledCellLabelProvider {
        private TypesLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof EClass) {
                cell.setText(((EClass)cell.getElement()).getName());
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getInstanceClassName();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }

    private class typeContentProvider
    extends AdapterFactoryContentProvider {
        public typeContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object inputElement) {
            if (SubClassesListComposite.this.eClass != null) {
                List subClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(SubClassesListComposite.this.eClass);
                subClasses.sort(new Comparator<EClass>(){

                    @Override
                    public int compare(EClass arg0, EClass arg1) {
                        return String.CASE_INSENSITIVE_ORDER.compare(arg0.getName(), arg1.getName());
                    }
                });
                return subClasses.toArray();
            }
            Object[] objects = new Object[]{};
            return objects;
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }
}

