/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Date;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.apogy.common.emf.ui.utils.FeaturePathAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class TypedElementVsTimePlotComposite
extends Composite {
    private TimeSeriesCollection dataSet = null;
    private TimeSeries originalTimeSeries = null;
    private TimeSeries displayedTimeSeries = null;
    private JFreeChart chart;
    private FeaturePathAdapter featurePathAdapter;
    private Adapter valueAdapter = null;
    private IPropertyChangeListener propertyChangeListener;
    private UpdatePolicy updatePolicy = UpdatePolicy.ON_NEW_DATA;
    private long maximumHistoryLength = 1000L;
    private long refreshRatePeriodMilliseconds = 1000L;
    private long lastDataTimeStamp = -1L;
    private EObject eObject;
    private FeaturePath featurePath;

    public TypedElementVsTimePlotComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(new org.eclipse.swt.graphics.Color((Device)this.getDisplay(), 0, 0, 0));
        new ChartComposite((Composite)this, 0, this.getChart(), true);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener(TypedElementVsTimePlotComposite.this.getPropertyChangeListener());
                TypedElementVsTimePlotComposite.this.getFeaturePathAdapter().dispose();
            }
        });
    }

    public long getMaximumHistoryLength() {
        return this.maximumHistoryLength;
    }

    public void setMaximumHistoryLength(long maximumHistoryLength) {
        this.maximumHistoryLength = maximumHistoryLength;
    }

    public long getMiniumSamplePeriodMilliseconds() {
        return this.refreshRatePeriodMilliseconds;
    }

    public void setLimitedRefreshRatePeriodMilliseconds(long refreshRatePeriodMilliseconds) {
        this.refreshRatePeriodMilliseconds = refreshRatePeriodMilliseconds;
    }

    public long getLimitedRefreshRatePeriodMilliseconds() {
        return this.refreshRatePeriodMilliseconds;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public void setTypedElement(EStructuralFeature eStructuralFeature, EObject instance) {
        this.eObject = instance;
        if (eStructuralFeature != null) {
            this.featurePath = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{eStructuralFeature});
            this.getFeaturePathAdapter().setFeaturePath(this.featurePath);
        } else {
            this.featurePath = null;
            this.getFeaturePathAdapter().dispose();
        }
        this.layout();
    }

    public void setTypedElement(FeaturePath featurePath, EObject instance) {
        EObject oldEObject = this.eObject;
        EStructuralFeature oldFeature = this.getEStructuralFeature();
        this.eObject = instance;
        this.featurePath = featurePath;
        if (this.eObject != oldEObject || oldFeature != this.getEStructuralFeature()) {
            this.getFeaturePathAdapter().setFeaturePath(featurePath);
            this.setInstance(instance);
        }
        this.layout();
    }

    public void setInstance(EObject instance) {
        if (this.eObject != instance) {
            this.clearHistory();
            if (this.eObject != null) {
                this.getFeaturePathAdapter().dispose();
            }
        }
        this.eObject = instance;
        if (instance != null) {
            Number number;
            this.getFeaturePathAdapter().setSource(instance);
            if (this.getEStructuralFeature() != null && (number = this.convertValueToNumber(instance.eGet(this.getEStructuralFeature()))) != null) {
                Date date = new Date();
                this.processNewData(date, number);
            }
        }
        this.layout();
    }

    protected EStructuralFeature getEStructuralFeature() {
        EStructuralFeature[] features;
        EStructuralFeature feature = null;
        if (this.featurePath != null && (features = this.featurePath.getFeaturePath()) != null && features.length > 0) {
            feature = features[features.length - 1];
        }
        return feature;
    }

    protected Unit<?> getNativeUnits() {
        return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEStructuralFeature());
    }

    protected Unit<?> getDisplayUnits() {
        if (this.getEStructuralFeature() != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEStructuralFeature());
        }
        return null;
    }

    protected void clearHistory() {
        this.getOriginalTimeSeries().clear();
        this.getDisplayedTimeSeries().clear();
        this.lastDataTimeStamp = -1L;
    }

    protected Number convertValueToNumber(Object objectValue) {
        if (objectValue != null) {
            if (objectValue instanceof Number) {
                return (Number)objectValue;
            }
            if (objectValue instanceof Boolean) {
                Boolean b = (Boolean)objectValue;
                if (b.booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            if (objectValue instanceof EEnumLiteral) {
                EEnumLiteral eEnumLiteral = (EEnumLiteral)objectValue;
                return new Integer(eEnumLiteral.getValue());
            }
            return null;
        }
        return null;
    }

    protected Adapter getValueAdapterOld() {
        if (this.valueAdapter == null) {
            this.valueAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Number number;
                    Date date = new Date();
                    if (msg.getNotifier() == TypedElementVsTimePlotComposite.this.eObject && msg.getFeature() == TypedElementVsTimePlotComposite.this.getEStructuralFeature() && (number = TypedElementVsTimePlotComposite.this.convertValueToNumber(msg.getNewValue())) != null) {
                        TypedElementVsTimePlotComposite.this.processNewData(date, number);
                    }
                }
            };
        }
        return this.valueAdapter;
    }

    protected FeaturePathAdapter getFeaturePathAdapter() {
        if (this.featurePathAdapter == null) {
            this.featurePathAdapter = new FeaturePathAdapter(){

                @Override
                public void valueChanged(Object newValue) {
                    Date date = new Date();
                    Number number = TypedElementVsTimePlotComposite.this.convertValueToNumber(newValue);
                    if (number != null) {
                        TypedElementVsTimePlotComposite.this.processNewData(date, number);
                    }
                }
            };
        }
        return this.featurePathAdapter;
    }

    protected void processNewData(Date date, Number value) {
        if (this.getUpdatePolicy() == UpdatePolicy.LIMITED_REFRESH_RATE) {
            if (this.getMiniumSamplePeriodMilliseconds() != -1L) {
                long now = System.currentTimeMillis();
                if (this.lastDataTimeStamp == -1L) {
                    this.lastDataTimeStamp = now;
                    this.addNewData(date, value);
                } else if (now - this.lastDataTimeStamp >= this.getMiniumSamplePeriodMilliseconds()) {
                    this.addNewData(date, value);
                    this.lastDataTimeStamp = now;
                }
            } else {
                this.addNewData(date, value);
            }
        } else if (this.getUpdatePolicy() == UpdatePolicy.ON_NEW_DATA) {
            this.addNewData(date, value);
        }
    }

    protected void addNewData(final Date date, final Number value) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TypedElementVsTimePlotComposite.this.getOriginalTimeSeries().addOrUpdate((RegularTimePeriod)new Millisecond(date), value.doubleValue());
                if (TypedElementVsTimePlotComposite.this.getNativeUnits() != null) {
                    double displayedValue = TypedElementVsTimePlotComposite.this.getNativeUnits().getConverterTo(TypedElementVsTimePlotComposite.this.getDisplayUnits()).convert(value.doubleValue());
                    TypedElementVsTimePlotComposite.this.getDisplayedTimeSeries().addOrUpdate((RegularTimePeriod)new Millisecond(date), displayedValue);
                } else {
                    TypedElementVsTimePlotComposite.this.getDisplayedTimeSeries().addOrUpdate((RegularTimePeriod)new Millisecond(date), value.doubleValue());
                }
                if (TypedElementVsTimePlotComposite.this.getMaximumHistoryLength() != -1L && (long)TypedElementVsTimePlotComposite.this.getDisplayedTimeSeries().getItemCount() > TypedElementVsTimePlotComposite.this.getMaximumHistoryLength()) {
                    TypedElementVsTimePlotComposite.this.subSample();
                }
            }
        });
    }

    protected String getLabelFromEStructuralFeature(EStructuralFeature eStructuralFeature) {
        String raw = this.getEStructuralFeature().getName();
        String formated = raw.replaceAll("(.)([A-Z])", "$1 $2");
        formated = String.valueOf(formated.substring(0, 1).toUpperCase()) + formated.substring(1);
        return formated;
    }

    protected String getFeatureName() {
        if (this.getEStructuralFeature() != null) {
            return this.getLabelFromEStructuralFeature(this.getEStructuralFeature());
        }
        return "?";
    }

    protected void updatePlotUnits() {
        if (this.getDisplayUnits() != null && this.getNativeUnits() != null) {
            String chartYAxisLabel = String.valueOf(this.getFeatureName()) + " (" + this.getDisplayUnits().toString() + ")";
            XYPlot plot = (XYPlot)this.getChart().getPlot();
            plot.getRangeAxis().setLabel(chartYAxisLabel);
            double conversionFactor = this.getNativeUnits().getConverterTo(this.getDisplayUnits()).convert(1.0);
            this.getDisplayedTimeSeries().clear();
            int i = 0;
            while (i < this.getOriginalTimeSeries().getItemCount()) {
                TimeSeriesDataItem item = this.getOriginalTimeSeries().getDataItem(i);
                double altitude = item.getValue().doubleValue() * conversionFactor;
                this.getDisplayedTimeSeries().add(item.getPeriod(), altitude);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void subSample() {
        int initialSize = this.getDisplayedTimeSeries().getItems().size();
        if ((long)initialSize > this.getMaximumHistoryLength()) {
            void var3_4;
            ArrayList<Object> toKeep = new ArrayList<Object>();
            boolean bl = false;
            while (var3_4 < initialSize) {
                TimeSeriesDataItem item = this.getDisplayedTimeSeries().getDataItem((int)var3_4);
                toKeep.add(item);
                var3_4 += 2;
            }
            this.getDisplayedTimeSeries().clear();
            for (TimeSeriesDataItem timeSeriesDataItem : toKeep) {
                this.getDisplayedTimeSeries().add(timeSeriesDataItem);
            }
            ArrayList<TimeSeriesDataItem> arrayList = new ArrayList<TimeSeriesDataItem>();
            int i2 = 0;
            while (i2 < initialSize) {
                TimeSeriesDataItem item = this.getOriginalTimeSeries().getDataItem(i2);
                arrayList.add(item);
                i2 += 2;
            }
            this.getOriginalTimeSeries().clear();
            for (TimeSeriesDataItem item : arrayList) {
                this.getOriginalTimeSeries().add(item);
            }
        }
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event != null && event.getProperty() != null) {
                        if (event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference(event.getProperty())) {
                            TypedElementVsTimePlotComposite.this.updatePlotUnits();
                        } else if (!(event.getProperty().equals(Ranges.UNKNOWN.getName()) || event.getProperty().equals(Ranges.NOMINAL.getName()) || event.getProperty().equals(Ranges.WARNING.getName()) || event.getProperty().equals(Ranges.ALARM.getName()))) {
                            event.getProperty().equals(Ranges.OUT_OF_RANGE.getName());
                        }
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    private JFreeChart getChart() {
        if (this.chart == null) {
            String chartTitle = "Altitude";
            String chartXAxisLabel = "Time";
            String chartYAxisLabel = "Altitude (m)";
            this.chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)chartXAxisLabel, (String)chartYAxisLabel, (XYDataset)this.getRangeDataSet(), (boolean)true, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.black);
            this.chart.getTitle().setPaint((Paint)Color.green);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            plot.setOutlinePaint((Paint)Color.green);
            plot.setBackgroundPaint((Paint)Color.black);
            plot.setDomainGridlinePaint((Paint)Color.green);
            plot.setRangeGridlinePaint((Paint)Color.green);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(true);
            plot.setRangeCrosshairVisible(true);
            plot.setDomainMinorGridlinesVisible(false);
            plot.setRangeMinorGridlinesVisible(false);
            plot.setDomainGridlinesVisible(true);
            plot.setRangeGridlinesVisible(true);
            XYItemRenderer xyItemRenderer = plot.getRenderer();
            if (xyItemRenderer instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)xyItemRenderer;
                renderer.setBaseShapesVisible(false);
                renderer.setBaseShapesFilled(false);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
                renderer.setSeriesPaint(0, (Paint)Color.YELLOW);
            }
            plot.getRangeAxis().setAutoRange(true);
            plot.getRangeAxis().setLabelPaint((Paint)Color.green);
            plot.getRangeAxis().setTickLabelPaint((Paint)Color.green);
            plot.getRangeAxis().setTickMarkPaint((Paint)Color.green);
            plot.getRangeAxis().setAxisLinePaint((Paint)Color.black);
            plot.getDomainAxis().setAutoRange(true);
            plot.getDomainAxis().setLabelPaint((Paint)Color.green);
            plot.getDomainAxis().setTickLabelPaint((Paint)Color.green);
            plot.getDomainAxis().setTickMarkPaint((Paint)Color.green);
            plot.getDomainAxis().setAxisLinePaint((Paint)Color.black);
        }
        return this.chart;
    }

    private TimeSeriesCollection getRangeDataSet() {
        if (this.dataSet == null) {
            this.dataSet = new TimeSeriesCollection();
            this.dataSet.addSeries(this.getDisplayedTimeSeries());
        }
        return this.dataSet;
    }

    private TimeSeries getDisplayedTimeSeries() {
        if (this.displayedTimeSeries == null) {
            this.displayedTimeSeries = new TimeSeries((Comparable)((Object)"Altitude"));
        }
        return this.displayedTimeSeries;
    }

    private TimeSeries getOriginalTimeSeries() {
        if (this.originalTimeSeries == null) {
            this.originalTimeSeries = new TimeSeries((Comparable)((Object)"Altitude"));
        }
        return this.originalTimeSeries;
    }

    public static enum UpdatePolicy {
        ON_NEW_DATA,
        LIMITED_REFRESH_RATE;

    }
}

