/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.preferences;

import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ColorFieldEditorWithNullColor
extends ColorFieldEditor {
    private final Composite container;

    public ColorFieldEditorWithNullColor(String name, String string, Composite container) {
        super(name, string, container);
        this.container = container;
    }

    public int getNumberOfControls() {
        return super.getNumberOfControls() + 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        Button colorButton = this.getChangeControl(parent);
        colorButton.setLayoutData((Object)new GridData());
        this.createTransparentButton(parent);
    }

    protected Button createTransparentButton(Composite parent) {
        Button transparent = new Button(parent, 8);
        transparent.setText("None");
        transparent.setToolTipText("Set the color to null. This effectivelly makes the color transparent.");
        transparent.setLayoutData((Object)new GridData());
        transparent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGB background = new RGB(255, 255, 255);
                ColorFieldEditorWithNullColor.this.getColorSelector().setColorValue(background);
            }
        });
        return transparent;
    }

    protected void doLoad() {
        Color background;
        if (this.getColorSelector() == null) {
            return;
        }
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        RGB rgb = null;
        if (!"".equals(value)) {
            rgb = StringConverter.asRGB((String)value, null);
        }
        if (rgb == null && (background = this.container.getBackground()) != null) {
            rgb = background.getRGB();
        }
        this.getColorSelector().setColorValue(rgb);
    }

    protected void doStore() {
        RGB rgb = this.getColorSelector().getColorValue();
        RGB background = this.container.getBackground().getRGB();
        if (rgb.red == background.red && rgb.green == background.green && rgb.blue == background.blue) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), "");
        } else {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (RGB)this.getColorSelector().getColorValue());
        }
    }

    protected void doLoadDefault() {
        Color background;
        if (this.getColorSelector() == null) {
            return;
        }
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        RGB rgb = null;
        if (!"".equals(value)) {
            rgb = StringConverter.asRGB((String)value, null);
        }
        if (rgb == null && (background = this.container.getBackground()) != null) {
            rgb = background.getRGB();
        }
        this.getColorSelector().setColorValue(rgb);
    }
}

