/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.preferences.ColorFieldEditorWithNullColor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocatorDisplayPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger Logger = LoggerFactory.getLogger(InvocatorDisplayPreferencePage.class);
    private IPropertyChangeListener preferencesListener = null;
    private final Map<Ranges, ColorFieldEditor> rangesToChooseColorButtonsMap = new HashMap<Ranges, ColorFieldEditor>();

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group colorGroup = new Group(container, 0);
        colorGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        colorGroup.setLayout((Layout)new GridLayout(2, true));
        colorGroup.setText("Ranges Color");
        for (Ranges range : Ranges.VALUES) {
            try {
                ColorFieldEditor editor = this.createColorFieldEditor((Composite)colorGroup, range);
                this.rangesToChooseColorButtonsMap.put(range, editor);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
        this.updateControls();
        return container;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPreferencesListener());
        super.dispose();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setToDefault("INSTANCE_TYPE_NAME_FILTER_ID");
        store.setToDefault("INSTANCE_TYPE_CLASS_FILTER_ID");
        store.setToDefault("NATIVE_TO_DISPLAY_UNITS_ID");
        store.setToDefault("TYPED_ELEMENTS_UNITS_ID");
        for (Ranges range : this.rangesToChooseColorButtonsMap.keySet()) {
            ColorFieldEditor colorEditor = this.rangesToChooseColorButtonsMap.get(range);
            colorEditor.loadDefault();
        }
        super.performDefaults();
    }

    private void updateControls() {
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, Ranges range) {
        ColorFieldEditorWithNullColor colorEditor = new ColorFieldEditorWithNullColor(range.getName(), String.valueOf(range.getName()) + " :", container);
        colorEditor.setPreferenceStore(this.getPreferenceStore());
        colorEditor.load();
        return colorEditor;
    }

    private void storePreferences() {
        for (Ranges range : this.rangesToChooseColorButtonsMap.keySet()) {
            ColorFieldEditor colorEditor = this.rangesToChooseColorButtonsMap.get(range);
            colorEditor.store();
        }
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    InvocatorDisplayPreferencePage.this.updateControls();
                }
            };
        }
        return this.preferencesListener;
    }
}

