/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data.PolygonSamplingShape;
import org.eclipse.apogy.common.geometry.data.ShapeSamplingMode;
import org.eclipse.apogy.common.geometry.data.impl.MeshPolygonShapesSamplerImpl;

public abstract class MeshPolygonShapesSamplerCustomImpl<CoordinatesType extends Coordinates, PolygonType extends Polygon<CoordinatesType>>
extends MeshPolygonShapesSamplerImpl<CoordinatesType, PolygonType> {
    public Mesh<CoordinatesType, PolygonType> process(Mesh<CoordinatesType, PolygonType> input) throws Exception {
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().beginTask("Sampling using " + this.getPolygonSamplingShapes().size() + " sampling shapes. ", input.getPoints().size());
        }
        Mesh sampledMesh = this.createMesh();
        ArrayList<Polygon> polygonsKept = new ArrayList<Polygon>();
        for (Polygon polygon : input.getPolygons()) {
            if (!this.isPolygonInside(polygon)) continue;
            polygonsKept.add(polygon);
        }
        HashMap<Coordinates, Coordinates> originalToNewPointMap = new HashMap<Coordinates, Coordinates>();
        for (Polygon polygon : polygonsKept) {
            for (Coordinates point : polygon.getVertices()) {
                if (originalToNewPointMap.get(point) != null) continue;
                originalToNewPointMap.put(point, this.copyCoordinates(point));
            }
        }
        sampledMesh.getPoints().addAll(originalToNewPointMap.values());
        ArrayList polygonCopies = new ArrayList();
        for (Polygon polygon : polygonsKept) {
            Object newPolygon = this.createPolygon();
            for (Coordinates originalpoint : polygon.getVertices()) {
                newPolygon.getVertices().add((Object)((Coordinates)originalToNewPointMap.get(originalpoint)));
            }
            polygonCopies.add(newPolygon);
        }
        sampledMesh.getPolygons().addAll(polygonCopies);
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().done();
        }
        return sampledMesh;
    }

    private boolean isPolygonInside(PolygonType polygon) {
        boolean inside;
        block3: {
            block2: {
                inside = false;
                if (this.getShapeSamplingMode() != ShapeSamplingMode.UNION) break block2;
                inside = false;
                int j = 0;
                while (j < this.getPolygonSamplingShapes().size() && !inside) {
                    PolygonSamplingShape samplingShape = (PolygonSamplingShape)this.getPolygonSamplingShapes().get(j);
                    inside |= samplingShape.isPolygonInside(polygon);
                    ++j;
                }
                break block3;
            }
            if (this.getShapeSamplingMode() != ShapeSamplingMode.INTERSECTION) break block3;
            inside = true;
            int j = 0;
            while (j < this.getPolygonSamplingShapes().size() && inside) {
                PolygonSamplingShape samplingShape = (PolygonSamplingShape)this.getPolygonSamplingShapes().get(j);
                inside &= samplingShape.isPolygonInside(polygon);
                ++j;
            }
        }
        return inside;
    }
}

