/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.composites;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.bindings.BindingsList;
import org.eclipse.apogy.common.topology.bindings.BindingsSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class BindingsListComposite
extends Composite {
    private BindingsList bindingsList;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private DataBindingContext m_bindingContext;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public BindingsListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CustomContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTopologyBinding selectedAbstractTopologyBinding = (AbstractTopologyBinding)((IStructuredSelection)event.getSelection()).getFirstElement();
                BindingsListComposite.this.newBindingSelected(selectedAbstractTopologyBinding);
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setToolTipText("Create a new Binding.");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    String name = ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)BindingsListComposite.this.getBindingsList(), null, (ETypedElement)ApogyCommonTopologyBindingsPackage.Literals.BINDINGS_LIST__BINDINGS);
                    settings.getUserDataMap().put("name", name);
                    settings.getUserDataMap().put("nodes", BindingsListComposite.this.getAvailableTopologyNodesForBinding());
                    if (BindingsListComposite.this.getBindingsList().eContainer() instanceof BindingsSet) {
                        BindingsSet bindingsSet = (BindingsSet)BindingsListComposite.this.getBindingsList().eContainer();
                        settings.getUserDataMap().put("featureRootsList", bindingsSet.getFeatureRootsList());
                    }
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCommonTopologyBindingsPackage.Literals.BINDINGS_LIST__BINDINGS, (EObject)BindingsListComposite.this.getBindingsList(), (EClassSettings)settings, ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING);
                    WizardDialog dialog = new WizardDialog(BindingsListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!BindingsListComposite.this.treeViewer.isBusy()) {
                        BindingsListComposite.this.treeViewer.setInput((Object)BindingsListComposite.this.getBindingsList());
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setToolTipText("Deletes the selected Binding(s).");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String deleteMessage = "";
                Iterator<AbstractTopologyBinding> bindingsIterator = BindingsListComposite.this.getSelectedBindings().iterator();
                while (bindingsIterator.hasNext()) {
                    AbstractTopologyBinding binding = bindingsIterator.next();
                    deleteMessage = String.valueOf(deleteMessage) + binding.getName();
                    if (!bindingsIterator.hasNext()) continue;
                    deleteMessage = String.valueOf(deleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Bindings", null, "Are you sure to delete these Bindings : " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    List<AbstractTopologyBinding> toRemove = BindingsListComposite.this.getSelectedBindings();
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)BindingsListComposite.this.getBindingsList(), (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.BINDINGS_LIST__BINDINGS, toRemove);
                }
                if (!BindingsListComposite.this.treeViewer.isBusy()) {
                    BindingsListComposite.this.treeViewer.setInput((Object)BindingsListComposite.this.getBindingsList());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BindingsListComposite.this.m_bindingContext != null) {
                    BindingsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public BindingsList getBindingsList() {
        return this.bindingsList;
    }

    public void setBindingsList(BindingsList newBindingsList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.bindingsList = newBindingsList;
        if (newBindingsList != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
        this.treeViewer.setInput((Object)newBindingsList);
    }

    public List<AbstractTopologyBinding> getSelectedBindings() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    public abstract Collection<Node> getAvailableTopologyNodesForBinding();

    protected void newBindingSelected(AbstractTopologyBinding selectedAbstractTopologyBinding) {
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof BindingsList) {
                BindingsList bindingsList = (BindingsList)inputElement;
                return bindingsList.getBindings().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BindingsList) {
                BindingsList bindingsList = (BindingsList)parentElement;
                return bindingsList.getBindings().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BindingsList) {
                BindingsList bindingsList = (BindingsList)element;
                return bindingsList.getBindings().isEmpty();
            }
            return false;
        }
    }
}

