/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractFeatureTreeNode;
import org.eclipse.apogy.common.emf.AbstractRootNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.common.topology.bindings.FeatureRootsList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class FeatureRootsListComposite
extends Composite {
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private FeatureRootsList featureRootsList;
    private AbstractFeatureTreeNode selectedAbstractFeatureTreeNode = null;
    private boolean editable = true;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private Button btnNew;
    private Button btnDelete;
    private DataBindingContext m_bindingContext;

    public FeatureRootsListComposite(Composite parent, int style) {
        this(parent, style, true);
    }

    public FeatureRootsListComposite(Composite parent, int style, boolean editable) {
        super(parent, style);
        this.editable = editable;
        if (editable) {
            this.setLayout((Layout)new GridLayout(2, false));
        } else {
            this.setLayout((Layout)new GridLayout(1, false));
        }
        this.treeViewer = new TreeViewer((Composite)this, 68352);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractFeatureTreeNode selectedNode = (AbstractFeatureTreeNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                FeatureRootsListComposite.this.setSelectedAbstractFeatureTreeNode(selectedNode);
                FeatureRootsListComposite.this.newAbstractFeatureTreeNodeSelected(selectedNode);
            }
        });
        if (editable) {
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            composite.setLayout((Layout)new GridLayout(1, false));
            this.btnNew = new Button(composite, 0);
            this.btnNew.setSize(74, 29);
            this.btnNew.setText("New");
            this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnNew.setEnabled(true);
            this.btnNew.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13) {
                        AbstractFeatureTreeNode parent = null;
                        parent = FeatureRootsListComposite.this.getSelectedAbstractFeatureTreeNode() == null ? (AbstractFeatureTreeNode)FeatureRootsListComposite.this.getFeatureRootsList().getFeatureRoots().get(0) : FeatureRootsListComposite.this.getSelectedAbstractFeatureTreeNode();
                        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                        settings.getUserDataMap().put("parent", parent);
                        ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCommonEMFPackage.Literals.ABSTRACT_FEATURE_TREE_NODE__CHILDREN, (EObject)parent, (EClassSettings)settings, ApogyCommonEMFPackage.Literals.TREE_FEATURE_NODE);
                        WizardDialog dialog = new WizardDialog(FeatureRootsListComposite.this.getShell(), (IWizard)wizard);
                        dialog.open();
                        if (!FeatureRootsListComposite.this.treeViewer.isBusy()) {
                            FeatureRootsListComposite.this.treeViewer.setInput(FeatureRootsListComposite.this.getFeatureRootsList().getFeatureRoots().get(0));
                            if (wizard.getCreatedEObject() != null) {
                                FeatureRootsListComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)wizard.getCreatedEObject()));
                            }
                        }
                    }
                }
            });
            this.btnDelete = new Button(composite, 0);
            this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnDelete.setSize(74, 29);
            this.btnDelete.setText("Delete");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String deleteMessage = "";
                    Iterator<AbstractFeatureTreeNode> treeNodeIterator = FeatureRootsListComposite.this.getSelectedAbstractFeatureTreeNodes().iterator();
                    while (treeNodeIterator.hasNext()) {
                        AbstractFeatureSpecifier abstractFeatureSpecifier;
                        AbstractFeatureTreeNode treeNode = treeNodeIterator.next();
                        if (treeNode instanceof AbstractFeatureSpecifier && (abstractFeatureSpecifier = (AbstractFeatureSpecifier)treeNode).getStructuralFeature() != null) {
                            deleteMessage = abstractFeatureSpecifier.getStructuralFeature().getName();
                        }
                        if (!treeNodeIterator.hasNext()) continue;
                        deleteMessage = String.valueOf(deleteMessage) + ", ";
                    }
                    MessageDialog dialog = new MessageDialog(null, "Delete the selected Features", null, "Are you sure to delete these Features: " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                    int result = dialog.open();
                    if (result == 0) {
                        List<AbstractFeatureTreeNode> listOfNodesToRemove = FeatureRootsListComposite.this.getSelectedAbstractFeatureTreeNodes();
                        for (AbstractFeatureTreeNode nodeToRemove : listOfNodesToRemove) {
                            if (nodeToRemove instanceof AbstractRootNode) continue;
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)nodeToRemove.getParent(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.ABSTRACT_FEATURE_TREE_NODE__CHILDREN, (Object)nodeToRemove);
                        }
                    }
                    if (!FeatureRootsListComposite.this.treeViewer.isBusy()) {
                        FeatureRootsListComposite.this.treeViewer.setInput(FeatureRootsListComposite.this.getFeatureRootsList().getFeatureRoots().get(0));
                    }
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FeatureRootsListComposite.this.m_bindingContext != null) {
                    FeatureRootsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public FeatureRootsList getFeatureRootsList() {
        return this.featureRootsList;
    }

    public void setFeatureRootsList(FeatureRootsList newFeatureRootsList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.featureRootsList = newFeatureRootsList;
        if (newFeatureRootsList != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
            if (newFeatureRootsList.getFeatureRoots() != null && newFeatureRootsList.getFeatureRoots().size() > 0) {
                this.treeViewer.setInput(newFeatureRootsList.getFeatureRoots().get(0));
            }
            AbstractFeatureTreeNode abtractFeatureTreeNode = null;
            if (!newFeatureRootsList.getFeatureRoots().isEmpty()) {
                abtractFeatureTreeNode = (AbstractFeatureTreeNode)newFeatureRootsList.getFeatureRoots().get(0);
            }
            if (abtractFeatureTreeNode != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)abtractFeatureTreeNode), true);
            }
        }
    }

    public AbstractFeatureTreeNode getSelectedAbstractFeatureTreeNode() {
        return this.selectedAbstractFeatureTreeNode;
    }

    public void setSelectedAbstractFeatureTreeNode(AbstractFeatureTreeNode selectedAbstractFeatureTreeNode) {
        this.selectedAbstractFeatureTreeNode = selectedAbstractFeatureTreeNode;
    }

    public List<AbstractFeatureTreeNode> getSelectedAbstractFeatureTreeNodes() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newAbstractFeatureTreeNodeSelected(AbstractFeatureTreeNode selectedAbstractFeatureTreeNode) {
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        if (this.editable) {
            ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
            bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null) {
                        return true;
                    }
                    return false;
                }
            }));
        }
        return bindingContext;
    }
}

