/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.impl;

import java.util.Map;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.RotationNode;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.RotationBinding;
import org.eclipse.apogy.common.topology.bindings.impl.RotationBindingImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotationBindingCustomImpl
extends RotationBindingImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RotationBindingImpl.class);
    private static Unit<?> RADIANS = Unit.valueOf((CharSequence)"rad");
    private double featureToRadiansConversionFactor = 1.0;

    @Override
    public void bind() {
        this.featureToRadiansConversionFactor = this.determineConversionFactor();
        super.bind();
    }

    @Override
    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        RotationBinding rotationCopy = (RotationBinding)EcoreUtil.copy((EObject)this);
        rotationCopy.setRotationNode((RotationNode)originalToCopyNodeMap.get(this.getRotationNode()));
        return rotationCopy;
    }

    @Override
    public Class<?> getSupportedFeatureType() {
        return Number.class;
    }

    @Override
    protected void valueChanged(Object newValue) {
        double value = 0.0;
        if (newValue instanceof Double) {
            value = (Double)newValue;
        } else if (newValue instanceof Float) {
            value = ((Float)newValue).doubleValue();
        }
        this.applyValue(value);
    }

    private double determineConversionFactor() {
        double factor = 1.0;
        if (this.getFeatureNode() instanceof AbstractFeatureSpecifier) {
            AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)this.getFeatureNode();
            Unit units = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)featureSpecifier.getStructuralFeature());
            if (units != null) {
                try {
                    factor = units.getConverterTo(RADIANS).convert(1.0);
                }
                catch (Exception e) {
                    Logger.error("The engineering units of the feature <" + units.toString() + "> are not an angle value.", (Throwable)e);
                }
            } else {
                Logger.warn("No Engineering units defined for feature, assuming radians !");
            }
        }
        return factor;
    }

    private void applyValue(double newValue) {
        double value = newValue * this.featureToRadiansConversionFactor;
        switch (this.getRotationAxis().getValue()) {
            case 0: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(value, 0.0, 0.0).getRotationMatrix());
                break;
            }
            case 3: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(-value, 0.0, 0.0).getRotationMatrix());
                break;
            }
            case 1: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(0.0, value, 0.0).getRotationMatrix());
                break;
            }
            case 4: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(0.0, -value, 0.0).getRotationMatrix());
                break;
            }
            case 2: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(0.0, 0.0, value).getRotationMatrix());
                break;
            }
            case 5: {
                this.getRotationNode().setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(0.0, 0.0, -value).getRotationMatrix());
            }
        }
    }
}

