/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.internal;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import java.io.IOException;
import java.util.Stack;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ArbitraryViewPoint;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.internal.ICameraControl;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CustomCameraControl
implements ActionListener,
AnalogListener,
ICameraControl,
IPropertyChangeListener {
    public static final String LEFT_MOUSE_BUTTON = "LeftMouseButton";
    public static final String MIDDLE_MOUSE_BUTTON = "MiddleMouseButton";
    public static final String RIGHT_MOUSE_BUTTON = "RightMouseButton";
    public static final String MOUSE_MOTION_LEFT = "MouseMotionLeft";
    public static final String MOUSE_MOTION_RIGHT = "MouseMotionRight";
    public static final String MOUSE_MOTION_UP = "MouseMotionUp";
    public static final String MOUSE_MOTION_DOWN = "MouseMotionDown";
    public static final String MOUSE_MOTION_FORWARD = "MouseMotionForward";
    public static final String MOUSE_MOTION_AFT = "MouseMotionAft";
    public static final String KEYBOARD_RESET_POSE = "ResetPose";
    public static final String KEYBOARD_SAVE_POSE = "RecordPose";
    public static final String KEYBOARD_GOTO_LAST_POSE = "GotoLastPose";
    public static final String KEYBOARD_LEVEL_POSE = "LevelPose";
    public static final String KEYBOARD_HIGH_TRANSLATION_SPEED = "HighTranslationSpeed";
    private final String[] inputs = new String[]{"LeftMouseButton", "MiddleMouseButton", "RightMouseButton", "MouseMotionLeft", "MouseMotionRight", "MouseMotionDown", "MouseMotionUp", "MouseMotionForward", "MouseMotionAft", "RecordPose", "GotoLastPose", "ResetPose", "LevelPose", "HighTranslationSpeed"};
    private boolean leftMouseButton = false;
    private boolean middleMouseButton = false;
    private boolean rightMouseButton = false;
    private boolean cameraPoseDirty = false;
    private boolean highSpeedMotionEnabled = false;
    private boolean translationEnabled = true;
    private boolean rotationEnabled = true;
    private Vector3f initialLocation = new Vector3f();
    private Quaternion initialOrientation = new Quaternion();
    private Vector3f currentLocation = new Vector3f();
    private Quaternion currentOrientation = new Quaternion();
    private final Stack<Matrix4f> poseStack = new Stack();
    private CameraNode cameraNode = null;
    private com.jme3.scene.Node sceneRoot = null;
    private com.jme3.scene.Node nodeFollower = null;
    private Node nodeToFollow;
    private float translationSpeed = 2.0f;
    private float translationSpeedMultiplier = 1.0f;
    private float rotationSpeed = 1.0f;
    private final float rotationSpeedMultiplier = 1.0f;
    private Camera cam = null;
    private InputManager inputManager;
    private JME3Application viewer;
    private boolean inputsRegistered = false;
    private boolean enabled = true;

    public CustomCameraControl(Camera cam, com.jme3.scene.Node sceneRoot) {
        this(cam, sceneRoot, null, null);
    }

    public CustomCameraControl(Camera cam, com.jme3.scene.Node sceneRoot, InputManager inputManager, JME3Application viewer) {
        this.sceneRoot = sceneRoot;
        this.viewer = viewer;
        this.setCamera(cam);
        this.registerWithInput(inputManager);
        this.nodeFollower = new com.jme3.scene.Node("CustomCameraControlNodeFollower");
        sceneRoot.attachChild((Spatial)this.nodeFollower);
        this.cameraNode = new CameraNode("Custom Camera", cam);
        this.cameraNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        this.nodeFollower.attachChild((Spatial)this.cameraNode);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public CameraNode getCameraNode() {
        return this.cameraNode;
    }

    @Override
    public void attachViewPoint(AbstractViewPoint viewPoint) {
        this.currentLocation = new Vector3f();
        this.currentOrientation = new Quaternion();
        if (viewPoint instanceof ArbitraryViewPoint) {
            this.nodeToFollow = null;
            Matrix4d identity = new Matrix4d();
            identity.setIdentity();
            this.nodeFollower.setLocalTransform(JME3Utilities.createTransform(identity));
        } else if (viewPoint instanceof AttachedViewPoint) {
            this.nodeToFollow = ((AttachedViewPoint)viewPoint).getNode();
        }
        if (this.cameraNode != null) {
            Vector3f position = new Vector3f();
            if (viewPoint.getPosition() != null) {
                Tuple3d p = viewPoint.getPosition().asTuple3d();
                position = new Vector3f((float)p.x, (float)p.y, (float)p.z);
            }
            this.cameraNode.setLocalTranslation(position);
            Quaternion rotation = new Quaternion();
            if (viewPoint.getRotationMatrix() != null) {
                rotation = JME3Utilities.createQuaternion(viewPoint.getRotationMatrix().asMatrix3d());
            }
            this.cameraNode.setLocalRotation(rotation);
            this.setCurrentLocation(position);
            this.setCurrentOrientation(rotation);
        }
    }

    @Override
    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.setEnabled(false);
        if (this.inputManager != null) {
            this.unregisterInput(this.inputManager);
            this.inputManager = null;
        }
        if (this.sceneRoot != null) {
            this.sceneRoot.removeControl((Control)this);
            this.sceneRoot = null;
        }
        this.cam = null;
        this.viewer = null;
    }

    @Override
    public Vector3f getCurrentLocation() {
        return this.currentLocation;
    }

    @Override
    public void setCurrentLocation(Vector3f newLocation) {
        this.currentLocation = newLocation;
        this.cameraPoseDirty = true;
    }

    @Override
    public Quaternion getCurrentOrientation() {
        return this.currentOrientation;
    }

    @Override
    public void setCurrentOrientation(Quaternion newRotation) {
        this.currentOrientation = newRotation;
        this.cameraPoseDirty = true;
    }

    public float getTranslationSpeed() {
        return this.translationSpeed;
    }

    public void setTranslationSpeed(float translationSpeed) {
        this.translationSpeed = translationSpeed;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public void resetLocation(Vector3f newLocation) {
        this.initialLocation = newLocation;
        this.resetPause();
    }

    public void resetOrientation(Quaternion newOrientation) {
        this.initialOrientation = newOrientation;
        this.resetPause();
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (this.isEnabled()) {
            if (name.equals(LEFT_MOUSE_BUTTON)) {
                if (keyPressed) {
                    this.leftMouseButton = true;
                    this.inputManager.setCursorVisible(false);
                } else {
                    this.leftMouseButton = false;
                    this.inputManager.setCursorVisible(true);
                }
            } else if (name.equals(MIDDLE_MOUSE_BUTTON)) {
                if (keyPressed) {
                    this.middleMouseButton = true;
                    this.inputManager.setCursorVisible(false);
                } else {
                    this.middleMouseButton = false;
                    this.inputManager.setCursorVisible(true);
                }
            } else if (name.equals(RIGHT_MOUSE_BUTTON)) {
                if (keyPressed) {
                    this.rightMouseButton = true;
                    this.inputManager.setCursorVisible(false);
                } else {
                    this.rightMouseButton = false;
                    this.inputManager.setCursorVisible(true);
                }
            } else if (name.equals(KEYBOARD_RESET_POSE)) {
                if (keyPressed) {
                    this.resetPause();
                }
            } else if (name.equals(KEYBOARD_SAVE_POSE)) {
                if (keyPressed) {
                    this.savePose();
                }
            } else if (name.equals(KEYBOARD_GOTO_LAST_POSE)) {
                if (keyPressed) {
                    this.gotoLastPose();
                }
            } else if (name.equals(KEYBOARD_LEVEL_POSE)) {
                if (keyPressed) {
                    this.levelPose();
                }
            } else if (name.equals(KEYBOARD_HIGH_TRANSLATION_SPEED)) {
                this.setHighSpeedMotionEnabled(keyPressed);
            }
        }
    }

    public void onAnalog(String name, float value, float tpf) {
        if (this.isEnabled()) {
            if (name.equals(MOUSE_MOTION_LEFT)) {
                if (this.leftMouseButton) {
                    this.yawCamera(value);
                } else if (this.middleMouseButton) {
                    this.moveCameraLeftRight(value);
                } else if (this.rightMouseButton) {
                    this.moveCameraLeftRight(value);
                }
            } else if (name.equals(MOUSE_MOTION_RIGHT)) {
                if (this.leftMouseButton) {
                    this.yawCamera(-value);
                } else if (this.middleMouseButton) {
                    this.moveCameraLeftRight(-value);
                } else if (this.rightMouseButton) {
                    this.moveCameraLeftRight(-value);
                }
            } else if (name.equals(MOUSE_MOTION_UP)) {
                if (this.leftMouseButton) {
                    this.pitchCamera(-value);
                } else if (this.middleMouseButton) {
                    this.moveCameraForwardAft(value);
                } else if (this.rightMouseButton) {
                    this.moveCameraUpDown(value);
                }
            } else if (name.equals(MOUSE_MOTION_DOWN)) {
                if (this.leftMouseButton) {
                    this.pitchCamera(value);
                } else if (this.middleMouseButton) {
                    this.moveCameraForwardAft(-value);
                } else if (this.rightMouseButton) {
                    this.moveCameraUpDown(-value);
                }
            } else if (name.equals(MOUSE_MOTION_FORWARD)) {
                if (!this.leftMouseButton && this.middleMouseButton) {
                    this.moveCameraForwardAft(-value);
                }
            } else if (name.equals(MOUSE_MOTION_AFT) && !this.leftMouseButton && this.middleMouseButton) {
                this.moveCameraForwardAft(value);
            }
        }
        if (this.cameraPoseDirty) {
            this.updateCamera();
            this.cameraPoseDirty = false;
        }
    }

    @Override
    public void levelPose() {
        Vector3f v = new Vector3f(0.0f, 0.0f, 1.0f);
        v = this.currentOrientation.mult(v);
        v.z = 0.0f;
        v = v.normalize();
        this.currentOrientation.lookAt(v, new Vector3f(0.0f, 0.0f, 1.0f));
        this.updateCamera();
    }

    @Override
    public void setHighSpeedMotionEnabled(boolean highSpeedMotionEnabled) {
        this.highSpeedMotionEnabled = highSpeedMotionEnabled;
        this.translationSpeedMultiplier = highSpeedMotionEnabled ? (float)Activator.getDefault().getNavigationLinearHighSpeedFactor() : (float)Activator.getDefault().getNavigationLinearLowSpeedFactor();
    }

    private void setCamera(Camera camera) {
        this.cam = camera;
        this.currentLocation = this.cam.getLocation().clone();
        this.currentOrientation = this.cam.getRotation().clone();
        this.initialLocation = this.cam.getLocation().clone();
        this.initialOrientation = this.cam.getRotation().clone();
    }

    private void registerWithInput(InputManager inputManager) {
        this.inputManager = inputManager;
        inputManager.addMapping(LEFT_MOUSE_BUTTON, new Trigger[]{new MouseButtonTrigger(0)});
        inputManager.addMapping(MIDDLE_MOUSE_BUTTON, new Trigger[]{new MouseButtonTrigger(2)});
        inputManager.addMapping(RIGHT_MOUSE_BUTTON, new Trigger[]{new MouseButtonTrigger(1)});
        inputManager.addMapping(MOUSE_MOTION_LEFT, new Trigger[]{new MouseAxisTrigger(0, true)});
        inputManager.addMapping(MOUSE_MOTION_RIGHT, new Trigger[]{new MouseAxisTrigger(0, false)});
        inputManager.addMapping(MOUSE_MOTION_DOWN, new Trigger[]{new MouseAxisTrigger(1, true)});
        inputManager.addMapping(MOUSE_MOTION_UP, new Trigger[]{new MouseAxisTrigger(1, false)});
        inputManager.addMapping(MOUSE_MOTION_FORWARD, new Trigger[]{new MouseAxisTrigger(2, true)});
        inputManager.addMapping(MOUSE_MOTION_AFT, new Trigger[]{new MouseAxisTrigger(2, false)});
        inputManager.addMapping(KEYBOARD_SAVE_POSE, new Trigger[]{new KeyTrigger(31)});
        inputManager.addMapping(KEYBOARD_GOTO_LAST_POSE, new Trigger[]{new KeyTrigger(48)});
        inputManager.addMapping(KEYBOARD_RESET_POSE, new Trigger[]{new KeyTrigger(19)});
        inputManager.addMapping(KEYBOARD_LEVEL_POSE, new Trigger[]{new KeyTrigger(38)});
        inputManager.addMapping(KEYBOARD_HIGH_TRANSLATION_SPEED, new Trigger[]{new KeyTrigger(16)});
        inputManager.addListener((InputListener)this, this.inputs);
        this.inputsRegistered = true;
        this.updateCamera();
    }

    private void unregisterInput(InputManager inputManager) {
        int i = 0;
        while (i < this.inputs.length) {
            if (inputManager.hasMapping(this.inputs[i])) {
                inputManager.deleteMapping(this.inputs[i]);
            }
            ++i;
        }
        inputManager.removeListener((InputListener)this);
        this.inputsRegistered = false;
    }

    private void resetPause() {
        this.currentLocation = this.initialLocation.clone();
        this.currentOrientation = this.initialOrientation.clone();
    }

    private void gotoLastPose() {
        if (!this.poseStack.isEmpty()) {
            Matrix4f lastPose = this.poseStack.pop();
            this.currentLocation = lastPose.toTranslationVector().clone();
            this.currentOrientation = lastPose.toRotationQuat().clone();
        } else {
            this.currentLocation = this.initialLocation.clone();
            this.currentOrientation = this.initialOrientation.clone();
        }
    }

    private void savePose() {
        Matrix4f pose = new Matrix4f();
        pose.loadIdentity();
        pose.setTranslation(this.currentLocation.clone());
        pose.setRotationQuaternion(this.currentOrientation.clone());
        this.poseStack.push(pose);
    }

    private void yawCamera(float value) {
        if (this.rotationEnabled) {
            Quaternion delta = new Quaternion();
            delta.fromAngleAxis(value * this.rotationSpeed * 1.0f, new Vector3f(0.0f, 1.0f, 0.0f));
            this.currentOrientation = this.currentOrientation.mult(delta);
            this.updateCamera();
        }
    }

    private void pitchCamera(float value) {
        if (this.rotationEnabled) {
            Quaternion delta = new Quaternion();
            delta.fromAngleAxis(value * this.rotationSpeed * 1.0f, new Vector3f(1.0f, 0.0f, 0.0f));
            this.currentOrientation = this.currentOrientation.mult(delta);
            this.updateCamera();
        }
    }

    private void moveCameraForwardAft(float value) {
        if (this.translationEnabled) {
            Vector3f delta = new Vector3f(0.0f, 0.0f, value * this.translationSpeed * this.translationSpeedMultiplier);
            delta = this.currentOrientation.mult(delta);
            this.currentLocation = this.currentLocation.add(delta);
            this.updateCamera();
        }
    }

    private void moveCameraLeftRight(float value) {
        if (this.translationEnabled) {
            Vector3f delta = new Vector3f(value * this.translationSpeed * this.translationSpeedMultiplier, 0.0f, 0.0f);
            delta = this.currentOrientation.mult(delta);
            this.currentLocation = this.currentLocation.add(delta);
            this.updateCamera();
        }
    }

    private void moveCameraUpDown(float value) {
        if (this.translationEnabled) {
            Vector3f delta = new Vector3f(0.0f, value * this.translationSpeed * this.translationSpeedMultiplier, 0.0f);
            delta = this.currentOrientation.mult(delta);
            this.currentLocation = this.currentLocation.add(delta);
            this.updateCamera();
        }
    }

    public void updateCamera() {
        this.cameraPoseDirty = true;
        if (this.nodeToFollow != null) {
            Matrix4d transformMatrix = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.nodeToFollow);
            Transform transform = JME3Utilities.createTransform(transformMatrix);
            this.nodeFollower.setLocalTransform(transform);
        }
        if (this.cameraNode != null) {
            this.cameraNode.setLocalTranslation(this.currentLocation);
            this.cameraNode.setLocalRotation(this.currentOrientation);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setTranslationEnabled(boolean translationEnabled) {
        this.translationEnabled = translationEnabled;
    }

    @Override
    public void setRotationEnabled(boolean rotationEnabled) {
        this.rotationEnabled = rotationEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.leftMouseButton = false;
        this.middleMouseButton = false;
        this.rightMouseButton = false;
        if (!enabled) {
            if (this.sceneRoot != null) {
                this.sceneRoot.removeControl((Control)this);
            }
            if (this.inputsRegistered && this.inputManager != null) {
                this.unregisterInput(this.inputManager);
            }
        } else {
            if (this.sceneRoot != null && this.sceneRoot.getControl(CustomCameraControl.class) == null) {
                this.sceneRoot.addControl((Control)this);
            }
            if (!this.inputsRegistered) {
                this.registerWithInput(this.inputManager);
            }
        }
        this.enabled = enabled;
    }

    public Control cloneForSpatial(Spatial spatial) {
        CustomCameraControl cc = null;
        cc = spatial instanceof com.jme3.scene.Node ? new CustomCameraControl(this.cam, (com.jme3.scene.Node)spatial, this.inputManager, this.viewer) : new CustomCameraControl(this.cam, null, this.inputManager, this.viewer);
        return cc;
    }

    public void setSpatial(Spatial spatial) {
        if (spatial instanceof com.jme3.scene.Node) {
            this.sceneRoot = (com.jme3.scene.Node)spatial;
        }
    }

    public void update(float tpf) {
        if (this.enabled) {
            this.updateCamera();
        }
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void write(JmeExporter ex) throws IOException {
    }

    public void read(JmeImporter im) throws IOException {
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.translationSpeedMultiplier = this.highSpeedMotionEnabled ? (float)Activator.getDefault().getNavigationLinearHighSpeedFactor() : (float)Activator.getDefault().getNavigationLinearLowSpeedFactor();
    }
}

