/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.scene_objects;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.util.BufferUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ShadowMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3SceneObject;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultJME3SceneObject<T extends Node>
implements JME3SceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(DefaultJME3SceneObject.class);
    public static final float SELECTED_FLASHING_PERIOD_SECONDS = 0.5f;
    public static final float DEFAULT_FLAG_POLE_HEIGHT = 1.0f;
    public static final float FLAG_SIZE_PER_PIXEL = 0.005f;
    public static final ColorRGBA FLAG_POLE_COLOR = ColorRGBA.Yellow;
    public static final ColorRGBA FLAG_BACKGROUND_COLOR = ColorRGBA.Black;
    public static final ColorRGBA FLAG_TEXT_COLOR = ColorRGBA.Yellow;
    private T topologyNode;
    private com.jme3.scene.Node root;
    private com.jme3.scene.Node attachmentNode;
    protected boolean busy = false;
    protected ShadowMode shadowMode = ShadowMode.INHERIT;
    protected JME3RenderEngineDelegate jme3RenderEngineDelegate;
    protected JME3Application jme3Application = null;
    protected float transparency = 0.0f;
    private boolean visible = true;
    private boolean selected = false;
    private float timeElapsedSinceSelected = 0.0f;
    private AssetManager assetManager;
    private float idPoleHeight = 1.0f;
    private Geometry poleGeometry = null;
    private Geometry flagGeometry = null;
    private com.jme3.scene.Node pole = null;
    private com.jme3.scene.Node flag = null;
    private BillboardControl billboardControl;
    private boolean idVisible = false;
    private long currentUpdateCount = 0L;
    private long lastUpdateCount = -1L;
    private AbstractControl updateControl = null;

    public DefaultJME3SceneObject(T topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        try {
            if (topologyNode == null || jme3RenderEngineDelegate == null) {
                throw new IllegalArgumentException();
            }
            this.jme3Application = jme3RenderEngineDelegate.getJME3Application();
            this.topologyNode = topologyNode;
            this.jme3Application.getAssetManager().registerLocator("/", FileLocator.class);
            this.jme3RenderEngineDelegate = jme3RenderEngineDelegate;
            this.assetManager = this.jme3Application.getAssetManager();
            this.setVisible(true);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        Job job = new Job("DefaultJME3SceneObject : Updating Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                DefaultJME3SceneObject.this.updateGeometry();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.updateControl = new AbstractControl(){

            protected void controlUpdate(float tpf) {
                if (DefaultJME3SceneObject.this.currentUpdateCount != DefaultJME3SceneObject.this.lastUpdateCount) {
                    DefaultJME3SceneObject.this.lastUpdateCount = DefaultJME3SceneObject.this.currentUpdateCount;
                    if (DefaultJME3SceneObject.this.getTopologyNode() != null) {
                        try {
                            DefaultJME3SceneObject.this.updateGeometry(tpf);
                        }
                        catch (Throwable t) {
                            Logger.error(t.getMessage(), t);
                        }
                    }
                }
                DefaultJME3SceneObject defaultJME3SceneObject = DefaultJME3SceneObject.this;
                defaultJME3SceneObject.timeElapsedSinceSelected = defaultJME3SceneObject.timeElapsedSinceSelected + tpf;
                DefaultJME3SceneObject.this.updateSelected(DefaultJME3SceneObject.this.selected, DefaultJME3SceneObject.this.timeElapsedSinceSelected);
            }

            protected void controlRender(RenderManager arg0, ViewPort arg1) {
            }
        };
        this.getRoot().addControl((Control)this.updateControl);
    }

    public void requestUpdate() {
        ++this.currentUpdateCount;
    }

    public void updateGeometry(float tpf) {
    }

    public T getTopologyNode() {
        return this.topologyNode;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultJME3SceneObject.this.isVisible()) {
                    if (!DefaultJME3SceneObject.this.getRoot().hasChild((Spatial)DefaultJME3SceneObject.this.getAttachmentNode())) {
                        DefaultJME3SceneObject.this.getRoot().attachChild((Spatial)DefaultJME3SceneObject.this.getAttachmentNode());
                    }
                } else if (DefaultJME3SceneObject.this.getRoot().hasChild((Spatial)DefaultJME3SceneObject.this.getAttachmentNode())) {
                    DefaultJME3SceneObject.this.getRoot().detachChild((Spatial)DefaultJME3SceneObject.this.getAttachmentNode());
                }
                return null;
            }
        });
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.timeElapsedSinceSelected = 0.0f;
        }
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setShadowMode(final ShadowMode shadowMode) {
        Logger.info("Setting Shadow Mode to <" + shadowMode + ">...");
        this.shadowMode = shadowMode;
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultJME3SceneObject.this.getRoot() != null) {
                    DefaultJME3SceneObject.this.getRoot().setShadowMode(JME3Utilities.convertToJMEShadowMode(shadowMode));
                }
                return null;
            }
        });
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public Tuple3d getMin() {
        Point3d min = null;
        BoundingVolume bounds = this.getBounds();
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            Vector3f center = boundingSphere.getCenter();
            double[] minValues = new double[3];
            int i = 0;
            while (i < minValues.length) {
                minValues[i] = center.get(i) - boundingSphere.getRadius();
                ++i;
            }
            min = new Point3d(minValues);
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            Vector3f vMin = new Vector3f();
            boundingBox.getMin(vMin);
            min = new Point3d((double)vMin.x, (double)vMin.y, (double)vMin.z);
        }
        return min;
    }

    public Tuple3d getMax() {
        Point3d max = null;
        BoundingVolume bounds = this.getBounds();
        if (bounds instanceof BoundingSphere) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            Vector3f center = boundingSphere.getCenter();
            double[] minValues = new double[3];
            int i = 0;
            while (i < minValues.length) {
                minValues[i] = center.get(i) + boundingSphere.getRadius();
                ++i;
            }
            max = new Point3d(minValues);
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            Vector3f vMax = new Vector3f();
            boundingBox.getMax(vMax);
            max = new Point3d((double)vMax.x, (double)vMax.y, (double)vMax.z);
        }
        return max;
    }

    public Point3d getCentroid() {
        Vector3f center = this.getBounds().getCenter();
        return new Point3d((double)center.x, (double)center.y, (double)center.z);
    }

    @Override
    public com.jme3.scene.Node getRoot() {
        if (this.root == null) {
            String name = null;
            name = this.getTopologyNode() != null && this.getTopologyNode().getNodeId() != null ? this.getTopologyNode().getNodeId() : this.getClass().getSimpleName();
            name = String.valueOf(name) + "_root";
            this.root = new com.jme3.scene.Node(name);
        }
        return this.root;
    }

    @Override
    public com.jme3.scene.Node getAttachmentNode() {
        if (this.attachmentNode == null) {
            String name = null;
            name = this.getTopologyNode() != null && this.getTopologyNode().getNodeId() != null ? this.getTopologyNode().getNodeId() : this.getClass().getSimpleName();
            name = String.valueOf(name) + "_attachement";
            this.attachmentNode = new com.jme3.scene.Node(name);
        }
        return this.attachmentNode;
    }

    @Override
    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.poleGeometry != null) {
            geometries.add(this.poleGeometry);
        }
        if (this.flagGeometry != null) {
            geometries.add(this.flagGeometry);
        }
        return geometries;
    }

    @Override
    public BoundingVolume getBounds() {
        BoundingVolume bounds = null;
        for (Geometry geometry : this.getGeometries()) {
            if (geometry == null) continue;
            if (bounds == null) {
                bounds = geometry.getModelBound();
                continue;
            }
            if (geometry.getModelBound() == null) continue;
            bounds.merge(geometry.getModelBound());
        }
        return bounds;
    }

    @Override
    public Application getApplication() {
        return this.jme3Application;
    }

    @Override
    public void dispose() {
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultJME3SceneObject.this.root != null) {
                    if (DefaultJME3SceneObject.this.root.getParent() != null) {
                        DefaultJME3SceneObject.this.root.getParent().detachChild((Spatial)DefaultJME3SceneObject.this.root);
                    } else {
                        DefaultJME3SceneObject.this.root.detachAllChildren();
                    }
                }
                DefaultJME3SceneObject.this.topologyNode = null;
                DefaultJME3SceneObject.this.root = null;
                DefaultJME3SceneObject.this.attachmentNode = null;
                return null;
            }
        });
    }

    public void setIDPoleHeight(float idPoleHeight) {
        if (idPoleHeight > 0.0f) {
            this.idPoleHeight = idPoleHeight;
        }
    }

    public void setIDVisible(boolean visible) {
        this.idVisible = visible;
        this.updateGeometry();
    }

    public RGB getColor() {
        return null;
    }

    public void setColor(RGB rgb) {
    }

    public void objectSelected() {
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency < 0.0f ? 0.0f : (transparency > 1.0f ? 1.0f : transparency);
    }

    protected void updateSelected(boolean selected, float timeElapsedSinceSelected) {
        if (selected) {
            int numberOfPeriods = (int)Math.floor(timeElapsedSinceSelected / 0.5f);
            if (numberOfPeriods % 2 == 0) {
                if (!this.getRoot().hasChild((Spatial)this.getAttachmentNode())) {
                    this.getRoot().attachChild((Spatial)this.getAttachmentNode());
                }
            } else if (this.getRoot().hasChild((Spatial)this.getAttachmentNode())) {
                this.getRoot().detachChild((Spatial)this.getAttachmentNode());
            }
        } else if (this.isVisible()) {
            if (!this.getRoot().hasChild((Spatial)this.getAttachmentNode())) {
                this.getRoot().attachChild((Spatial)this.getAttachmentNode());
            }
        } else if (this.getRoot().hasChild((Spatial)this.getAttachmentNode())) {
            this.getRoot().detachChild((Spatial)this.getAttachmentNode());
        }
    }

    private void updateGeometry() {
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultJME3SceneObject.this.pole != null) {
                    DefaultJME3SceneObject.this.getAttachmentNode().detachChild((Spatial)DefaultJME3SceneObject.this.pole);
                }
                if (DefaultJME3SceneObject.this.flag != null) {
                    DefaultJME3SceneObject.this.getAttachmentNode().detachChild((Spatial)DefaultJME3SceneObject.this.flag);
                }
                DefaultJME3SceneObject.this.poleGeometry = null;
                DefaultJME3SceneObject.this.flagGeometry = null;
                DefaultJME3SceneObject.this.getBillboardControl().setSpatial(null);
                if (DefaultJME3SceneObject.this.idVisible) {
                    DefaultJME3SceneObject.this.pole = DefaultJME3SceneObject.this.createPole(DefaultJME3SceneObject.this.idPoleHeight);
                    DefaultJME3SceneObject.this.getAttachmentNode().attachChild((Spatial)DefaultJME3SceneObject.this.pole);
                    DefaultJME3SceneObject.this.flag = DefaultJME3SceneObject.this.createFlag(DefaultJME3SceneObject.this.getFlagText(), 16);
                    DefaultJME3SceneObject.this.pole.attachChild((Spatial)DefaultJME3SceneObject.this.flag);
                }
                return null;
            }
        });
    }

    private com.jme3.scene.Node createPole(float poleHeight) {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f p1 = new Vector3f(0.0f, 0.0f, poleHeight);
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        this.poleGeometry = new Geometry("Pole", mesh);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", FLAG_POLE_COLOR.clone());
        this.poleGeometry.setMaterial(mat);
        com.jme3.scene.Node node = new com.jme3.scene.Node("Pole.");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        node.attachChild((Spatial)this.poleGeometry);
        return node;
    }

    private String getFlagText() {
        String text = null;
        if (this.getTopologyNode() != null) {
            text = this.getTopologyNode().getNodeId();
        }
        if (text == null || text.length() == 0) {
            text = "?";
        }
        return text;
    }

    private com.jme3.scene.Node createFlag(String text, int fontSize) {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Flag");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        com.jme3.scene.Node flagAttachmentPoint = new com.jme3.scene.Node("Flag Attachment Point");
        flagAttachmentPoint.setLocalTranslation(0.0f, 0.0f, this.idPoleHeight);
        node.attachChild((Spatial)flagAttachmentPoint);
        Font font = new Font("Serif", 1, fontSize);
        BufferedImage bufferedImage = this.createTextImage(text, font, 2);
        float flagWidth = 0.005f * (float)bufferedImage.getWidth();
        float flagHeight = 0.005f * (float)bufferedImage.getHeight();
        Mesh flagMesh = this.createFlagMesh(flagWidth, flagHeight);
        this.flagGeometry = new Geometry("Flag Geometry", flagMesh);
        Material mat = JME3Utilities.createMaterial(bufferedImage, this.assetManager);
        this.flagGeometry.setMaterial(mat);
        flagAttachmentPoint.addControl((Control)this.getBillboardControl());
        flagAttachmentPoint.attachChild((Spatial)this.flagGeometry);
        return node;
    }

    private Mesh createFlagMesh(float flagWidth, float flagHeight) {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(flagWidth, 0.0f, 0.0f), new Vector3f(0.0f, flagHeight, 0.0f), new Vector3f(flagWidth, flagHeight, 0.0f)};
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        int[] indexes = nArray;
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private BillboardControl getBillboardControl() {
        if (this.billboardControl == null) {
            this.billboardControl = new BillboardControl();
            this.billboardControl.setAlignment(BillboardControl.Alignment.Screen);
        }
        return this.billboardControl;
    }

    private BufferedImage createTextImage(String text, Font font, int borderWidth) {
        Color textColor = JME3Utilities.convertToAWTColor(FLAG_TEXT_COLOR);
        Color backgroundColor = JME3Utilities.convertToAWTColor(FLAG_BACKGROUND_COLOR);
        AbstractEImage original = EImagesUtilities.INSTANCE.createTextImage(text, font, textColor, backgroundColor, borderWidth);
        int[] borderColor = JME3Utilities.convertToColorIntRGBA(FLAG_POLE_COLOR);
        AbstractEImage imageWithBorder = EImagesUtilities.INSTANCE.addBorder(original, borderWidth, borderColor[0], borderColor[1], borderColor[2]);
        return imageWithBorder.asBufferedImage();
    }
}

