/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.AbstractNodeVisitor;
import org.eclipse.apogy.common.topology.AggregateContentNode;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Link;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodeFilter;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.PickAndPlaceNode;
import org.eclipse.apogy.common.topology.PositionNode;
import org.eclipse.apogy.common.topology.ReferencedContentNode;
import org.eclipse.apogy.common.topology.RotationNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.impl.ApogyCommonTopologyFacadeImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;

public class ApogyCommonTopologyFacadeCustomImpl
extends ApogyCommonTopologyFacadeImpl {
    private static final String NULL_NODE_ID_STRING = "NULL";

    @Override
    public <T> ContentNode<T> createContentNode(T content) {
        return this.createAggregateContentNode(content);
    }

    @Override
    public PositionNode createPositionNode(double x, double y, double z) {
        PositionNode node = ApogyCommonTopologyFactory.eINSTANCE.createPositionNode();
        Tuple3d position = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        node.setPosition(position);
        node.getPosition().setX(x);
        node.getPosition().setY(y);
        node.getPosition().setZ(z);
        return node;
    }

    @Override
    public RotationNode createRotationNodeXYZ(double x, double y, double z) {
        RotationNode node = ApogyCommonTopologyFactory.eINSTANCE.createRotationNode();
        Matrix3d rotationMatrix = GeometricUtils.packXYZ((double)x, (double)y, (double)z);
        Matrix3x3 matrix = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotationMatrix);
        node.setRotationMatrix(matrix);
        return node;
    }

    @Override
    public Matrix4d expressRootInNodeFrame(Node node) {
        Matrix4d mat = this.expressNodeInRootFrame(node);
        mat.invert();
        return mat;
    }

    @Override
    public Matrix4d expressInFrame(Node sourceFrame, Node targetFrame) {
        Matrix4d sourceFrameToRoot = this.expressNodeInRootFrame(sourceFrame);
        Matrix4d rootToTargetFrame = this.expressNodeInRootFrame(targetFrame);
        rootToTargetFrame.invert();
        rootToTargetFrame.mul(sourceFrameToRoot);
        return rootToTargetFrame;
    }

    @Override
    public RotationNode createRotationNodeYZX(double x, double y, double z) {
        RotationNode node = ApogyCommonTopologyFactory.eINSTANCE.createRotationNode();
        Matrix3d rotationMatrix = GeometricUtils.packYZX((double)x, (double)y, (double)z);
        Matrix3x3 matrix = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotationMatrix);
        node.setRotationMatrix(matrix);
        return node;
    }

    @Override
    public RotationNode createRotationNodeZYX(double x, double y, double z) {
        RotationNode node = ApogyCommonTopologyFactory.eINSTANCE.createRotationNode();
        Matrix3d rotationMatrix = GeometricUtils.packZYX((double)x, (double)y, (double)z);
        Matrix3x3 matrix = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotationMatrix);
        node.setRotationMatrix(matrix);
        return node;
    }

    @Override
    public TransformNode createTransformNodeXYZ(double tx, double ty, double tz, double rx, double ry, double rz) {
        RotationNode rotationNode = this.createRotationNodeXYZ(rx, ry, rz);
        Tuple3d translation = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        translation.setX(tx);
        translation.setY(ty);
        translation.setZ(tz);
        TransformNode trNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
        trNode.setRotationMatrix(rotationNode.getRotationMatrix());
        trNode.setPosition(translation);
        return trNode;
    }

    @Override
    public TransformNode createTransformNodeYZX(double tx, double ty, double tz, double rx, double ry, double rz) {
        RotationNode rotationNode = this.createRotationNodeYZX(rx, ry, rz);
        Tuple3d translation = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        translation.setX(tx);
        translation.setY(ty);
        translation.setZ(tz);
        TransformNode trNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
        trNode.setRotationMatrix(rotationNode.getRotationMatrix());
        trNode.setPosition(translation);
        return trNode;
    }

    @Override
    public TransformNode createTransformNodeZYX(double tx, double ty, double tz, double rx, double ry, double rz) {
        RotationNode rotationNode = this.createRotationNodeZYX(rx, ry, rz);
        Tuple3d translation = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        translation.setX(tx);
        translation.setY(ty);
        translation.setZ(tz);
        TransformNode trNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
        trNode.setRotationMatrix(rotationNode.getRotationMatrix());
        trNode.setPosition(translation);
        return trNode;
    }

    @Override
    public TransformNode createTransformNode(Matrix4d matrix) {
        TransformNode tn = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
        tn.setTransformation(matrix);
        return tn;
    }

    @Override
    public PickAndPlaceNode createPickAndPlaceNode(Matrix4d matrix) {
        PickAndPlaceNode pnpn = ApogyCommonTopologyFactory.eINSTANCE.createPickAndPlaceNode();
        pnpn.setTransformation(matrix);
        return pnpn;
    }

    @Override
    public AttachedViewPoint createAttachedViewPoint(Node attachmentNode) {
        AttachedViewPoint attachedViewPoint = ApogyCommonTopologyFactory.eINSTANCE.createAttachedViewPoint();
        if (attachmentNode != null) {
            Node root = ApogyCommonTopologyFacade.INSTANCE.findRoot(attachmentNode);
            NodePath nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath(root, attachmentNode);
            attachedViewPoint.setNodePath(nodePath);
        }
        return attachedViewPoint;
    }

    @Override
    public void printTopology(Node node) {
        System.out.println("graph G {");
        this.printTopology(node, null);
        System.out.println("}");
    }

    @Override
    public Collection<Node> filter(NodeFilter filter, Collection<Node> nodes) {
        ArrayList<Node> matches = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!filter.matches(node)) continue;
            matches.add(node);
        }
        return matches;
    }

    @Override
    public <T> ReferencedContentNode<T> createReferencedContentNode(T content) {
        ReferencedContentNode<T> contentNode = ApogyCommonTopologyFactory.eINSTANCE.createReferencedContentNode();
        contentNode.setContent(content);
        return contentNode;
    }

    @Override
    public <T> AggregateContentNode<T> createAggregateContentNode(T content) {
        AggregateContentNode<T> contentNode = ApogyCommonTopologyFactory.eINSTANCE.createAggregateContentNode();
        contentNode.setContent(content);
        return contentNode;
    }

    @Override
    public Link createLink(Node node) {
        Link link = ApogyCommonTopologyFactory.eINSTANCE.createLink();
        link.setNode(node);
        return link;
    }

    @Override
    public EList<Node> findNodesByDescription(String description, Node topology) {
        final String fDescription = description;
        BasicEList matches = new BasicEList();
        AbstractNodeVisitor visitor = new AbstractNodeVisitor((EList)matches){
            private final /* synthetic */ EList val$matches;
            {
                this.val$matches = eList;
            }

            @Override
            public void visit(Node node) {
                if (node.getDescription() == null && fDescription == null) {
                    this.val$matches.add((Object)node);
                } else if (node.getDescription() != null && node.getDescription().equals(fDescription)) {
                    this.val$matches.add((Object)node);
                }
            }
        };
        topology.accept(visitor);
        return matches;
    }

    @Override
    public EList<Node> findNodesByID(String id, Node topology) {
        final String fId = id;
        BasicEList matches = new BasicEList();
        AbstractNodeVisitor visitor = new AbstractNodeVisitor((EList)matches){
            private final /* synthetic */ EList val$matches;
            {
                this.val$matches = eList;
            }

            @Override
            public void visit(Node node) {
                if (node.getNodeId() == null && fId == null) {
                    this.val$matches.add((Object)node);
                } else if (node.getNodeId() != null && node.getNodeId().equals(fId)) {
                    this.val$matches.add((Object)node);
                }
            }
        };
        topology.accept(visitor);
        return matches;
    }

    @Override
    public EList<Node> findNodesByType(final EClass clazz, Node topology) {
        BasicEList matches = new BasicEList();
        AbstractNodeVisitor visitor = new AbstractNodeVisitor((EList)matches){
            private final /* synthetic */ EList val$matches;
            {
                this.val$matches = eList;
            }

            @Override
            public void visit(Node node) {
                if (clazz.isSuperTypeOf(node.eClass())) {
                    this.val$matches.add((Object)node);
                }
            }
        };
        topology.accept(visitor);
        return matches;
    }

    @Override
    public Node findRoot(Node node) {
        Node current = node;
        Node root = node;
        while (current != null) {
            root = current;
            current = current.getParent();
        }
        return root;
    }

    @Override
    public boolean doNodesShareTopologyTree(Node node1, Node node2) {
        Node root2;
        Node root1 = this.findRoot(node1);
        return root1 == (root2 = this.findRoot(node2));
    }

    @Override
    public double getEuclideanDistance(Node fromNode, Node toNode) {
        if (fromNode == toNode) {
            return 0.0;
        }
        if (this.doNodesShareTopologyTree(fromNode, toNode)) {
            Matrix4d m = this.expressInFrame(fromNode, toNode);
            Vector3d v = new Vector3d();
            m.get(v);
            return v.length();
        }
        return Double.NaN;
    }

    @Override
    public double getGeodesicDistance(Node fromNode, Node toNode) {
        if (fromNode == toNode) {
            return 0.0;
        }
        if (this.doNodesShareTopologyTree(fromNode, toNode)) {
            List<Node> nodePath = this.findNodePath(fromNode, toNode);
            double distance = 0.0;
            Node currentNode = null;
            Node previousNode = null;
            int i = 0;
            while (i < nodePath.size()) {
                currentNode = nodePath.get(i);
                if (previousNode != null && currentNode != null) {
                    distance += this.getEuclideanDistance(previousNode, currentNode);
                }
                previousNode = currentNode;
                ++i;
            }
            return distance;
        }
        return Double.NaN;
    }

    @Override
    public List<Node> findNodePath(Node fromNode, Node toNode) {
        if (this.doNodesShareTopologyTree(fromNode, toNode)) {
            Node node;
            if (fromNode == toNode) {
                ArrayList<Node> nodePath = new ArrayList<Node>();
                nodePath.add(fromNode);
                return nodePath;
            }
            Node current = fromNode;
            ArrayList<Node> fromToRootList = new ArrayList<Node>();
            while (current != null) {
                fromToRootList.add(current);
                current = current.getParent();
            }
            current = toNode;
            ArrayList<Node> toToRootList = new ArrayList<Node>();
            while (current != null) {
                toToRootList.add(current);
                current = current.getParent();
            }
            Node intersectionNode = null;
            Iterator iterator = fromToRootList.iterator();
            while (intersectionNode == null && iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!toToRootList.contains(node2)) continue;
                intersectionNode = node2;
            }
            if (intersectionNode == null) {
                return new ArrayList<Node>();
            }
            ArrayList<Node> nodePath = new ArrayList<Node>();
            int index = 0;
            boolean stop = false;
            while (!stop && index < fromToRootList.size()) {
                node = (Node)fromToRootList.get(index);
                if (node == intersectionNode) {
                    stop = true;
                } else {
                    nodePath.add(node);
                }
                ++index;
            }
            index = toToRootList.indexOf(intersectionNode);
            while (index >= 0) {
                node = (Node)toToRootList.get(index);
                nodePath.add(node);
                --index;
            }
            return nodePath;
        }
        return new ArrayList<Node>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NodePath createNodePath(Node fromNode, Node toNode) {
        NodePath nodePath = null;
        Node current = toNode;
        ArrayList<Node> toToFromList = new ArrayList<Node>();
        toToFromList.add(current);
        while (current != null && current != fromNode) {
            if ((current = current.getParent()) == null) continue;
            toToFromList.add(current);
        }
        if (toToFromList.size() <= 0) return ApogyCommonTopologyFactory.eINSTANCE.createNodePath();
        if (toToFromList.get(toToFromList.size() - 1) != fromNode) return null;
        nodePath = ApogyCommonTopologyFactory.eINSTANCE.createNodePath();
        int i = toToFromList.size() - 1;
        while (i >= 0) {
            Node node = (Node)toToFromList.get(i);
            if (node.getNodeId() == null) {
                nodePath.getNodeIds().add((Object)NULL_NODE_ID_STRING);
            } else {
                nodePath.getNodeIds().add((Object)node.getNodeId());
            }
            --i;
        }
        return nodePath;
    }

    @Override
    public Node resolveNode(Node root, NodePath nodePath) {
        Object result = null;
        int level = 0;
        HashSet<Node> s = new HashSet<Node>();
        ArrayDeque<Node> q = new ArrayDeque<Node>();
        s.add(root);
        q.add(root);
        Node current = null;
        while (!q.isEmpty() && result == null && level < nodePath.getNodeIds().size()) {
            current = (Node)q.poll();
            String nodeId = current.getNodeId();
            if (nodeId == null) {
                nodeId = NULL_NODE_ID_STRING;
            }
            if (nodeId.compareTo((String)nodePath.getNodeIds().get(level)) != 0 || !(current instanceof GroupNode)) continue;
            ++level;
            GroupNode groupNode = (GroupNode)current;
            for (Node child : groupNode.getChildren()) {
                nodeId = child.getNodeId();
                if (nodeId == null) {
                    nodeId = NULL_NODE_ID_STRING;
                }
                if (nodeId.compareTo((String)nodePath.getNodeIds().get(level)) != 0) continue;
                if (level == nodePath.getNodeIds().size() - 1) {
                    return child;
                }
                if (s.contains(child)) continue;
                s.add(child);
                q.add(child);
            }
        }
        return null;
    }

    private void printTopology(Node currentNode, Node parentNode) {
        if (parentNode == null && !(currentNode instanceof GroupNode)) {
            System.out.println(currentNode.getNodeId());
        } else if (parentNode != null) {
            System.out.println("\"" + parentNode.getNodeId() + "\" -- \"" + currentNode.getNodeId() + "\"");
        }
        if (currentNode instanceof GroupNode) {
            GroupNode groupNode = (GroupNode)currentNode;
            for (Node node : groupNode.getChildren()) {
                this.printTopology(node, currentNode);
            }
        }
    }

    @Override
    public Matrix4d expressNodeInRootFrame(Node node) {
        List<Matrix4d> matrices = this.computeMatrixList(node);
        return this.computeMatrix(matrices, true);
    }

    private List<Matrix4d> computeMatrixList(Node node) {
        Matrix4d transformationMatrix = new Matrix4d();
        transformationMatrix.setIdentity();
        Stack<Matrix4d> matrices = new Stack<Matrix4d>();
        Node currentNode = node;
        while (currentNode != null) {
            Matrix4d nodeMatrix = null;
            if (currentNode instanceof TransformNode) {
                TransformNode tnode = (TransformNode)currentNode;
                nodeMatrix = tnode.asMatrix4d();
            } else if (currentNode instanceof PositionNode) {
                PositionNode pNode = (PositionNode)currentNode;
                nodeMatrix = new Matrix4d();
                nodeMatrix.setIdentity();
                nodeMatrix.setTranslation(new Vector3d(pNode.getPosition().asTuple3d()));
            } else if (currentNode instanceof RotationNode) {
                RotationNode rNode = (RotationNode)currentNode;
                nodeMatrix = new Matrix4d();
                nodeMatrix.setIdentity();
                nodeMatrix.setRotation(rNode.getRotationMatrix().asMatrix3d());
            }
            if (nodeMatrix != null) {
                matrices.push(nodeMatrix);
            }
            currentNode = currentNode.getParent();
        }
        return matrices;
    }

    private Matrix4d computeMatrix(List<Matrix4d> matrices, boolean reverse) {
        Matrix4d result = new Matrix4d();
        result.setIdentity();
        while (!matrices.isEmpty()) {
            Matrix4d matrix = null;
            matrix = reverse ? matrices.remove(matrices.size() - 1) : matrices.remove(0);
            result.mul(matrix);
        }
        return result;
    }
}

