/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.ui.wizards.NamedDescribedWizardPage;
import org.eclipse.apogy.common.ui.ApogyCommonUiFacade;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.ui.ApogyWorkspaceUiFactory;
import org.eclipse.apogy.workspace.ui.NewProjectSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewProjectWizard
extends Wizard {
    private static final Logger Logger = LoggerFactory.getLogger(NewProjectWizard.class);
    private final NamedDescribedWizardPage namedDescribedWizardPage;
    private NewProjectSettings newProjectSettings;

    public NewProjectWizard() {
        this.setWindowTitle("New Apogy Project");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ApogyCommonUiFacade.INSTANCE.getImageDescriptor("platform:/plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()) + "/icons/wizban/apogy.png"));
        this.namedDescribedWizardPage = new NamedDescribedWizardPage(this.getNewApogyProjectSettings(), this.getNewApogyProjectSettings()){

            protected void validate() {
                super.validate();
                if (ApogyWorkspaceFacade.INSTANCE.isProjectExists(NewProjectWizard.this.getNewApogyProjectSettings().getName())) {
                    this.setErrorMessage("A project with the same name already exists");
                    this.setPageComplete(false);
                }
            }
        };
    }

    public void addPages() {
        this.addPage((IWizardPage)this.namedDescribedWizardPage);
    }

    private NewProjectSettings getNewApogyProjectSettings() {
        if (this.newProjectSettings == null) {
            this.newProjectSettings = ApogyWorkspaceUiFactory.eINSTANCE.createNewProjectSettings();
            this.newProjectSettings.applyDefaultValues();
        }
        return this.newProjectSettings;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation apogyPojectOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        IProject project = ApogyWorkspaceFacade.INSTANCE.createApogyProject(NewProjectWizard.this.getNewApogyProjectSettings().getName(), NewProjectWizard.this.getNewApogyProjectSettings().getDescription());
                        ApogyWorkspaceFacade.INSTANCE.openApogyProject(project);
                    }
                    catch (Exception e) {
                        Logger.error("Problems occured while creating project <" + NewProjectWizard.this.getNewApogyProjectSettings().getName() + ">.", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)apogyPojectOperation);
        }
        catch (Exception e) {
            Logger.error("Problems occured while creating project <" + this.getNewApogyProjectSettings().getName() + ">.", (Throwable)e);
        }
        return true;
    }
}

