/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompilerInput
implements SourceAst,
DependencyInfo {
    static final DiagnosticType MODULE_CONFLICT = DiagnosticType.warning("JSC_MODULE_CONFLICT", "File has both goog.module and ES6 modules: {0}");
    private static final long serialVersionUID = 1L;
    private JSModule module;
    private final InputId id;
    private final SourceAst ast;
    private final Map<String, String> loadFlags = new TreeMap<String, String>();
    private final Set<String> provides = new HashSet<String>();
    private final Set<String> requires = new HashSet<String>();
    private boolean generatedDependencyInfoFromSource = false;
    private boolean generatedLoadFlags = false;
    private transient AbstractCompiler compiler;

    public CompilerInput(SourceAst ast) {
        this(ast, ast.getSourceFile().getName(), false);
    }

    public CompilerInput(SourceAst ast, boolean isExtern) {
        this(ast, ast.getInputId(), isExtern);
    }

    public CompilerInput(SourceAst ast, String inputId, boolean isExtern) {
        this(ast, new InputId(inputId), isExtern);
    }

    public CompilerInput(SourceAst ast, InputId inputId, boolean isExtern) {
        this.ast = ast;
        this.id = inputId;
        if (ast != null && ast.getSourceFile() != null) {
            ast.getSourceFile().setIsExtern(isExtern);
        }
    }

    public CompilerInput(SourceFile file) {
        this(file, false);
    }

    public CompilerInput(SourceFile file, boolean isExtern) {
        this(new JsAst(file), isExtern);
    }

    @Override
    public InputId getInputId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id.getIdName();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        Node root = this.ast.getAstRoot(compiler);
        if (root != null) {
            Preconditions.checkState((boolean)root.isScript());
            Preconditions.checkNotNull((Object)root.getInputId());
        }
        return root;
    }

    @Override
    public void clearAst() {
        this.ast.clearAst();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.ast.getSourceFile();
    }

    @Override
    public void setSourceFile(SourceFile file) {
        this.ast.setSourceFile(file);
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void checkErrorManager() {
        Preconditions.checkNotNull((Object)this.compiler, (String)"Expected setCompiler to be called first: %s", (Object[])new Object[]{this});
        Preconditions.checkNotNull((Object)this.compiler.getErrorManager(), (String)"Expected compiler to call an error manager: %s", (Object[])new Object[]{this});
    }

    @Override
    public Collection<String> getRequires() {
        this.checkErrorManager();
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.requires);
        }
        catch (IOException e) {
            this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    @Override
    public Collection<String> getProvides() {
        this.checkErrorManager();
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.provides);
        }
        catch (IOException e) {
            this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    public void addProvide(String provide) {
        this.getProvides();
        this.provides.add(provide);
    }

    public void addRequire(String require) {
        this.getRequires();
        this.requires.add(require);
    }

    private void regenerateDependencyInfoIfNecessary() throws IOException {
        if (!(this.ast instanceof JsAst)) {
            Preconditions.checkNotNull((Object)this.compiler, (Object)"Expected setCompiler to be called first");
            DepsFinder finder = new DepsFinder();
            Node root = this.getAstRoot(this.compiler);
            if (root == null) {
                return;
            }
            finder.visitTree(this.getAstRoot(this.compiler));
            this.loadFlags.putAll(finder.loadFlags);
            this.provides.addAll(finder.provides);
            this.requires.addAll(finder.requires);
            this.generatedLoadFlags = true;
        } else if (!this.generatedDependencyInfoFromSource) {
            DependencyInfo info = new JsFileParser(this.compiler.getErrorManager()).setIncludeGoogBase(true).parseFile(this.getName(), this.getName(), this.getCode());
            this.loadFlags.putAll((Map<String, String>)info.getLoadFlags());
            this.provides.addAll(info.getProvides());
            this.requires.addAll(info.getRequires());
            this.generatedDependencyInfoFromSource = true;
        }
    }

    private void determineLoadFlagsIfNecessary() throws IOException {
        this.regenerateDependencyInfoIfNecessary();
        if (!this.generatedLoadFlags) {
            FeatureSet features = ((JsAst)this.ast).getFeatures(this.compiler);
            if (features.hasEs6Modules()) {
                if (this.loadFlags.containsKey("module")) {
                    this.compiler.getErrorManager().report(CheckLevel.WARNING, JSError.make(MODULE_CONFLICT, this.getName()));
                }
                this.loadFlags.put("module", "es6");
            }
            this.loadFlags.put("lang", features.version());
            this.generatedLoadFlags = true;
        }
    }

    public String getCode() throws IOException {
        return this.getSourceFile().getCode();
    }

    public JSModule getModule() {
        return this.module;
    }

    public void setModule(JSModule module) {
        Preconditions.checkArgument((module == null || this.module == null || this.module == module ? 1 : 0) != 0);
        this.module = module;
    }

    void overrideModule(JSModule module) {
        this.module = module;
    }

    public boolean isExtern() {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return false;
        }
        return this.ast.getSourceFile().isExtern();
    }

    void setIsExtern(boolean isExtern) {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return;
        }
        this.ast.getSourceFile().setIsExtern(isExtern);
    }

    public int getLineOffset(int lineno) {
        return this.ast.getSourceFile().getLineOffset(lineno);
    }

    public int getNumLines() {
        return this.ast.getSourceFile().getNumLines();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        this.checkErrorManager();
        try {
            this.determineLoadFlagsIfNecessary();
            return ImmutableMap.copyOf(this.loadFlags);
        }
        catch (IOException e) {
            this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableMap.of();
        }
    }

    @Override
    public boolean isModule() {
        return "goog".equals(this.getLoadFlags().get((Object)"module"));
    }

    private static class DepsFinder {
        private final Map<String, String> loadFlags = new TreeMap<String, String>();
        private final List<String> provides = new ArrayList<String>();
        private final List<String> requires = new ArrayList<String>();
        private final CodingConvention codingConvention = new ClosureCodingConvention();

        private DepsFinder() {
        }

        void visitTree(Node n) {
            this.visitSubtree(n, null);
        }

        void visitSubtree(Node n, Node parent) {
            if (n.isCall()) {
                String provide;
                String require;
                boolean isModuleDetected = this.codingConvention.extractIsModuleFile(n, parent);
                if (isModuleDetected) {
                    this.loadFlags.put("module", "goog");
                }
                if ((require = this.codingConvention.extractClassNameIfRequire(n, parent)) != null) {
                    this.requires.add(require);
                }
                if ((provide = this.codingConvention.extractClassNameIfProvide(n, parent)) != null) {
                    this.provides.add(provide);
                }
                return;
            }
            if (parent != null && !parent.isExprResult() && !parent.isScript()) {
                return;
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitSubtree(child, n);
            }
        }
    }
}

