/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.RealMatrix;

@Deprecated
public class LeastSquaresConverter
implements MultivariateFunction {
    private final MultivariateVectorFunction function;
    private final double[] observations;
    private final double[] weights;
    private final RealMatrix scale;

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations) {
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations, double[] weights) {
        if (observations.length != weights.length) {
            throw new DimensionMismatchException(observations.length, weights.length);
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = (double[])weights.clone();
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction function, double[] observations, RealMatrix scale) {
        if (observations.length != scale.getColumnDimension()) {
            throw new DimensionMismatchException(observations.length, scale.getColumnDimension());
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = scale.copy();
    }

    @Override
    public double value(double[] point) {
        double[] residuals = this.function.value(point);
        if (residuals.length != this.observations.length) {
            throw new DimensionMismatchException(residuals.length, this.observations.length);
        }
        int i = 0;
        while (i < residuals.length) {
            int n = i;
            residuals[n] = residuals[n] - this.observations[i];
            ++i;
        }
        double sumSquares = 0.0;
        if (this.weights != null) {
            int i2 = 0;
            while (i2 < residuals.length) {
                double ri = residuals[i2];
                sumSquares += this.weights[i2] * ri * ri;
                ++i2;
            }
        } else if (this.scale != null) {
            double[] dArray = this.scale.operate(residuals);
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double yi = dArray[n2];
                sumSquares += yi * yi;
                ++n2;
            }
        } else {
            double[] dArray = residuals;
            int n = residuals.length;
            int n3 = 0;
            while (n3 < n) {
                double ri = dArray[n3];
                sumSquares += ri * ri;
                ++n3;
            }
        }
        return sumSquares;
    }
}

