/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.serializer;

import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ObjectArraySerializer
extends TypeSerializerImpl {
    public static final String ARRAY_TAG = "array";
    public static final String DATA_TAG = "data";
    private final XmlRpcStreamConfig config;
    private final TypeFactory typeFactory;

    public ObjectArraySerializer(TypeFactory pTypeFactory, XmlRpcStreamConfig pConfig) {
        this.typeFactory = pTypeFactory;
        this.config = pConfig;
    }

    protected void writeObject(ContentHandler pHandler, Object pObject) throws SAXException {
        TypeSerializer ts = this.typeFactory.getSerializer(this.config, pObject);
        if (ts == null) {
            throw new SAXException("Unsupported Java type: " + pObject.getClass().getName());
        }
        ts.write(pHandler, pObject);
    }

    protected void writeData(ContentHandler pHandler, Object pObject) throws SAXException {
        Object[] data = (Object[])pObject;
        int i = 0;
        while (i < data.length) {
            this.writeObject(pHandler, data[i]);
            ++i;
        }
    }

    @Override
    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
        pHandler.startElement("", ARRAY_TAG, ARRAY_TAG, ZERO_ATTRIBUTES);
        pHandler.startElement("", DATA_TAG, DATA_TAG, ZERO_ATTRIBUTES);
        this.writeData(pHandler, pObject);
        pHandler.endElement("", DATA_TAG, DATA_TAG);
        pHandler.endElement("", ARRAY_TAG, ARRAY_TAG);
        pHandler.endElement("", "value", "value");
    }
}

