/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.apogy.addons.ros.ROSListenerState;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.addons.ros.impl.ROSListenerImpl;
import org.eclipse.apogy.addons.ros.utilities.AsynchronousShutdowner;
import org.ros.internal.message.Message;
import org.ros.message.MessageListener;
import org.ros.node.ConnectedNode;
import org.ros.node.topic.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSListenerCustomImpl<T extends Message>
extends ROSListenerImpl<T> {
    private static final Logger Logger = LoggerFactory.getLogger(ROSListenerImpl.class);
    private static final int MAX_WAIT_CONNECTION = 1000;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    protected ROSListenerCustomImpl() {
    }

    @Override
    public boolean startWithLocks(ROSNode node) throws Exception {
        boolean timeElapsed = false;
        this.lock.lock();
        try {
            this.setNode(node);
            this.connectSubscriber(node.getConnectedNode());
            while (!timeElapsed && !this.isRunning()) {
                try {
                    timeElapsed = !this.condition.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (timeElapsed) {
                throw new Exception("Cannot connect to the topic " + this.getTopicName() + " (connection timeout)");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.isRunning();
    }

    @Override
    public void start(ROSNode node) throws Exception {
        this.setNode(node);
        this.connectSubscriber(node.getConnectedNode());
    }

    @Override
    public void connectSubscriber(ConnectedNode connectedNode) {
        Subscriber rosSubscriber = connectedNode.newSubscriber(this.getTopicName(), this.getMessageType());
        rosSubscriber.addMessageListener(this.getMessageListener());
        rosSubscriber.addMessageListener((MessageListener)new ConnectionStateListener());
        this.setRosSubscriber(rosSubscriber);
    }

    @Override
    public void stop() {
        try {
            AsynchronousShutdowner.add(this.getRosSubscriber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setListenerState(ROSListenerState.STOPPED);
        this.setRosSubscriber(null);
        this.setRunning(false);
    }

    private class ConnectionStateListener
    implements MessageListener<T> {
        private ConnectionStateListener() {
        }

        public void onNewMessage(T message) {
            if (!ROSListenerCustomImpl.this.isRunning()) {
                ROSListenerCustomImpl.this.lock.lock();
                try {
                    Logger.info("onNewMessage()Listener for the topic " + ROSListenerCustomImpl.this.getTopicName() + " is running.");
                    ROSListenerCustomImpl.this.setRunning(true);
                    ROSListenerCustomImpl.this.condition.signal();
                }
                finally {
                    ROSListenerCustomImpl.this.lock.unlock();
                }
            }
        }
    }
}

