/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.utilities;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ros.node.ConnectedNode;
import org.ros.node.service.ServiceClient;
import org.ros.node.topic.Publisher;
import org.ros.node.topic.Subscriber;

public class AsynchronousShutdowner {
    private static Queue<Object> shutdownQueue = new LinkedBlockingQueue<Object>();
    private static Thread shutdownThread = null;

    public static void add(Object o) {
        if (shutdownThread == null) {
            AsynchronousShutdowner.startShutdownThread();
        }
        if (o != null) {
            shutdownQueue.add(o);
        }
    }

    private static void shutdownNode(ConnectedNode node) {
        node.shutdown();
    }

    private static void shutdownSubscriber(Subscriber<?> s) {
        s.shutdown();
    }

    public static synchronized void startShutdownThread() {
        if (shutdownThread == null) {
            shutdownThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (this.isAlive()) {
                            if (shutdownQueue.isEmpty()) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            Object o = shutdownQueue.poll();
                            if (o instanceof Subscriber) {
                                AsynchronousShutdowner.shutdownSubscriber((Subscriber)o);
                                continue;
                            }
                            if (o instanceof ServiceClient) {
                                ((ServiceClient)o).shutdown();
                                continue;
                            }
                            if (o instanceof Publisher) {
                                ((Publisher)o).shutdown();
                                continue;
                            }
                            if (!(o instanceof ConnectedNode)) continue;
                            AsynchronousShutdowner.shutdownNode((ConnectedNode)o);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            shutdownThread.start();
        }
    }
}

