/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.utilities;

import org.eclipse.apogy.addons.ros.messages.ROSFrameworkLogEntry;
import org.eclipse.apogy.addons.ros.utilities.FrameworkLogUtils;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.ros.node.ConnectedNode;
import org.ros.node.topic.Publisher;

public class FrameworkLogPublisher {
    protected ILogListener logListener = null;
    protected ConnectedNode connectedNode = null;
    protected String topicName = null;
    protected Publisher<ROSFrameworkLogEntry> frameworkLogEntryPublisher = null;

    public FrameworkLogPublisher(String topicName, ConnectedNode connectedNode) {
        this.setTopicName(topicName);
        this.setConnectedNode(connectedNode);
        this.registerListener();
    }

    protected void finalize() throws Throwable {
        this.unRegisterListener();
        super.finalize();
    }

    private void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    private void setConnectedNode(ConnectedNode connectedNode) {
        if (this.frameworkLogEntryPublisher != null) {
            this.frameworkLogEntryPublisher.shutdown();
            this.frameworkLogEntryPublisher = null;
        }
        this.connectedNode = connectedNode;
        if (connectedNode != null) {
            this.frameworkLogEntryPublisher = connectedNode.newPublisher(this.topicName, "org.eclipse.apogy.addons.ros.messages/ROSFrameworkLogEntry");
        }
    }

    private void registerListener() {
        Platform.addLogListener((ILogListener)this.getILogListener());
    }

    private void unRegisterListener() {
        Platform.removeLogListener((ILogListener)this.getILogListener());
    }

    private ILogListener getILogListener() {
        if (this.logListener == null) {
            this.logListener = new ILogListener(){

                public void logging(IStatus status, String plugin) {
                    try {
                        if (FrameworkLogPublisher.this.frameworkLogEntryPublisher != null) {
                            ROSFrameworkLogEntry entry = FrameworkLogUtils.convertToROSFrameworkLogEntry(status, FrameworkLogPublisher.this.connectedNode);
                            FrameworkLogPublisher.this.frameworkLogEntryPublisher.publish((Object)entry);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        return this.logListener;
    }
}

