/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFilter;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageFilterEffectPreviewComposite
extends Composite {
    private ImageFilter imageFilter;
    private Adapter imageFilterAdapter;
    private final ImageDisplayComposite originalImage;
    private final ImageDisplayComposite filteredImage;
    private AbstractEImage unfilteredImage = null;

    public ImageFilterEffectPreviewComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, true));
        Label lblOriginalImage = new Label((Composite)this, 0);
        lblOriginalImage.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        lblOriginalImage.setText("Original Image:");
        Label lblFilteredImage = new Label((Composite)this, 0);
        lblFilteredImage.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        lblFilteredImage.setText("Filtered Image:");
        this.originalImage = new ImageDisplayComposite((Composite)this, 2048);
        GridData gd_originalImage = new GridData(4, 4, true, true, 1, 1);
        gd_originalImage.heightHint = 180;
        gd_originalImage.minimumHeight = 180;
        gd_originalImage.minimumWidth = 320;
        gd_originalImage.widthHint = 320;
        this.originalImage.setLayoutData((Object)gd_originalImage);
        this.filteredImage = new ImageDisplayComposite((Composite)this, 2048);
        GridData gd_filteredImage = new GridData(4, 4, true, true, 1, 1);
        gd_filteredImage.widthHint = 320;
        gd_filteredImage.minimumWidth = 320;
        gd_filteredImage.minimumHeight = 180;
        gd_filteredImage.heightHint = 180;
        this.filteredImage.setLayoutData((Object)gd_filteredImage);
    }

    public ImageFilter getImageFilter() {
        return this.imageFilter;
    }

    public void setImageFilter(ImageFilter imageFilter) {
        if (this.imageFilter != null) {
            this.imageFilter.eAdapters().remove((Object)this.getImageFilterAdapter());
        }
        this.imageFilter = imageFilter;
        if (imageFilter != null) {
            this.updateImage();
            imageFilter.eAdapters().add((Object)this.getImageFilterAdapter());
        }
    }

    private void updateImage() {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractEImage filtered = ImageFilterEffectPreviewComposite.this.imageFilter.filter(null, ImageFilterEffectPreviewComposite.this.getUnfilteredImage());
                        if (filtered != null) {
                            ImageFilterEffectPreviewComposite.this.filteredImage.setImageData(EImagesUtilities.INSTANCE.convertToImageData(filtered.asBufferedImage()));
                            ImageFilterEffectPreviewComposite.this.filteredImage.fitImage();
                        }
                        ImageFilterEffectPreviewComposite.this.originalImage.setImageData(EImagesUtilities.INSTANCE.convertToImageData(ImageFilterEffectPreviewComposite.this.getUnfilteredImage().asBufferedImage()));
                        ImageFilterEffectPreviewComposite.this.originalImage.fitImage();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private AbstractEImage getUnfilteredImage() {
        if (this.unfilteredImage == null) {
            URLEImage urlImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
            urlImage.setUrl("platform:/plugin/org.eclipse.apogy.addons.sensors.imaging.camera/images/unfiltered_image.jpg");
            this.unfilteredImage = urlImage;
        }
        return this.unfilteredImage;
    }

    private Adapter getImageFilterAdapter() {
        if (this.imageFilterAdapter == null) {
            this.imageFilterAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    ImageFilterEffectPreviewComposite.this.updateImage();
                    super.notifyChanged(notification);
                }
            };
        }
        return this.imageFilterAdapter;
    }
}

