/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Point2d;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.AzimuthDirection;
import org.eclipse.apogy.addons.sensors.imaging.ElevationDirection;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.PTZCameraToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Point;

public abstract class PTZCameraToolCustomImpl
extends PTZCameraToolImpl {
    private ImageSnapshot imageSnapshot;
    protected int clickCount = 0;

    @Override
    public abstract void commandPTZ(double var1, double var3, double var5, double var7);

    @Override
    public void clearUserSelection() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER0, null);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER1, null);
        this.clickCount = 0;
    }

    @Override
    public void initializeCamera(AbstractCamera camera) {
    }

    @Override
    public void updateImageSnapshot(ImageSnapshot imageSnapshot) {
        this.imageSnapshot = imageSnapshot;
    }

    @Override
    public void mouseMoved(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        if (mouseButton == 1 && this.getUserSelectionCorner0() != null) {
            double h = this.imageSnapshot.convertToHorizontalAngle(x);
            double v = this.imageSnapshot.convertToVerticalAngle(y);
            if (this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_RIGHT) {
                h = -h;
            }
            if (this.getElevationDirection() == ElevationDirection.POSITIVE_DOWN) {
                v = -v;
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER1, (Object)new Point2d(h, v));
        }
    }

    @Override
    public void positionSelected(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        switch (mouseButton) {
            case 1: {
                if (this.clickCount == 0) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER0, null);
                    double h = this.imageSnapshot.convertToHorizontalAngle(x);
                    double v = this.imageSnapshot.convertToVerticalAngle(y);
                    if (this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_RIGHT) {
                        h = -h;
                    }
                    if (this.getElevationDirection() == ElevationDirection.POSITIVE_DOWN) {
                        v = -v;
                    }
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER0, (Object)new Point2d(h, v));
                } else {
                    double h = this.imageSnapshot.convertToHorizontalAngle(x);
                    double v = this.imageSnapshot.convertToVerticalAngle(y);
                    if (this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_RIGHT) {
                        h = -h;
                    }
                    if (this.getElevationDirection() == ElevationDirection.POSITIVE_DOWN) {
                        v = -v;
                    }
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.PTZ_CAMERA_TOOL__USER_SELECTION_CORNER1, (Object)new Point2d(h, v));
                }
                if (this.clickCount == 0) {
                    this.clickCount = 1;
                    break;
                }
                this.clickCount = 0;
                break;
            }
            case 2: {
                if (this.getUserSelectionCorner0() == null || this.getUserSelectionCorner1() == null) break;
                this.commandPTZ();
                break;
            }
            case 3: {
                this.clearUserSelection();
                break;
            }
        }
    }

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        AbstractEImage fovImage = super.applyOverlay(camera, cameraImage, overlayAlignment, overlayWidth, overlayHeight);
        AbstractEImage userSelectedAreaImage = this.getUserSelectionAreaImage(camera, cameraImage);
        AbstractEImage result = EImagesUtilities.INSTANCE.applyOverlay(fovImage, userSelectedAreaImage, true);
        return result;
    }

    protected AbstractEImage getUserSelectionAreaImage(AbstractCamera camera, AbstractEImage cameraImage) {
        int height = cameraImage.getHeight();
        int width = cameraImage.getWidth();
        AbstractEImage areaImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height);
        BufferedImage bufferedImage = areaImage.asBufferedImage();
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(this.getColorOfSelectionBox());
        Point p0 = null;
        Point p1 = null;
        if (this.getUserSelectionCorner0() != null) {
            p0 = this.getImageLocation(camera, cameraImage, this.getUserSelectionCorner0().x, this.getUserSelectionCorner0().y);
            g2d.drawOval(p0.x - 1, p0.y - 1, 3, 3);
        }
        if (this.getUserSelectionCorner1() != null) {
            p1 = this.getImageLocation(camera, cameraImage, this.getUserSelectionCorner1().x, this.getUserSelectionCorner1().y);
            g2d.drawOval(p1.x - 1, p1.y - 1, 3, 3);
        }
        if (this.getUserSelectionCorner0() != null && this.getUserSelectionCorner1() != null) {
            g2d.setStroke(new BasicStroke(1.0f));
            int x0 = p0.x;
            int x1 = p1.x;
            int y0 = p0.y;
            int y1 = p1.y;
            g2d.drawLine(x0, y0, x1, y0);
            g2d.drawLine(x1, y0, x1, y1);
            g2d.drawLine(x1, y1, x0, y1);
            g2d.drawLine(x0, y1, x0, y0);
            g2d.dispose();
            EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            resultImage.setImageContent(bufferedImage);
            return resultImage;
        }
        return areaImage;
    }

    protected Color getColorOfSelectionBox() {
        if (this.getSelectionBoxColor() != null) {
            return new Color(this.getSelectionBoxColor().rgb.red, this.getSelectionBoxColor().rgb.green, this.getSelectionBoxColor().rgb.blue);
        }
        return Color.BLUE;
    }

    private void commandPTZ() {
        if (this.getUserSelectionCorner0() != null && this.getUserSelectionCorner1() != null) {
            double areaPoint0HAngle = this.getUserSelectionCorner0().x;
            double areaPoint0VAngle = this.getUserSelectionCorner0().y;
            double areaPoint1HAngle = this.getUserSelectionCorner1().x;
            double areaPoint1VAngle = this.getUserSelectionCorner1().y;
            double panIncrement = (areaPoint0HAngle + areaPoint1HAngle) / 2.0;
            double tiltIncrement = (areaPoint0VAngle + areaPoint1VAngle) / 2.0;
            double newHorizontalFOV = Math.abs(areaPoint1HAngle - areaPoint0HAngle);
            double newVerticalFOV = Math.abs(areaPoint1VAngle - areaPoint0VAngle);
            this.commandPTZ(panIncrement, tiltIncrement, newHorizontalFOV, newVerticalFOV);
        }
    }
}

