/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVPackage;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.bindings.RectangularFrustrumFieldOfViewBinding;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraToolList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.PointerCameraToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DPackage;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.addons.primitives.ApogyCommonTopologyAddonsPrimitivesFactory;
import org.eclipse.apogy.common.topology.addons.primitives.ApogyCommonTopologyAddonsPrimitivesPackage;
import org.eclipse.apogy.common.topology.addons.primitives.PickVector;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.listeners.AbstractVariableFeatureReferenceListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointerCameraToolCustomImpl
extends PointerCameraToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PointerCameraToolImpl.class);
    private AbstractVariableFeatureReferenceListener abstractVariableFeatureReferenceListener = null;
    private String toolTipText = "No intersection";
    private RectangularFrustrumFieldOfView fov = null;
    private PickVector vector;
    private TransformNode vectorTransformNode = null;
    private ImageSnapshot imageSnapshot;
    private final DecimalFormat distanceFormat = new DecimalFormat("0.00");

    public void setFov(RectangularFrustrumFieldOfView newFov) {
        GroupNode parent;
        if (this.fov != null && (parent = (GroupNode)this.fov.getParent()) != null) {
            parent.getChildren().remove((Object)this.getVectorTransformNode());
        }
        this.fov = newFov;
        if (newFov != null && (parent = (GroupNode)newFov.getParent()) != null) {
            parent.getChildren().add((Object)this.getVectorTransformNode());
        }
    }

    @Override
    public void setVectorColor(RGBA newVectorColor) {
        super.setVectorColor(newVectorColor);
        this.updateVectorColor(newVectorColor);
    }

    @Override
    public void setCameraToolList(CameraToolList newCameraToolList) {
        super.setCameraToolList(newCameraToolList);
        if (newCameraToolList != null) {
            try {
                this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference((VariableFeatureReference)newCameraToolList.getCameraViewConfiguration());
                this.setFov(this.resolveFOV());
            }
            catch (Throwable t) {
                Logger.error("Error occured while setting the CameraToolList.", t);
            }
        }
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        this.updateVectorVisibility(newVisible);
    }

    @Override
    public String getToolTipText(AbstractCamera camera, ImageSnapshot imageSnapshot, int mouseButton, int x, int y) {
        return this.toolTipText;
    }

    @Override
    public void initializeCamera(AbstractCamera camera) {
        this.setFov(this.resolveFOV(camera));
        if (camera != null) {
            this.updateImageSnapshot(camera.getLatestImageSnapshot());
        }
        this.updateVectorColor(this.getVectorColor());
    }

    @Override
    public void updateImageSnapshot(ImageSnapshot imageSnapshot) {
        this.imageSnapshot = imageSnapshot;
    }

    @Override
    public void mouseMoved(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        double distance = Double.NaN;
        if (mouseButton == 1) {
            this.updatePointer(cameraImage, this.imageSnapshot, x, y);
            distance = this.getVector().getIntersectionDistance();
            this.toolTipText = !Double.isNaN(this.getIntersectionDistance()) ? "distance = " + this.distanceFormat.format(distance) : "No intersection";
        } else {
            this.toolTipText = null;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.POINTER_CAMERA_TOOL__INTERSECTION_DISTANCE, (Object)distance);
    }

    @Override
    public void positionSelected(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        this.updatePointer(cameraImage, this.imageSnapshot, x, y);
        double distance = this.getVector().getIntersectionDistance();
        this.toolTipText = !Double.isNaN(this.getIntersectionDistance()) ? "distance = " + this.distanceFormat.format(distance) : "No intersection";
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.POINTER_CAMERA_TOOL__INTERSECTION_DISTANCE, (Object)distance);
    }

    @Override
    public void dispose() {
        if (this.vectorTransformNode != null && this.vectorTransformNode.getParent() != null) {
            try {
                NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.vectorTransformNode);
                if (nodePresentation != null) {
                    nodePresentation.setVisible(false);
                }
                if (this.vector != null) {
                    Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.vector);
                    if (nodePresentation != null) {
                        nodePresentation.setVisible(false);
                    }
                }
            }
            catch (Exception nodePresentation) {
                // empty catch block
            }
            if (this.vector != null) {
                this.vectorTransformNode.getAggregatedChildren().remove((Object)this.vector);
                this.vector = null;
            }
            GroupNode gp = (GroupNode)this.vectorTransformNode.getParent();
            gp.getChildren().remove((Object)this.vectorTransformNode);
            this.vectorTransformNode.setParent(null);
        }
        this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference(null);
        super.dispose();
    }

    protected void updateVectorColor(RGBA color) {
        NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.getVector());
        if (nodePresentation != null) {
            nodePresentation.setColor(color);
        }
    }

    protected void updateVectorVisibility(boolean visible) {
        NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.getVector());
        if (nodePresentation != null) {
            nodePresentation.setVisible(visible);
        }
    }

    protected void updatePointer(AbstractEImage cameraImage, ImageSnapshot imageSnapshot, int x, int y) {
        if (imageSnapshot != null && cameraImage != null) {
            double xRotation = -imageSnapshot.convertToHorizontalAngle(x);
            double yRotation = imageSnapshot.convertToVerticalAngle(y);
            Matrix3d xRot = new Matrix3d();
            xRot.setIdentity();
            xRot.rotX(xRotation);
            Matrix3d yRot = new Matrix3d();
            yRot.setIdentity();
            yRot.rotY(yRotation);
            Matrix3d rotation = new Matrix3d();
            rotation.setIdentity();
            rotation.mul(xRot);
            rotation.mul(yRot);
            Vector3d v = new Vector3d(0.0, 0.0, 100.0);
            rotation.transform((Tuple3d)v);
            double vx = v.x;
            double vy = v.y;
            double vz = v.z;
            this.vector.setCoordinates(ApogyCommonMathFacade.INSTANCE.createTuple3d(vx, vy, vz));
            this.vector.setLength(100.0);
            if (this.vector.getAbsoluteIntersectionPosition() != null) {
                Matrix4d m = new Matrix4d();
                m.setIdentity();
                m.set(new Vector3d((Tuple3d)this.vector.getAbsoluteIntersectionPosition()));
                Matrix4x4 pose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.POSE_PROVIDER__POSE_TRANSFORM, (Object)pose);
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.POSE_PROVIDER__POSE_TRANSFORM, null);
            }
            RGBA newColor = this.getVectorColor();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.POINTER_CAMERA_TOOL__VECTOR_COLOR, (Object)newColor);
        }
    }

    protected RectangularFrustrumFieldOfView resolveFOV(AbstractCamera camera) {
        if (camera == null) {
            return null;
        }
        RectangularFrustrumFieldOfView fov = null;
        List bindings = org.eclipse.apogy.common.topology.bindings.Activator.getBindedBindings();
        Iterator it = bindings.iterator();
        while (it.hasNext() && fov == null) {
            RectangularFrustrumFieldOfView bindedFOV;
            RectangularFrustrumFieldOfViewBinding fovBinding;
            AbstractTopologyBinding next = (AbstractTopologyBinding)it.next();
            if (!(next instanceof RectangularFrustrumFieldOfViewBinding) || !((fovBinding = (RectangularFrustrumFieldOfViewBinding)next).getFeatureNodeAdapter().getCurrentValue() instanceof RectangularFrustrumFieldOfView) || (bindedFOV = (RectangularFrustrumFieldOfView)fovBinding.getFeatureNodeAdapter().getCurrentValue()) != camera.getFieldOfView()) continue;
            fov = fovBinding.getFov();
        }
        return fov;
    }

    protected TransformNode getVectorTransformNode() {
        if (this.vectorTransformNode == null) {
            Matrix4d m = new Matrix4d();
            m.setIdentity();
            Vector3d position = new Vector3d(0.0, 0.0, 0.01);
            m.set(position);
            Date date = new Date();
            this.vectorTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNode(m);
            this.vectorTransformNode.setNodeId("VECTOR_" + this.getName() + "_" + date.getTime());
            this.vectorTransformNode.setDescription("PointerCamera Vector Transform");
            this.vectorTransformNode.getChildren().add((Object)this.getVector());
        }
        return this.vectorTransformNode;
    }

    protected PickVector getVector() {
        if (this.vector == null) {
            this.vector = ApogyCommonTopologyAddonsPrimitivesFactory.eINSTANCE.createPickVector();
            this.vector.getNodeTypesInIntersection().add((Object)ApogyCommonGeometryData3DPackage.eINSTANCE.getCartesianCoordinatesMesh());
            this.vector.getNodeTypesInIntersection().add((Object)ApogyCommonTopologyPackage.eINSTANCE.getContentNode());
            this.vector.setNodeId("PICKVECTOR_" + this.getName());
            this.vector.setDescription("Pick Vector used by Pointer Camera Tool.");
            this.vector.setCoordinates(ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 1.0));
            this.vector.setLength(100.0);
            this.vector.getNodeTypesToExcludeFromIntersection().add((Object)ApogyAddonsSensorsFOVPackage.Literals.RECTANGULAR_FRUSTRUM_FIELD_OF_VIEW);
            this.vector.getNodeTypesToExcludeFromIntersection().add((Object)ApogyCommonTopologyAddonsPrimitivesPackage.Literals.PICK_VECTOR);
            this.vector.getNodeTypesInIntersection().add((Object)ApogyCommonTopologyPackage.Literals.NODE);
            RGBA newColor = this.getVectorColor();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.POINTER_CAMERA_TOOL__VECTOR_COLOR, (Object)newColor);
        }
        return this.vector;
    }

    protected RectangularFrustrumFieldOfView resolveFOV() {
        AbstractCamera abstractCamera;
        CameraViewConfiguration cameraViewConfiguration;
        RectangularFrustrumFieldOfView fov = null;
        if (this.getCameraToolList() != null && (cameraViewConfiguration = this.getCameraToolList().getCameraViewConfiguration()) != null && (abstractCamera = cameraViewConfiguration.getCamera()) != null) {
            fov = abstractCamera.getFieldOfView();
        }
        return fov;
    }

    protected AbstractVariableFeatureReferenceListener getAbstractVariableFeatureReferenceListener() {
        if (this.abstractVariableFeatureReferenceListener == null) {
            this.abstractVariableFeatureReferenceListener = new AbstractVariableFeatureReferenceListener(this.getCameraToolList().getCameraViewConfiguration()){

                protected void instanceChanged(EObject oldInstance, EObject newInstance) {
                    PointerCameraToolCustomImpl.this.setFov(PointerCameraToolCustomImpl.this.resolveFOV());
                }

                protected void contextChanged(Context oldContext, Context newContext) {
                    PointerCameraToolCustomImpl.this.setFov(PointerCameraToolCustomImpl.this.resolveFOV());
                }

                protected void typeApiAdapterChanged(TypeApiAdapter oldTypeApiAdapter, TypeApiAdapter newTypeApiAdapter) {
                    PointerCameraToolCustomImpl.this.setFov(PointerCameraToolCustomImpl.this.resolveFOV());
                }

                protected void variableChanged(Variable oldVariable, Variable newVariable) {
                    PointerCameraToolCustomImpl.this.setFov(PointerCameraToolCustomImpl.this.resolveFOV());
                }

                protected void listRootNodeChanged() {
                    PointerCameraToolCustomImpl.this.setFov(PointerCameraToolCustomImpl.this.resolveFOV());
                }
            };
        }
        return this.abstractVariableFeatureReferenceListener;
    }
}

