/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.parts;

import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraFactory;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfigurationReference;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewUtilities;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.CameraViewComposite;
import org.eclipse.apogy.addons.sensors.imaging.camera.parts.ToolBarMenuPart;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraViewPart
extends AbstractSessionPart<CameraViewConfiguration>
implements ToolBarMenuPart {
    private static final Logger Logger = LoggerFactory.getLogger(CameraViewPart.class);
    public static final String CameraViewConfigurationID = "CameraViewConfiguration";
    protected String partName = "Camera View";
    private CameraViewConfiguration cameraViewConfiguration;
    private CameraViewComposite cameraViewComposite;
    @Inject
    public ECommandService commandService;
    @Inject
    public EHandlerService handlerService;
    @Inject
    public ESelectionService selectionService;
    @Inject
    public EPartService ePartService;
    @Inject
    public MPart mPart;

    public CameraViewConfiguration getCameraViewConfiguration() {
        return this.cameraViewConfiguration;
    }

    public void setCameraViewConfiguration(CameraViewConfiguration newCameraViewConfiguration) {
        this.setContent((EObject)newCameraViewConfiguration);
    }

    protected void createComposite(Composite parent, int style) {
        this.cameraViewComposite = new CameraViewComposite(parent, style){

            @Override
            protected void newCameraViewConfigurationSelected(CameraViewConfiguration newCameraViewConfiguration) {
                CameraViewPart.this.cameraViewConfiguration = newCameraViewConfiguration;
                CameraViewPart.this.selectionService.setSelection((Object)CameraViewPart.this.cameraViewConfiguration);
                if (CameraViewPart.this.cameraViewConfiguration != null) {
                    CameraViewPart.this.mPart.setLabel(String.valueOf(CameraViewPart.this.partName) + " - " + CameraViewPart.this.cameraViewConfiguration.getName());
                }
                ParameterizedCommand command = CameraViewPart.this.commandService.createCommand("org.eclipse.apogy.addons.sensors.imaging.camera.command.updateCameraViewToolbar", Collections.emptyMap());
                CameraViewPart.this.handlerService.executeHandler(command);
            }

            @Override
            protected void newTabFolderSelection(String parameterID) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("org.eclipse.apogy.common.ui.opentoolbarmenu.commandparameter.ID", parameterID);
                ParameterizedCommand command = CameraViewPart.this.commandService.createCommand("org.eclipse.apogy.common.ui.command.openToolBarMenu", parameters);
                CameraViewPart.this.handlerService.executeHandler(command);
            }
        };
    }

    protected void sessionChanged(InvocatorSession invocatorSession) {
        if (invocatorSession != null) {
            CameraViewConfigurationReference ref;
            if (this.cameraViewComposite != null) {
                this.cameraViewComposite.setCameraViewConfigurationList(CameraViewUtilities.INSTANCE.getActiveCameraViewConfigurationList());
            }
            if ((ref = (CameraViewConfigurationReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, CameraViewConfigurationID)) != null) {
                this.cameraViewConfiguration = ref.getCameraViewConfiguration();
            } else {
                Logger.warn("No Camera View Configuration could be read back, setting it to null.");
            }
            this.setContent((EObject)this.cameraViewConfiguration);
        }
    }

    @Inject
    @PersistState
    public void persistState(MPart mPart) {
        try {
            if (this.cameraViewConfiguration != null) {
                CameraViewConfigurationReference ref = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createCameraViewConfigurationReference();
                ref.setCameraViewConfiguration(this.cameraViewConfiguration);
                ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(mPart, CameraViewConfigurationID, (EObject)ref);
            }
            mPart.setLabel(this.partName);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void setDisplayRectifiedImage(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.cameraViewComposite.getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__DISPLAY_RECTIFIED_IMAGE, (Object)value);
    }

    public void setImageAutoSaveEnable(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.cameraViewComposite.getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__IMAGE_AUTO_SAVE_ENABLE, (Object)value);
    }

    public void setSaveImageWithOverlays(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.cameraViewComposite.getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__SAVE_IMAGE_WITH_OVERLAYS, (Object)value);
    }

    @Override
    public void toolItemSelectedChanged(String parameterID, boolean selected) {
        this.cameraViewComposite.updatetoolbarMenuComposite(parameterID, selected);
    }

    @Override
    public boolean canExecute() {
        return this.cameraViewComposite != null && this.cameraViewConfiguration != null;
    }

    protected void doSetContent(CameraViewConfiguration newCameraViewConfiguration) {
        this.cameraViewConfiguration = newCameraViewConfiguration;
        this.cameraViewComposite.setCameraViewConfiguration(newCameraViewConfiguration);
        if (newCameraViewConfiguration != null) {
            this.mPart.setLabel(String.valueOf(this.partName) + " - " + newCameraViewConfiguration.getName());
        } else {
            this.mPart.setLabel(this.partName);
        }
    }
}

