/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsPackage;
import org.eclipse.apogy.addons.telecoms.AbstractAntennaRadiationPattern;
import org.eclipse.apogy.addons.telecoms.AntennaRadiationPatternImageMapLayer;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsFactory;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsPackage;
import org.eclipse.apogy.addons.telecoms.DipoleAntennaRadiationPattern;
import org.eclipse.apogy.addons.telecoms.HalfWaveDipoleAntennaRadiationPattern;
import org.eclipse.apogy.addons.telecoms.IsotropicAntenna;
import org.eclipse.apogy.addons.telecoms.SimpleConicalRadiationPattern;
import org.eclipse.apogy.addons.telecoms.SimpleRectangularFrustumRadiationPattern;
import org.eclipse.apogy.addons.telecoms.TelecomNode;
import org.eclipse.apogy.addons.telecoms.TelecomNodeStatus;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorToolList;
import org.eclipse.apogy.addons.telecoms.URlBasedAntennaRadiationPattern;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIPackage;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DPackage;
import org.eclipse.apogy.common.images.ApogyCommonImagesPackage;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.processors.ApogyCommonProcessorsPackage;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIPackage;
import org.eclipse.apogy.common.topology.ui.viewer.ApogyCommonTopologyUIViewerPackage;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

public class ApogyAddonsTelecomsPackageImpl
extends EPackageImpl
implements ApogyAddonsTelecomsPackage {
    private EClass telecomNodeEClass = null;
    private EClass telecomStatusMonitorToolEClass = null;
    private EClass telecomStatusMonitorToolListEClass = null;
    private EClass abstractAntennaRadiationPatternEClass = null;
    private EClass isotropicAntennaEClass = null;
    private EClass dipoleAntennaRadiationPatternEClass = null;
    private EClass halfWaveDipoleAntennaRadiationPatternEClass = null;
    private EClass simpleConicalRadiationPatternEClass = null;
    private EClass simpleRectangularFrustumRadiationPatternEClass = null;
    private EClass uRlBasedAntennaRadiationPatternEClass = null;
    private EClass antennaRadiationPatternImageMapLayerEClass = null;
    private EEnum telecomNodeStatusEEnum = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private ApogyAddonsTelecomsPackageImpl() {
        super("org.eclipse.apogy.addons.telecoms", (EFactory)ApogyAddonsTelecomsFactory.eINSTANCE);
    }

    public static ApogyAddonsTelecomsPackage init() {
        if (isInited) {
            return (ApogyAddonsTelecomsPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.addons.telecoms");
        }
        Object registeredApogyAddonsTelecomsPackage = EPackage.Registry.INSTANCE.get((Object)"org.eclipse.apogy.addons.telecoms");
        ApogyAddonsTelecomsPackageImpl theApogyAddonsTelecomsPackage = registeredApogyAddonsTelecomsPackage instanceof ApogyAddonsTelecomsPackageImpl ? (ApogyAddonsTelecomsPackageImpl)registeredApogyAddonsTelecomsPackage : new ApogyAddonsTelecomsPackageImpl();
        isInited = true;
        EcorePackage.eINSTANCE.eClass();
        ApogyAddonsPackage.eINSTANCE.eClass();
        ApogyCommonEMFPackage.eINSTANCE.eClass();
        ApogyCommonTopologyPackage.eINSTANCE.eClass();
        ApogySurfaceEnvironmentPackage.eINSTANCE.eClass();
        ApogyCommonMathPackage.eINSTANCE.eClass();
        ApogyCommonEMFUIPackage.eINSTANCE.eClass();
        ApogyCorePackage.eINSTANCE.eClass();
        ApogyCoreInvocatorPackage.eINSTANCE.eClass();
        ApogyCommonTopologyUIViewerPackage.eINSTANCE.eClass();
        ApogyAddonsGeometryPathsPackage.eINSTANCE.eClass();
        ApogyCoreEnvironmentPackage.eINSTANCE.eClass();
        ApogyCommonImagesPackage.eINSTANCE.eClass();
        ApogyCommonGeometryData3DPackage.eINSTANCE.eClass();
        ApogyCommonTopologyBindingsPackage.eINSTANCE.eClass();
        ApogyCommonTopologyUIPackage.eINSTANCE.eClass();
        ApogyCommonGeometryDataPackage.eINSTANCE.eClass();
        ApogyCommonProcessorsPackage.eINSTANCE.eClass();
        theApogyAddonsTelecomsPackage.createPackageContents();
        theApogyAddonsTelecomsPackage.initializePackageContents();
        theApogyAddonsTelecomsPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"org.eclipse.apogy.addons.telecoms", (Object)theApogyAddonsTelecomsPackage);
        return theApogyAddonsTelecomsPackage;
    }

    @Override
    public EClass getTelecomNode() {
        return this.telecomNodeEClass;
    }

    @Override
    public EReference getTelecomNode_StatusMonitorTool() {
        return (EReference)this.telecomNodeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getTelecomNode_Enabled() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getTelecomNode_Name() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getTelecomNode_Address() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EAttribute getTelecomNode_PacketsToSend() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(4);
    }

    @Override
    public EAttribute getTelecomNode_ConnectionTimeout() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(5);
    }

    @Override
    public EAttribute getTelecomNode_LatencyWarning() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(6);
    }

    @Override
    public EAttribute getTelecomNode_LatencyAlarm() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(7);
    }

    @Override
    public EAttribute getTelecomNode_PacketLossWarning() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(8);
    }

    @Override
    public EAttribute getTelecomNode_PacketLossAlarm() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(9);
    }

    @Override
    public EAttribute getTelecomNode_Latency() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(10);
    }

    @Override
    public EAttribute getTelecomNode_PacketLoss() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(11);
    }

    @Override
    public EAttribute getTelecomNode_Status() {
        return (EAttribute)this.telecomNodeEClass.getEStructuralFeatures().get(12);
    }

    @Override
    public EClass getTelecomStatusMonitorTool() {
        return this.telecomStatusMonitorToolEClass;
    }

    @Override
    public EReference getTelecomStatusMonitorTool_TelecomNodes() {
        return (EReference)this.telecomStatusMonitorToolEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getTelecomStatusMonitorTool_StatusMonitorToolList() {
        return (EReference)this.telecomStatusMonitorToolEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getTelecomStatusMonitorTool_Running() {
        return (EAttribute)this.telecomStatusMonitorToolEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getTelecomStatusMonitorTool_Disposed() {
        return (EAttribute)this.telecomStatusMonitorToolEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EOperation getTelecomStatusMonitorTool__Start() {
        return (EOperation)this.telecomStatusMonitorToolEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getTelecomStatusMonitorTool__Stop() {
        return (EOperation)this.telecomStatusMonitorToolEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getTelecomStatusMonitorTool__Dispose() {
        return (EOperation)this.telecomStatusMonitorToolEClass.getEOperations().get(2);
    }

    @Override
    public EClass getTelecomStatusMonitorToolList() {
        return this.telecomStatusMonitorToolListEClass;
    }

    @Override
    public EReference getTelecomStatusMonitorToolList_TelecomStatusMonitors() {
        return (EReference)this.telecomStatusMonitorToolListEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getAbstractAntennaRadiationPattern() {
        return this.abstractAntennaRadiationPatternEClass;
    }

    @Override
    public EOperation getAbstractAntennaRadiationPattern__ComputeGain__double_double() {
        return (EOperation)this.abstractAntennaRadiationPatternEClass.getEOperations().get(0);
    }

    @Override
    public EClass getIsotropicAntenna() {
        return this.isotropicAntennaEClass;
    }

    @Override
    public EClass getDipoleAntennaRadiationPattern() {
        return this.dipoleAntennaRadiationPatternEClass;
    }

    @Override
    public EClass getHalfWaveDipoleAntennaRadiationPattern() {
        return this.halfWaveDipoleAntennaRadiationPatternEClass;
    }

    @Override
    public EClass getSimpleConicalRadiationPattern() {
        return this.simpleConicalRadiationPatternEClass;
    }

    @Override
    public EAttribute getSimpleConicalRadiationPattern_ApexAngle() {
        return (EAttribute)this.simpleConicalRadiationPatternEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getSimpleRectangularFrustumRadiationPattern() {
        return this.simpleRectangularFrustumRadiationPatternEClass;
    }

    @Override
    public EAttribute getSimpleRectangularFrustumRadiationPattern_HorizontalFieldOfView() {
        return (EAttribute)this.simpleRectangularFrustumRadiationPatternEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSimpleRectangularFrustumRadiationPattern_VerticalFieldOfView() {
        return (EAttribute)this.simpleRectangularFrustumRadiationPatternEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getURlBasedAntennaRadiationPattern() {
        return this.uRlBasedAntennaRadiationPatternEClass;
    }

    @Override
    public EAttribute getURlBasedAntennaRadiationPattern_Url() {
        return (EAttribute)this.uRlBasedAntennaRadiationPatternEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getAntennaRadiationPatternImageMapLayer() {
        return this.antennaRadiationPatternImageMapLayerEClass;
    }

    @Override
    public EReference getAntennaRadiationPatternImageMapLayer_ObserverPose() {
        return (EReference)this.antennaRadiationPatternImageMapLayerEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getAntennaRadiationPatternImageMapLayer_AntennaRadiationPattern() {
        return (EReference)this.antennaRadiationPatternImageMapLayerEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getAntennaRadiationPatternImageMapLayer_SignalStrengthCutoff() {
        return (EAttribute)this.antennaRadiationPatternImageMapLayerEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getAntennaRadiationPatternImageMapLayer_BellowCutoffColor() {
        return (EAttribute)this.antennaRadiationPatternImageMapLayerEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EEnum getTelecomNodeStatus() {
        return this.telecomNodeStatusEEnum;
    }

    @Override
    public ApogyAddonsTelecomsFactory getApogyAddonsTelecomsFactory() {
        return (ApogyAddonsTelecomsFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.telecomNodeEClass = this.createEClass(0);
        this.createEReference(this.telecomNodeEClass, 0);
        this.createEAttribute(this.telecomNodeEClass, 1);
        this.createEAttribute(this.telecomNodeEClass, 2);
        this.createEAttribute(this.telecomNodeEClass, 3);
        this.createEAttribute(this.telecomNodeEClass, 4);
        this.createEAttribute(this.telecomNodeEClass, 5);
        this.createEAttribute(this.telecomNodeEClass, 6);
        this.createEAttribute(this.telecomNodeEClass, 7);
        this.createEAttribute(this.telecomNodeEClass, 8);
        this.createEAttribute(this.telecomNodeEClass, 9);
        this.createEAttribute(this.telecomNodeEClass, 10);
        this.createEAttribute(this.telecomNodeEClass, 11);
        this.createEAttribute(this.telecomNodeEClass, 12);
        this.telecomStatusMonitorToolEClass = this.createEClass(1);
        this.createEReference(this.telecomStatusMonitorToolEClass, 0);
        this.createEReference(this.telecomStatusMonitorToolEClass, 1);
        this.createEAttribute(this.telecomStatusMonitorToolEClass, 2);
        this.createEAttribute(this.telecomStatusMonitorToolEClass, 3);
        this.createEOperation(this.telecomStatusMonitorToolEClass, 0);
        this.createEOperation(this.telecomStatusMonitorToolEClass, 1);
        this.createEOperation(this.telecomStatusMonitorToolEClass, 2);
        this.telecomStatusMonitorToolListEClass = this.createEClass(2);
        this.createEReference(this.telecomStatusMonitorToolListEClass, 6);
        this.abstractAntennaRadiationPatternEClass = this.createEClass(3);
        this.createEOperation(this.abstractAntennaRadiationPatternEClass, 1);
        this.isotropicAntennaEClass = this.createEClass(4);
        this.dipoleAntennaRadiationPatternEClass = this.createEClass(5);
        this.halfWaveDipoleAntennaRadiationPatternEClass = this.createEClass(6);
        this.simpleConicalRadiationPatternEClass = this.createEClass(7);
        this.createEAttribute(this.simpleConicalRadiationPatternEClass, 4);
        this.simpleRectangularFrustumRadiationPatternEClass = this.createEClass(8);
        this.createEAttribute(this.simpleRectangularFrustumRadiationPatternEClass, 4);
        this.createEAttribute(this.simpleRectangularFrustumRadiationPatternEClass, 5);
        this.uRlBasedAntennaRadiationPatternEClass = this.createEClass(9);
        this.createEAttribute(this.uRlBasedAntennaRadiationPatternEClass, 4);
        this.antennaRadiationPatternImageMapLayerEClass = this.createEClass(10);
        this.createEReference(this.antennaRadiationPatternImageMapLayerEClass, 16);
        this.createEReference(this.antennaRadiationPatternImageMapLayerEClass, 17);
        this.createEAttribute(this.antennaRadiationPatternImageMapLayerEClass, 18);
        this.createEAttribute(this.antennaRadiationPatternImageMapLayerEClass, 19);
        this.telecomNodeStatusEEnum = this.createEEnum(11);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("telecoms");
        this.setNsPrefix("telecoms");
        this.setNsURI("org.eclipse.apogy.addons.telecoms");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ApogyAddonsPackage theApogyAddonsPackage = (ApogyAddonsPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.addons");
        ApogyCommonTopologyPackage theApogyCommonTopologyPackage = (ApogyCommonTopologyPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.topology");
        ApogyCommonEMFPackage theApogyCommonEMFPackage = (ApogyCommonEMFPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.emf");
        ApogySurfaceEnvironmentPackage theApogySurfaceEnvironmentPackage = (ApogySurfaceEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.surface");
        ApogyCommonMathPackage theApogyCommonMathPackage = (ApogyCommonMathPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.math");
        ApogyCommonEMFUIPackage theApogyCommonEMFUIPackage = (ApogyCommonEMFUIPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.emf.ui");
        this.telecomStatusMonitorToolListEClass.getESuperTypes().add((Object)theApogyAddonsPackage.getSimpleTool());
        this.abstractAntennaRadiationPatternEClass.getESuperTypes().add((Object)theApogyCommonTopologyPackage.getNode());
        this.abstractAntennaRadiationPatternEClass.getESuperTypes().add((Object)theApogyCommonEMFPackage.getNamed());
        this.isotropicAntennaEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.dipoleAntennaRadiationPatternEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.halfWaveDipoleAntennaRadiationPatternEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.simpleConicalRadiationPatternEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.simpleRectangularFrustumRadiationPatternEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.uRlBasedAntennaRadiationPatternEClass.getESuperTypes().add((Object)this.getAbstractAntennaRadiationPattern());
        this.antennaRadiationPatternImageMapLayerEClass.getESuperTypes().add((Object)theApogySurfaceEnvironmentPackage.getAbstractLineOfSightImageMapLayer());
        this.initEClass(this.telecomNodeEClass, TelecomNode.class, "TelecomNode", false, false, true);
        this.initEReference(this.getTelecomNode_StatusMonitorTool(), (EClassifier)this.getTelecomStatusMonitorTool(), this.getTelecomStatusMonitorTool_TelecomNodes(), "statusMonitorTool", null, 0, 1, TelecomNode.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getTelecomNode_Enabled(), (EClassifier)theEcorePackage.getEBoolean(), "enabled", "true", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_Name(), (EClassifier)theEcorePackage.getEString(), "name", "", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_Address(), (EClassifier)theEcorePackage.getEString(), "address", "localhost", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_PacketsToSend(), (EClassifier)theEcorePackage.getEInt(), "packetsToSend", "1", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_ConnectionTimeout(), (EClassifier)theEcorePackage.getEInt(), "connectionTimeout", "2000", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_LatencyWarning(), (EClassifier)theEcorePackage.getEDouble(), "latencyWarning", "500.0", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_LatencyAlarm(), (EClassifier)theEcorePackage.getEDouble(), "latencyAlarm", "1000.0", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_PacketLossWarning(), (EClassifier)theEcorePackage.getEDouble(), "packetLossWarning", "20.0", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_PacketLossAlarm(), (EClassifier)theEcorePackage.getEDouble(), "packetLossAlarm", "50.0", 0, 1, TelecomNode.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_Latency(), (EClassifier)theEcorePackage.getEDouble(), "latency", "0.0", 0, 1, TelecomNode.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_PacketLoss(), (EClassifier)theEcorePackage.getEDouble(), "packetLoss", "0.0", 0, 1, TelecomNode.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomNode_Status(), (EClassifier)this.getTelecomNodeStatus(), "status", null, 0, 1, TelecomNode.class, true, true, false, false, false, false, true, true);
        this.initEClass(this.telecomStatusMonitorToolEClass, TelecomStatusMonitorTool.class, "TelecomStatusMonitorTool", false, false, true);
        this.initEReference(this.getTelecomStatusMonitorTool_TelecomNodes(), (EClassifier)this.getTelecomNode(), this.getTelecomNode_StatusMonitorTool(), "telecomNodes", null, 0, -1, TelecomStatusMonitorTool.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getTelecomStatusMonitorTool_StatusMonitorToolList(), (EClassifier)this.getTelecomStatusMonitorToolList(), this.getTelecomStatusMonitorToolList_TelecomStatusMonitors(), "statusMonitorToolList", null, 0, 1, TelecomStatusMonitorTool.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getTelecomStatusMonitorTool_Running(), (EClassifier)theEcorePackage.getEBoolean(), "running", "false", 0, 1, TelecomStatusMonitorTool.class, true, false, true, false, false, false, false, true);
        this.initEAttribute(this.getTelecomStatusMonitorTool_Disposed(), (EClassifier)theEcorePackage.getEBoolean(), "disposed", "false", 0, 1, TelecomStatusMonitorTool.class, true, false, true, false, false, false, false, true);
        this.initEOperation(this.getTelecomStatusMonitorTool__Start(), null, "start", 0, 1, false, true);
        this.initEOperation(this.getTelecomStatusMonitorTool__Stop(), null, "stop", 0, 1, false, true);
        this.initEOperation(this.getTelecomStatusMonitorTool__Dispose(), null, "dispose", 0, 1, false, true);
        this.initEClass(this.telecomStatusMonitorToolListEClass, TelecomStatusMonitorToolList.class, "TelecomStatusMonitorToolList", false, false, true);
        this.initEReference(this.getTelecomStatusMonitorToolList_TelecomStatusMonitors(), (EClassifier)this.getTelecomStatusMonitorTool(), this.getTelecomStatusMonitorTool_StatusMonitorToolList(), "telecomStatusMonitors", null, 0, -1, TelecomStatusMonitorToolList.class, false, false, true, true, false, false, true, false, true);
        this.initEClass(this.abstractAntennaRadiationPatternEClass, AbstractAntennaRadiationPattern.class, "AbstractAntennaRadiationPattern", true, false, true);
        EOperation op = this.initEOperation(this.getAbstractAntennaRadiationPattern__ComputeGain__double_double(), (EClassifier)theEcorePackage.getEDouble(), "computeGain", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "theta", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "phi", 0, 1, false, true);
        this.initEClass(this.isotropicAntennaEClass, IsotropicAntenna.class, "IsotropicAntenna", false, false, true);
        this.initEClass(this.dipoleAntennaRadiationPatternEClass, DipoleAntennaRadiationPattern.class, "DipoleAntennaRadiationPattern", false, false, true);
        this.initEClass(this.halfWaveDipoleAntennaRadiationPatternEClass, HalfWaveDipoleAntennaRadiationPattern.class, "HalfWaveDipoleAntennaRadiationPattern", false, false, true);
        this.initEClass(this.simpleConicalRadiationPatternEClass, SimpleConicalRadiationPattern.class, "SimpleConicalRadiationPattern", false, false, true);
        this.initEAttribute(this.getSimpleConicalRadiationPattern_ApexAngle(), (EClassifier)theEcorePackage.getEDouble(), "apexAngle", "0.79", 0, 1, SimpleConicalRadiationPattern.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.simpleRectangularFrustumRadiationPatternEClass, SimpleRectangularFrustumRadiationPattern.class, "SimpleRectangularFrustumRadiationPattern", false, false, true);
        this.initEAttribute(this.getSimpleRectangularFrustumRadiationPattern_HorizontalFieldOfView(), (EClassifier)theEcorePackage.getEDouble(), "horizontalFieldOfView", "0.79", 0, 1, SimpleRectangularFrustumRadiationPattern.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getSimpleRectangularFrustumRadiationPattern_VerticalFieldOfView(), (EClassifier)theEcorePackage.getEDouble(), "verticalFieldOfView", "1.57", 0, 1, SimpleRectangularFrustumRadiationPattern.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.uRlBasedAntennaRadiationPatternEClass, URlBasedAntennaRadiationPattern.class, "URlBasedAntennaRadiationPattern", false, false, true);
        this.initEAttribute(this.getURlBasedAntennaRadiationPattern_Url(), (EClassifier)theEcorePackage.getEString(), "url", null, 0, 1, URlBasedAntennaRadiationPattern.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.antennaRadiationPatternImageMapLayerEClass, AntennaRadiationPatternImageMapLayer.class, "AntennaRadiationPatternImageMapLayer", false, false, true);
        this.initEReference(this.getAntennaRadiationPatternImageMapLayer_ObserverPose(), (EClassifier)theApogyCommonMathPackage.getMatrix4x4(), null, "observerPose", null, 1, 1, AntennaRadiationPatternImageMapLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getAntennaRadiationPatternImageMapLayer_AntennaRadiationPattern(), (EClassifier)this.getAbstractAntennaRadiationPattern(), null, "antennaRadiationPattern", null, 0, 1, AntennaRadiationPatternImageMapLayer.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getAntennaRadiationPatternImageMapLayer_SignalStrengthCutoff(), (EClassifier)theEcorePackage.getEDouble(), "signalStrengthCutoff", "-100.0", 0, 1, AntennaRadiationPatternImageMapLayer.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getAntennaRadiationPatternImageMapLayer_BellowCutoffColor(), (EClassifier)theApogyCommonEMFUIPackage.getRGBA(), "bellowCutoffColor", "0,255,0,0", 0, 1, AntennaRadiationPatternImageMapLayer.class, false, false, true, false, false, false, false, true);
        this.initEEnum(this.telecomNodeStatusEEnum, TelecomNodeStatus.class, "TelecomNodeStatus");
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.NOT_STARTED);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.NOT_ENABLED);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.UNREACHABLE);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.NORMAL);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.PACKET_LOSS_WARNING);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.PACKET_LOSS_ALARM);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.LATENCY_WARNING);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.LATENCY_ALARM);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.BOTH_WARNING);
        this.addEEnumLiteral(this.telecomNodeStatusEEnum, TelecomNodeStatus.BOTH_ALARM);
        this.createResource("org.eclipse.apogy.addons.telecoms");
        this.createGenModelAnnotations();
        this.createApogyAnnotations();
    }

    protected void createGenModelAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/GenModel";
        this.addAnnotation((ENamedElement)this, source, new String[]{"prefix", "ApogyAddonsTelecoms", "childCreationExtenders", "true", "extensibleProviderFactory", "true", "multipleEditorPages", "false", "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Pierre Allard - initial API and implementation\n     Regent L'Archeveque\n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************", "modelName", "ApogyAddonsTelecoms", "complianceLevel", "8.0", "suppressGenModelAnnotations", "false", "dynamicTemplates", "true", "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates", "modelDirectory", "/org.eclipse.apogy.addons.telecoms/src-gen", "editDirectory", "/org.eclipse.apogy.addons.telecoms.edit/src-gen", "basePackage", "org.eclipse.apogy.addons"});
        this.addAnnotation((ENamedElement)this.telecomNodeStatusEEnum, source, new String[]{"documentation", "*\n The different possible states of the TelecomNode"});
        this.addAnnotation((ENamedElement)this.telecomNodeEClass, source, new String[]{"documentation", "*\nA node containing all the information required to attempt communication\nwith the desired network address, keeping track of the current latency,\npacket loss and overall state."});
        this.addAnnotation((ENamedElement)this.getTelecomNode_StatusMonitorTool(), source, new String[]{"documentation", "*\nThe status monitor to which this node belongs"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Enabled(), source, new String[]{"documentation", "*\nWhether the network node is enabled, and thus, is actively\nreceiving updates.", "propertyCategory", "Current Status", "property", "Readonly", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Name(), source, new String[]{"documentation", "*\nThe current name of the telecom node", "propertyCategory", "Connection Settings", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Address(), source, new String[]{"documentation", "*\nThe current address of the telecom node", "propertyCategory", "Connection Settings", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketsToSend(), source, new String[]{"documentation", "*\nThe number of packets to send in each update requested (>= 1)", "propertyCategory", "Connection Settings", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_ConnectionTimeout(), source, new String[]{"documentation", "*\nThe time (in ms) to wait between waiting for a response and considering\na packet lost.", "propertyCategory", "Connection Settings", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_LatencyWarning(), source, new String[]{"documentation", "*\nThe point where packet latency (in ms) is becoming high (should be warned)", "propertyCategory", "Warnings And Alarms", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_LatencyAlarm(), source, new String[]{"documentation", "*\nThe point where packet latency (in ms) is so high as to be out of valid range (should be an alarm)", "propertyCategory", "Warnings And Alarms", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLossWarning(), source, new String[]{"documentation", "*\nThe point where packet loss (in %) is becoming high (should be warned)", "propertyCategory", "Warnings And Alarms", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLossAlarm(), source, new String[]{"documentation", "*\nThe point where packet loss (in %) is so high as to be out of valid range (should be an alarm)", "propertyCategory", "Warnings And Alarms", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Latency(), source, new String[]{"documentation", "*\nThe current packet latency, in milliseconds,  between this computer and the target address", "propertyCategory", "Current Status", "property", "Readonly", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLoss(), source, new String[]{"documentation", "*\nThe current packet loss, in percent,between this computer and the target address", "propertyCategory", "Current Status", "property", "Readonly", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Status(), source, new String[]{"documentation", "*\nThe current status of the network node, as derived from the network\nnode's other state.", "propertyCategory", "Current Status", "property", "Readonly", "notify", "true", "children", "false", "get", "boolean _isRunning = this.getStatusMonitorTool().isRunning();\nboolean _equals = (_isRunning == false);\nif (_equals)\n{\n\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.NOT_STARTED;\n}\nelse\n{\n\tboolean _isEnabled = this.isEnabled();\n\tboolean _equals_1 = (_isEnabled == false);\n\tif (_equals_1)\n\t{\n\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.NOT_ENABLED;\n\t}\n\telse\n\t{\n\t\tdouble _packetLoss = this.getPacketLoss();\n\t\tboolean _greaterEqualsThan = (_packetLoss >= 100.0);\n\t\tif (_greaterEqualsThan)\n\t\t{\n\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.UNREACHABLE;\n\t\t}\n\t\telse\n\t\t{\n\t\t\tif (((this.getLatency() >= 0) && (this.getLatency() < this.getLatencyWarning())))\n\t\t\t{\n\t\t\t\tdouble _packetLoss_1 = this.getPacketLoss();\n\t\t\t\tdouble _packetLossWarning = this.getPacketLossWarning();\n\t\t\t\tboolean _lessThan = (_packetLoss_1 < _packetLossWarning);\n\t\t\t\tif (_lessThan)\n\t\t\t\t{\n\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.NORMAL;\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tif (((this.getPacketLoss() >= this.getPacketLossWarning()) && \n\t\t\t\t\t\t(this.getPacketLoss() < this.getPacketLossAlarm())))\n\t\t\t\t\t{\n\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.PACKET_LOSS_WARNING;\n\t\t\t\t\t}\n\t\t\t\t\telse\n\t\t\t\t\t{\n\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.PACKET_LOSS_ALARM;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tif (((this.getLatency() >= this.getLatencyWarning()) && \n\t\t\t\t\t(this.getLatency() < this.getLatencyAlarm())))\n\t\t\t\t{\n\t\t\t\t\tdouble _packetLoss_2 = this.getPacketLoss();\n\t\t\t\t\tdouble _packetLossWarning_1 = this.getPacketLossWarning();\n\t\t\t\t\tboolean _lessThan_1 = (_packetLoss_2 < _packetLossWarning_1);\n\t\t\t\t\tif (_lessThan_1)\n\t\t\t\t\t{\n\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.LATENCY_WARNING;\n\t\t\t\t\t}\n\t\t\t\t\telse\n\t\t\t\t\t{\n\t\t\t\t\t\tif (((this.getPacketLoss() >= this.getPacketLossWarning()) && \n\t\t\t\t\t\t\t(this.getPacketLoss() < this.getPacketLossAlarm())))\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.BOTH_WARNING;\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.BOTH_ALARM;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse\n\t\t\t\t{\n\t\t\t\t\tdouble _packetLoss_3 = this.getPacketLoss();\n\t\t\t\t\tdouble _packetLossWarning_2 = this.getPacketLossWarning();\n\t\t\t\t\tboolean _lessThan_2 = (_packetLoss_3 < _packetLossWarning_2);\n\t\t\t\t\tif (_lessThan_2)\n\t\t\t\t\t{\n\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.LATENCY_ALARM;\n\t\t\t\t\t}\n\t\t\t\t\telse\n\t\t\t\t\t{\n\t\t\t\t\t\tif (((this.getPacketLoss() >= this.getPacketLossWarning()) && \n\t\t\t\t\t\t\t(this.getPacketLoss() < this.getPacketLossAlarm())))\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.BOTH_ALARM;\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\treturn <%org.eclipse.apogy.addons.telecoms.TelecomNodeStatus%>.BOTH_ALARM;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"});
        this.addAnnotation((ENamedElement)this.telecomStatusMonitorToolEClass, source, new String[]{"documentation", "*\nThis is used to keep track of all the relevant state for\na telecom status monitor tool."});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool__Start(), source, new String[]{"documentation", "*\nOperation used to start the telecom status monitor running."});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool__Stop(), source, new String[]{"documentation", "*\nOperation used to stop the telecom status monitor."});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool__Dispose(), source, new String[]{"documentation", "*\nOperation used to dispose of the telecom status monitor\nwhen it is no longer needed"});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool_TelecomNodes(), source, new String[]{"documentation", "*\nAll of the telecom nodes that are associated with the\nassociated with this status monitor tool"});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool_StatusMonitorToolList(), source, new String[]{"documentation", "*\nThe list of telecom status monitors to which this particular monitor belongs"});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool_Running(), source, new String[]{"documentation", "*\nWhether or not the telecom status monitor is currently running", "property", "Readonly", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorTool_Disposed(), source, new String[]{"documentation", "*\nWhether or not the telecom status monitor is currently disposed", "property", "Readonly", "notify", "true", "children", "false"});
        this.addAnnotation((ENamedElement)this.telecomStatusMonitorToolListEClass, source, new String[]{"documentation", "*\nThis is used to keep track of the list of telecom status monitor\ntool."});
        this.addAnnotation((ENamedElement)this.getTelecomStatusMonitorToolList_TelecomStatusMonitors(), source, new String[]{"documentation", "Used to keep track of all of the telecom status monitors"});
        this.addAnnotation((ENamedElement)this.abstractAntennaRadiationPatternEClass, source, new String[]{"documentation", "*\nAbstract class defining a antenna radiation pattern, which is the directional (angular) dependence of\nthe strength of the radio waves from the antenna or other source."});
        this.addAnnotation((ENamedElement)this.getAbstractAntennaRadiationPattern__ComputeGain__double_double(), source, new String[]{"documentation", "*\nReturns the gain of the antenna in the direction specified by a vector.\n@param theta The angle between the z axis and the direction vector, in radians.\n@param phi The angle between the x axis and the projection of the point in the x-y plane, in radians\n@return The gain, in dBi (decibels isotropic or dBi) associated with the radiation pattern in the specified direction."});
        this.addAnnotation((ENamedElement)this.isotropicAntennaEClass, source, new String[]{"documentation", "*\nClass that represent a theoretical antenna that acts as a point source of electromagnetic waves which radiates\nthe same intensity of radiation in all directions."});
        this.addAnnotation((ENamedElement)this.dipoleAntennaRadiationPatternEClass, source, new String[]{"documentation", "*\nSimple dipole antenna. The antenna axis is along the z-axis."});
        this.addAnnotation((ENamedElement)this.halfWaveDipoleAntennaRadiationPatternEClass, source, new String[]{"documentation", "*\nSimple half-wave dipole antenna. The antenna axis is along the z-axis."});
        this.addAnnotation((ENamedElement)this.simpleConicalRadiationPatternEClass, source, new String[]{"documentation", "*\nA simple radiation pattern defined as a rectangular frustum. Outside the frustum, gain is null."});
        this.addAnnotation((ENamedElement)this.getSimpleConicalRadiationPattern_ApexAngle(), source, new String[]{"documentation", "*\nThe apex angle of the cone. The cone is pointing toward +Z."});
        this.addAnnotation((ENamedElement)this.simpleRectangularFrustumRadiationPatternEClass, source, new String[]{"documentation", "*\nA simple radiation pattern defined as a rectangular frustum. Outside the frustum, gain is null."});
        this.addAnnotation((ENamedElement)this.getSimpleRectangularFrustumRadiationPattern_HorizontalFieldOfView(), source, new String[]{"documentation", "*\nHorizontal field of view angle."});
        this.addAnnotation((ENamedElement)this.getSimpleRectangularFrustumRadiationPattern_VerticalFieldOfView(), source, new String[]{"documentation", "*\nVertical field of view angle."});
        this.addAnnotation((ENamedElement)this.uRlBasedAntennaRadiationPatternEClass, source, new String[]{"documentation", "*\nDefines an antenna radiation pattern which actually pattern data is found in a URL."});
        this.addAnnotation((ENamedElement)this.getURlBasedAntennaRadiationPattern_Url(), source, new String[]{"documentation", "*\nThe URL to the file containing the radiation pattern data.", "propertyCategory", "URL"});
        this.addAnnotation((ENamedElement)this.antennaRadiationPatternImageMapLayerEClass, source, new String[]{"documentation", "*\nA map layer used to show an antenna radiation pattern."});
        this.addAnnotation((ENamedElement)this.getAntennaRadiationPatternImageMapLayer_ObserverPose(), source, new String[]{"documentation", "*\nThe position of the observer with which we want line of sight.", "property", "Editable", "propertyCategory", "IMAGE_GENERATION_SETTINGS"});
        this.addAnnotation((ENamedElement)this.getAntennaRadiationPatternImageMapLayer_AntennaRadiationPattern(), source, new String[]{"property", "Editable", "propertyCategory", "ANTENNA"});
        this.addAnnotation((ENamedElement)this.getAntennaRadiationPatternImageMapLayer_SignalStrengthCutoff(), source, new String[]{"documentation", "*\nCutoff signal strength under which no signal is usuable."});
        this.addAnnotation((ENamedElement)this.getAntennaRadiationPatternImageMapLayer_BellowCutoffColor(), source, new String[]{"documentation", "*\nColor to use to mark line of sigh is available.", "property", "Editable", "propertyCategory", "CUTOFF_SETTINGS"});
    }

    protected void createApogyAnnotations() {
        String source = "http://www.eclipse.org/apogy";
        this.addAnnotation((ENamedElement)this.telecomNodeEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_ConnectionTimeout(), source, new String[]{"units", "ms"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_LatencyWarning(), source, new String[]{"units", "ms"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_LatencyAlarm(), source, new String[]{"units", "ms"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLossWarning(), source, new String[]{"units", "%"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLossAlarm(), source, new String[]{"units", "%"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_Latency(), source, new String[]{"units", "ms"});
        this.addAnnotation((ENamedElement)this.getTelecomNode_PacketLoss(), source, new String[]{"units", "%"});
        this.addAnnotation((ENamedElement)this.telecomStatusMonitorToolEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.telecomStatusMonitorToolListEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.abstractAntennaRadiationPatternEClass, source, new String[]{"hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getAbstractAntennaRadiationPattern__ComputeGain__double_double(), source, new String[]{"units", "dB"});
        this.addAnnotation((ENamedElement)this.getAbstractAntennaRadiationPattern__ComputeGain__double_double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAbstractAntennaRadiationPattern__ComputeGain__double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.isotropicAntennaEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.halfWaveDipoleAntennaRadiationPatternEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.simpleConicalRadiationPatternEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getSimpleConicalRadiationPattern_ApexAngle(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.simpleRectangularFrustumRadiationPatternEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getSimpleRectangularFrustumRadiationPattern_HorizontalFieldOfView(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getSimpleRectangularFrustumRadiationPattern_VerticalFieldOfView(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.antennaRadiationPatternImageMapLayerEClass, source, new String[]{"hasCustomClass", "true", "hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getAntennaRadiationPatternImageMapLayer_SignalStrengthCutoff(), source, new String[]{"units", "dB", "property", "Editable", "propertyCategory", "CUTOFF_SETTINGS"});
    }
}

