/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import org.eclipse.apogy.addons.telecoms.impl.SimpleConicalRadiationPatternImpl;

public class SimpleConicalRadiationPatternCustomImpl
extends SimpleConicalRadiationPatternImpl {
    protected double maxGain = Double.NaN;

    @Override
    public void setApexAngle(double newApexAngle) {
        super.setApexAngle(newApexAngle);
        this.maxGain = this.computeMaximumGain();
    }

    @Override
    public double computeGain(double theta, double phi) {
        if (theta <= this.getApexAngle() / 2.0) {
            return this.getMaxGain();
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double getMaxGain() {
        if (Double.isNaN(this.maxGain)) {
            this.maxGain = this.computeMaximumGain();
        }
        return this.maxGain;
    }

    private double computeMaximumGain() {
        double coneSolidAngle = Math.PI * 2 * (1.0 - Math.cos(this.getApexAngle() / 2.0));
        double apertureRatio = Math.PI * 4 / coneSolidAngle;
        double gain = 10.0 * Math.log10(apertureRatio);
        return gain;
    }
}

