/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.addons.Ruler3DTool;
import org.eclipse.apogy.addons.Ruler3dToolNode;
import org.eclipse.apogy.addons.ui.Ruler3dToolSceneObject;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.JME3PrimitivesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ruler3dToolNodeJME3Object
extends DefaultJME3SceneObject<Ruler3dToolNode>
implements Ruler3dToolSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(Ruler3dToolNodeJME3Object.class);
    public static final int MAXIMUM_NUMBER_OF_TICK = 100;
    public static final ColorRGBA FROM_COLOR = ColorRGBA.Red;
    public static final ColorRGBA TO_COLOR = ColorRGBA.Blue;
    private Adapter adapter;
    private AssetManager assetManager;
    private com.jme3.scene.Node fromTransformNode;
    private com.jme3.scene.Node toTransformNode;
    private Geometry fromSphere = null;
    private Geometry toSphere = null;
    private Geometry rulerBodyGeometry = null;
    private Geometry minorTicksGeometry = null;
    private Geometry majorTicksGeometry = null;
    private ColorRGBA rulerBodyColor = ColorRGBA.Red;
    private ColorRGBA minorTicksColor = ColorRGBA.Red;
    private ColorRGBA majorTicksColor = ColorRGBA.Red;

    public Ruler3dToolNodeJME3Object(Ruler3dToolNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.createGeometry();
        Job job = new Job("Ruler3dToolNodeJME3Object : Updating Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                Ruler3dToolNodeJME3Object.this.requestUpdate();
                Ruler3dToolNodeJME3Object.this.setVisible(((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool().isVisible());
                ((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool().eAdapters().add((Object)Ruler3dToolNodeJME3Object.this.getAdapter());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        this.updateFromTo();
        this.updateRulerBody();
        this.updateMinorTicks();
        this.updateMajorTicks();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.fromSphere);
        geometries.add(this.toSphere);
        geometries.add(this.rulerBodyGeometry);
        geometries.add(this.minorTicksGeometry);
        geometries.add(this.majorTicksGeometry);
        return geometries;
    }

    public void setVisible(final boolean visible) {
        Logger.info("Setting visibilty to <" + visible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!visible && Ruler3dToolNodeJME3Object.this.isVisible()) {
                    if (Ruler3dToolNodeJME3Object.this.fromTransformNode != null) {
                        Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().detachChild((Spatial)Ruler3dToolNodeJME3Object.this.fromTransformNode);
                    }
                    if (Ruler3dToolNodeJME3Object.this.toTransformNode != null) {
                        Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().detachChild((Spatial)Ruler3dToolNodeJME3Object.this.toTransformNode);
                    }
                    Ruler3dToolNodeJME3Object.this.getRoot().detachChild((Spatial)Ruler3dToolNodeJME3Object.this.getAttachmentNode());
                } else if (visible && !Ruler3dToolNodeJME3Object.this.isVisible()) {
                    if (Ruler3dToolNodeJME3Object.this.fromTransformNode != null) {
                        Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().attachChild((Spatial)Ruler3dToolNodeJME3Object.this.fromTransformNode);
                    }
                    if (Ruler3dToolNodeJME3Object.this.toTransformNode != null) {
                        Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().attachChild((Spatial)Ruler3dToolNodeJME3Object.this.toTransformNode);
                    }
                    Ruler3dToolNodeJME3Object.this.getRoot().attachChild((Spatial)Ruler3dToolNodeJME3Object.this.getAttachmentNode());
                }
                return null;
            }
        });
        if (visible) {
            this.requestUpdate();
        }
    }

    public void dispose() {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Ruler3dToolNodeJME3Object.this.fromTransformNode != null) {
                    Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().detachChild((Spatial)Ruler3dToolNodeJME3Object.this.fromTransformNode);
                }
                if (Ruler3dToolNodeJME3Object.this.toTransformNode != null) {
                    Ruler3dToolNodeJME3Object.this.jme3Application.getRootNode().detachChild((Spatial)Ruler3dToolNodeJME3Object.this.toTransformNode);
                }
                Ruler3dToolNodeJME3Object.this.fromTransformNode = null;
                Ruler3dToolNodeJME3Object.this.toTransformNode = null;
                Ruler3dToolNodeJME3Object.this.fromSphere = null;
                Ruler3dToolNodeJME3Object.this.toSphere = null;
                Ruler3dToolNodeJME3Object.this.rulerBodyGeometry = null;
                Ruler3dToolNodeJME3Object.this.minorTicksGeometry = null;
                Ruler3dToolNodeJME3Object.this.majorTicksGeometry = null;
                if (Ruler3dToolNodeJME3Object.this.getTopologyNode() != null && ((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool() != null) {
                    ((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool().eAdapters().remove((Object)Ruler3dToolNodeJME3Object.this.getAdapter());
                }
                Ruler3dToolNodeJME3Object.super.dispose();
                return null;
            }
        });
    }

    public void setRulerColor(final RGBA color) {
        this.rulerBodyColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ColorRGBA newColor = JME3Utilities.convertToColorRGBA((RGBA)color);
                if (Ruler3dToolNodeJME3Object.this.rulerBodyGeometry != null) {
                    Ruler3dToolNodeJME3Object.this.rulerBodyGeometry.getMaterial().setColor("Color", newColor);
                }
                return null;
            }
        });
    }

    public void setMinorTicksColor(final RGBA color) {
        this.minorTicksColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ColorRGBA newColor = JME3Utilities.convertToColorRGBA((RGBA)color);
                if (Ruler3dToolNodeJME3Object.this.minorTicksGeometry != null) {
                    Ruler3dToolNodeJME3Object.this.minorTicksGeometry.getMaterial().setColor("Color", newColor);
                }
                return null;
            }
        });
    }

    public void setMajorTicksColor(final RGBA color) {
        this.majorTicksColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ColorRGBA newColor = JME3Utilities.convertToColorRGBA((RGBA)color);
                if (Ruler3dToolNodeJME3Object.this.majorTicksGeometry != null) {
                    Ruler3dToolNodeJME3Object.this.majorTicksGeometry.getMaterial().setColor("Color", newColor);
                }
                return null;
            }
        });
    }

    public void setMinorTickSpacing(float minorTickSpacing) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Ruler3dToolNodeJME3Object.this.updateMinorTicks();
                return null;
            }
        });
    }

    public void setMajorTickSpacing(float majorTickSpacing) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Ruler3dToolNodeJME3Object.this.updateMajorTicks();
                return null;
            }
        });
    }

    public void setMinorTickLength(float minorTickLength) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Ruler3dToolNodeJME3Object.this.updateMinorTicks();
                return null;
            }
        });
    }

    public void setMajorTickLength(float majorTickLength) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Ruler3dToolNodeJME3Object.this.updateMajorTicks();
                return null;
            }
        });
    }

    public void setExtremitiesRadius(final float newRadius) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Ruler3dToolNodeJME3Object.this.fromSphere != null) {
                    Ruler3dToolNodeJME3Object.this.fromTransformNode.detachChild((Spatial)Ruler3dToolNodeJME3Object.this.fromSphere);
                }
                if (Ruler3dToolNodeJME3Object.this.toSphere != null) {
                    Ruler3dToolNodeJME3Object.this.toTransformNode.detachChild((Spatial)Ruler3dToolNodeJME3Object.this.toSphere);
                }
                if (newRadius >= 0.0f) {
                    Ruler3dToolNodeJME3Object.this.fromSphere = JME3PrimitivesUtilities.createSphere((float)newRadius, (AssetManager)Ruler3dToolNodeJME3Object.this.assetManager);
                    Ruler3dToolNodeJME3Object.this.fromSphere.setMaterial(Ruler3dToolNodeJME3Object.this.createFromSphereMaterial());
                    Ruler3dToolNodeJME3Object.this.toSphere = JME3PrimitivesUtilities.createSphere((float)newRadius, (AssetManager)Ruler3dToolNodeJME3Object.this.assetManager);
                    Ruler3dToolNodeJME3Object.this.toSphere.setMaterial(Ruler3dToolNodeJME3Object.this.createToSphereMaterial());
                    Ruler3dToolNodeJME3Object.this.fromTransformNode.attachChild((Spatial)Ruler3dToolNodeJME3Object.this.fromSphere);
                    Ruler3dToolNodeJME3Object.this.toTransformNode.attachChild((Spatial)Ruler3dToolNodeJME3Object.this.toSphere);
                }
                return null;
            }
        });
    }

    private void createGeometry() {
        this.rulerBodyColor = JME3Utilities.convertToColorRGBA((RGBA)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getRulerColor());
        this.minorTicksColor = JME3Utilities.convertToColorRGBA((RGBA)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMinorTickColor());
        this.majorTicksColor = JME3Utilities.convertToColorRGBA((RGBA)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMajorTickColor());
        this.fromTransformNode = new com.jme3.scene.Node("Ruler From");
        this.jme3Application.getRootNode().attachChild((Spatial)this.fromTransformNode);
        this.toTransformNode = new com.jme3.scene.Node("Ruler To");
        this.jme3Application.getRootNode().attachChild((Spatial)this.toTransformNode);
        this.rulerBodyGeometry = this.createRulerBodyGeometry();
        this.fromTransformNode.attachChild((Spatial)this.rulerBodyGeometry);
        this.minorTicksGeometry = this.createMinorTicksGeometry();
        this.fromTransformNode.attachChild((Spatial)this.minorTicksGeometry);
        this.majorTicksGeometry = this.createMajorTicksGeometry();
        this.fromTransformNode.attachChild((Spatial)this.majorTicksGeometry);
        this.fromSphere = JME3PrimitivesUtilities.createSphere((float)((float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getExtremitiesRadius()), (AssetManager)this.assetManager);
        this.fromSphere.setMaterial(this.createFromSphereMaterial());
        this.fromTransformNode.attachChild((Spatial)this.fromSphere);
        this.toSphere = JME3PrimitivesUtilities.createSphere((float)((float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getExtremitiesRadius()), (AssetManager)this.assetManager);
        this.toSphere.setMaterial(this.createToSphereMaterial());
        this.toTransformNode.attachChild((Spatial)this.toSphere);
    }

    private Geometry createRulerBodyGeometry() {
        Geometry geometry = new Geometry("Ruler Body", this.getRulerBodyMesh());
        geometry.setMaterial(this.createRulerBodyMaterial());
        return geometry;
    }

    private Material createRulerBodyMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", this.rulerBodyColor);
        return mat;
    }

    private Mesh getRulerBodyMesh() {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        verticesList.add(new Vector3f());
        verticesList.add(new Vector3f());
        indexesList.add(new Integer(0));
        indexesList.add(new Integer(1));
        mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private void updateFromTo() {
        if (((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getFromNode() != null) {
            this.fromTransformNode.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getFromAbsolutePosition().asTuple3d()));
        }
        if (((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getToNode() != null) {
            this.toTransformNode.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getToAbsolutePosition().asTuple3d()));
        }
    }

    private void updateRulerBody() {
        if (((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getFromNode() != null && ((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getToNode() != null) {
            Vector3f v = this.toTransformNode.getWorldTranslation().subtract(this.fromTransformNode.getWorldTranslation());
            FloatBuffer vertices = this.rulerBodyGeometry.getMesh().getFloatBuffer(VertexBuffer.Type.Position);
            vertices.rewind();
            vertices.put(0.0f);
            vertices.put(0.0f);
            vertices.put(0.0f);
            vertices.put(v.x);
            vertices.put(v.y);
            vertices.put(v.z);
            this.rulerBodyGeometry.getMesh().setBuffer(VertexBuffer.Type.Position, 3, vertices);
            this.rulerBodyGeometry.getMesh().updateBound();
            this.rulerBodyGeometry.getMesh().updateCounts();
            if (!this.fromTransformNode.getChildren().contains(this.rulerBodyGeometry)) {
                this.fromTransformNode.attachChild((Spatial)this.rulerBodyGeometry);
            }
        } else {
            this.fromTransformNode.detachChild((Spatial)this.rulerBodyGeometry);
        }
    }

    private Geometry createMinorTicksGeometry() {
        Geometry geometry = new Geometry("Ruler Minor Ticks", this.createMinorTicksMesh());
        geometry.setMaterial(this.createMinorTicksMaterial());
        return geometry;
    }

    private Material createMinorTicksMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", this.minorTicksColor);
        return mat;
    }

    private Mesh createMinorTicksMesh() {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        int i = 0;
        while (i < 100) {
            Vector3f p1 = new Vector3f((float)i, 0.0f, -0.001f);
            Vector3f p2 = new Vector3f((float)i, 0.0f, 0.001f);
            Vector3f p3 = new Vector3f((float)i, -0.001f, 0.0f);
            Vector3f p4 = new Vector3f((float)i, 0.001f, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            verticesList.add(p3);
            verticesList.add(p4);
            indexesList.add(new Integer(verticesList.indexOf(p1)));
            indexesList.add(new Integer(verticesList.indexOf(p2)));
            indexesList.add(new Integer(verticesList.indexOf(p3)));
            indexesList.add(new Integer(verticesList.indexOf(p4)));
            ++i;
        }
        mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private void updateMinorTicks() {
        if (((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getFromNode() != null && ((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getToNode() != null) {
            Vector3f v = this.toTransformNode.getWorldTranslation().subtract(this.fromTransformNode.getWorldTranslation());
            float length = v.length();
            FloatBuffer vertices = this.minorTicksGeometry.getMesh().getFloatBuffer(VertexBuffer.Type.Position);
            vertices.rewind();
            float tickIncrement = (float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMinorTickSpacing();
            if (tickIncrement <= 0.0f) {
                return;
            }
            int numberOfTicks = 0;
            float tickZ = (float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMinorTickLength() / 2.0f;
            float position = 0.0f;
            while (position <= length && numberOfTicks < 100) {
                Vector3f p1 = new Vector3f(position, 0.0f, tickZ);
                Vector3f p2 = new Vector3f(position, 0.0f, -tickZ);
                Vector3f p3 = new Vector3f(position, tickZ, 0.0f);
                Vector3f p4 = new Vector3f(position, -tickZ, 0.0f);
                vertices.put(p1.x);
                vertices.put(p1.y);
                vertices.put(p1.z);
                vertices.put(p2.x);
                vertices.put(p2.y);
                vertices.put(p2.z);
                vertices.put(p3.x);
                vertices.put(p3.y);
                vertices.put(p3.z);
                vertices.put(p4.x);
                vertices.put(p4.y);
                vertices.put(p4.z);
                position += tickIncrement;
                ++numberOfTicks;
            }
            while (numberOfTicks < 100) {
                int i = 0;
                while (i < 4) {
                    vertices.put(0.0f);
                    vertices.put(0.0f);
                    vertices.put(0.0f);
                    ++i;
                }
                ++numberOfTicks;
            }
            this.minorTicksGeometry.getMesh().setBuffer(VertexBuffer.Type.Position, 3, vertices);
            this.minorTicksGeometry.getMesh().updateBound();
            this.minorTicksGeometry.getMesh().updateCounts();
            if (!this.fromTransformNode.getChildren().contains(this.minorTicksGeometry)) {
                this.fromTransformNode.attachChild((Spatial)this.minorTicksGeometry);
            }
            Quaternion rot = this.getQuarternionV1ToV2(new Vector3f(1.0f, 0.0f, 0.0f), v.normalize());
            this.minorTicksGeometry.setLocalRotation(rot);
        } else {
            this.fromTransformNode.detachChild((Spatial)this.minorTicksGeometry);
        }
    }

    private Geometry createMajorTicksGeometry() {
        Geometry geometry = new Geometry("Ruler Major Ticks", this.createMajorTicksMesh());
        geometry.setMaterial(this.createMajorTicksMaterial());
        return geometry;
    }

    private Material createMajorTicksMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", this.majorTicksColor);
        return mat;
    }

    private Mesh createMajorTicksMesh() {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        int i = 0;
        while (i < 100) {
            Vector3f p1 = new Vector3f((float)i, 0.0f, -0.001f);
            Vector3f p2 = new Vector3f((float)i, 0.0f, 0.001f);
            Vector3f p3 = new Vector3f((float)i, -0.001f, 0.0f);
            Vector3f p4 = new Vector3f((float)i, 0.001f, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            verticesList.add(p3);
            verticesList.add(p4);
            indexesList.add(new Integer(verticesList.indexOf(p1)));
            indexesList.add(new Integer(verticesList.indexOf(p2)));
            indexesList.add(new Integer(verticesList.indexOf(p3)));
            indexesList.add(new Integer(verticesList.indexOf(p4)));
            ++i;
        }
        mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private void updateMajorTicks() {
        if (((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getFromNode() != null && ((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getToNode() != null) {
            Vector3f v = this.toTransformNode.getWorldTranslation().subtract(this.fromTransformNode.getWorldTranslation());
            float length = v.length();
            FloatBuffer vertices = this.majorTicksGeometry.getMesh().getFloatBuffer(VertexBuffer.Type.Position);
            vertices.rewind();
            float tickIncrement = (float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMajorTickSpacing();
            if (tickIncrement <= 0.0f) {
                return;
            }
            int numberOfTicks = 0;
            float tickZ = (float)((Ruler3dToolNode)this.getTopologyNode()).getRuler3DTool().getMajorTickLength() / 2.0f;
            float position = 0.0f;
            while (position <= length && numberOfTicks < 100) {
                Vector3f p1 = new Vector3f(position, 0.0f, tickZ);
                Vector3f p2 = new Vector3f(position, 0.0f, -tickZ);
                Vector3f p3 = new Vector3f(position, tickZ, 0.0f);
                Vector3f p4 = new Vector3f(position, -tickZ, 0.0f);
                vertices.put(p1.x);
                vertices.put(p1.y);
                vertices.put(p1.z);
                vertices.put(p2.x);
                vertices.put(p2.y);
                vertices.put(p2.z);
                vertices.put(p3.x);
                vertices.put(p3.y);
                vertices.put(p3.z);
                vertices.put(p4.x);
                vertices.put(p4.y);
                vertices.put(p4.z);
                position += tickIncrement;
                ++numberOfTicks;
            }
            while (numberOfTicks < 100) {
                int i = 0;
                while (i < 4) {
                    vertices.put(0.0f);
                    vertices.put(0.0f);
                    vertices.put(0.0f);
                    ++i;
                }
                ++numberOfTicks;
            }
            this.majorTicksGeometry.getMesh().setBuffer(VertexBuffer.Type.Position, 3, vertices);
            this.majorTicksGeometry.getMesh().updateBound();
            this.majorTicksGeometry.getMesh().updateCounts();
            if (!this.fromTransformNode.getChildren().contains(this.majorTicksGeometry)) {
                this.fromTransformNode.attachChild((Spatial)this.majorTicksGeometry);
            }
            Quaternion rot = this.getQuarternionV1ToV2(new Vector3f(1.0f, 0.0f, 0.0f), v.normalize());
            this.majorTicksGeometry.setLocalRotation(rot);
        } else {
            this.fromTransformNode.detachChild((Spatial)this.majorTicksGeometry);
        }
    }

    private Material createFromSphereMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", FROM_COLOR);
        return mat;
    }

    private Material createToSphereMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", TO_COLOR);
        return mat;
    }

    private Quaternion getQuarternionV1ToV2(Vector3f v1, Vector3f v2) {
        float angle = v2.angleBetween(v1);
        Vector3f axis = v1.cross(v2);
        axis = axis.normalize();
        Quaternion q = new Quaternion();
        q = q.fromAngleAxis(angle, axis);
        return q;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Ruler3dToolNode) {
                        int featureId = msg.getFeatureID(Ruler3dToolNode.class);
                        if (featureId == 3) {
                            if (msg.getOldValue() instanceof Ruler3dToolNode) {
                                Ruler3dToolNode oldValue = (Ruler3dToolNode)msg.getOldValue();
                                oldValue.eAdapters().remove((Object)Ruler3dToolNodeJME3Object.this.getAdapter());
                                Ruler3dToolNodeJME3Object.this.requestUpdate();
                            }
                            if (msg.getNewValue() instanceof Ruler3dToolNode) {
                                Ruler3dToolNode newValue = (Ruler3dToolNode)msg.getNewValue();
                                newValue.eAdapters().add((Object)Ruler3dToolNodeJME3Object.this.getAdapter());
                                Ruler3dToolNodeJME3Object.this.requestUpdate();
                            }
                        }
                    } else if (msg.getNotifier() instanceof Ruler3DTool) {
                        int featureId = msg.getFeatureID(Ruler3DTool.class);
                        switch (featureId) {
                            case 8: 
                            case 13: {
                                if (!Ruler3dToolNodeJME3Object.this.isVisible()) break;
                                Ruler3dToolNodeJME3Object.this.requestUpdate();
                                break;
                            }
                            case 19: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                RGBA color = (RGBA)msg.getNewValue();
                                Ruler3dToolNodeJME3Object.this.setRulerColor(color);
                                break;
                            }
                            case 22: {
                                Ruler3dToolNodeJME3Object.this.setMinorTickSpacing((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 25: {
                                Ruler3dToolNodeJME3Object.this.setMajorTickSpacing((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 23: {
                                Ruler3dToolNodeJME3Object.this.setMinorTickLength((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 26: {
                                Ruler3dToolNodeJME3Object.this.setMajorTickLength((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 21: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                RGBA color = (RGBA)msg.getNewValue();
                                Ruler3dToolNodeJME3Object.this.setMinorTicksColor(color);
                                break;
                            }
                            case 24: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                RGBA color = (RGBA)msg.getNewValue();
                                Ruler3dToolNodeJME3Object.this.setMajorTicksColor(color);
                                break;
                            }
                            case 20: {
                                Ruler3dToolNodeJME3Object.this.setExtremitiesRadius((float)msg.getNewDoubleValue());
                                break;
                            }
                            case 6: {
                                Ruler3dToolNodeJME3Object.this.setVisible(msg.getNewBooleanValue());
                                break;
                            }
                            case 27: {
                                if (((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool() != null) {
                                    ((Ruler3dToolNode)Ruler3dToolNodeJME3Object.this.getTopologyNode()).getRuler3DTool().eAdapters().remove((Object)Ruler3dToolNodeJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() != null) break;
                                Ruler3dToolNodeJME3Object.this.dispose();
                                break;
                            }
                            case 1: {
                                Ruler3dToolNodeJME3Object.this.dispose();
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

