/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ui.parts;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.addons.ApogyAddonsFacade;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.SimpleTool;
import org.eclipse.apogy.addons.SimpleToolList;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionECollectionPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleToolsPart
extends AbstractSessionECollectionPart<InvocatorSession> {
    private static final Logger Logger = LoggerFactory.getLogger(SimpleToolsPart.class);
    private EMFFormsEListComposite<SimpleToolList, SimpleToolList, SimpleTool> toolsComposite;
    @Inject
    public ESelectionService selectionService;

    public AbstractECollectionComposite<?, ?, ?> createECollectionComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("Available Simple Tools");
        settings.setDetailSectionDisplayed(true);
        settings.setDetailSectionTitle("Details");
        settings.setButtonsSectionDisplayed(true);
        this.toolsComposite = new EMFFormsEListComposite<SimpleToolList, SimpleToolList, SimpleTool>(parent, 0, null, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS, settings){

            protected void createButtons(Composite parent, int style) {
                this.createNewButton(parent, style);
                this.createDeleteButton(parent, style);
                this.createSeparator(parent, style);
                this.createActivateButton(parent, style);
                this.createDeActivateButton(parent, style);
            }

            protected void doNew() {
                AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
                settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName(this.getResolvedEObject(), null, (ETypedElement)ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS));
                EObjectWizard wizard = new EObjectWizard(this.getResolvedEObject(), null, ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS, ApogyAddonsPackage.Literals.SIMPLE_TOOL, (EClassSettings)settings);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
            }

            protected void doDelete(SimpleTool simpleTool) {
                ApogyAddonsFacade.INSTANCE.deleteTool(simpleTool);
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    SimpleTool simpleTool = (SimpleTool)this.getSelectedItemObjects().get(0);
                    SimpleToolsPart.this.selectionService.setSelection((Object)simpleTool);
                }
            }

            protected void doActivate(List<SimpleTool> list) {
                for (SimpleTool simpleTool : list) {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)simpleTool, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL__ACTIVE, (Object)true, true);
                    }
                    catch (Exception e) {
                        Logger.error("Failed to activate Simple Tool <" + simpleTool + ">!", (Throwable)e);
                    }
                }
            }

            protected Button createDeActivateButton(Composite parent, int style) {
                Button btnDeActivate = 1.createButton((Composite)parent, (int)0, (String)"De-Activate", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                    this.doDeActivate(this.getViewer().getStructuredSelection().toList());
                    this.refreshViewer();
                }));
                this.createDeActivateButtonBindings(btnDeActivate);
                return btnDeActivate;
            }

            protected void createDeActivateButtonBindings(Button button) {
                ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
                    if (o != null) {
                        return true;
                    }
                    return false;
                });
            }

            protected void doDeActivate(List<SimpleTool> list) {
                for (SimpleTool simpleTool : list) {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)simpleTool, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL__ACTIVE, (Object)false, true);
                    }
                    catch (Exception e) {
                        Logger.error("Failed to de-activate Simple Tool <" + simpleTool + ">!", (Throwable)e);
                    }
                }
            }
        };
        return this.toolsComposite;
    }

    protected void doSetContent(InvocatorSession invocatorSession) {
        this.toolsComposite.setRootEObject((EObject)this.resolveSimpleToolList(invocatorSession));
    }

    protected void sessionChanged(InvocatorSession invocatorSession) {
        this.setContent((EObject)invocatorSession);
    }

    protected SimpleToolList resolveSimpleToolList(InvocatorSession invocatorSession) {
        SimpleToolList simpleToolList = null;
        if (invocatorSession != null) {
            Iterator it = invocatorSession.getToolsList().getToolsListContainers().iterator();
            while (it.hasNext() && simpleToolList == null) {
                AbstractToolsListContainer list = (AbstractToolsListContainer)it.next();
                if (!(list instanceof SimpleToolList)) continue;
                simpleToolList = (SimpleToolList)list;
            }
        }
        return simpleToolList;
    }
}

