/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.vehicle.Wheel;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;

public class WheelJME3Object
extends DefaultJME3SceneObject<Wheel> {
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry wheelGeometry = null;
    private ColorRGBA wheelColor = ColorRGBA.White;

    public WheelJME3Object(Wheel node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.wheelGeometry = this.createWheelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.wheelGeometry);
        ((Wheel)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.wheelGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.wheelGeometry);
        }
        this.wheelGeometry = this.createWheelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.wheelGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.wheelGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((Wheel)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public void setColor(RGBA rgb) {
        this.wheelColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (WheelJME3Object.this.wheelGeometry != null) {
                    WheelJME3Object.this.wheelGeometry.getMaterial().setColor("Color", WheelJME3Object.this.wheelColor.clone());
                }
                return null;
            }
        });
    }

    private Geometry createWheelGeometry() {
        Geometry geometry = new Geometry("Wheel Body", this.createWheelMesh());
        geometry.setMaterial(this.createWheelMaterial());
        Quaternion q = new Quaternion();
        q.fromAngleAxis(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Mesh createWheelMesh() {
        Cylinder cylinder = new Cylinder(4, 18, (float)((Wheel)this.getTopologyNode()).getRadius(), (float)((Wheel)this.getTopologyNode()).getLength(), true);
        cylinder.setMode(Mesh.Mode.Lines);
        return cylinder;
    }

    private Material createWheelMaterial() {
        ColorRGBA color = this.wheelColor.clone();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Wheel) {
                        int featureId = msg.getFeatureID(Wheel.class);
                        switch (featureId) {
                            case 11: 
                            case 12: {
                                WheelJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

