/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.composites;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.PathPlannerTool;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.EditingDomainsValidity;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.SurfaceWorksite;
import org.eclipse.apogy.core.environment.surface.ui.composites.DEMListComposite;
import org.eclipse.apogy.core.environment.surface.ui.composites.MapsListComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPlannerToolComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(PathPlannerToolComposite.class);
    private SurfaceWorksite surfaceWorksite;
    private PathPlannerTool pathPlannerTool;
    private DataBindingContext m_bindingContext;
    private final Button btnAutoPathPlanEnabled;
    private final Button btnPlanPath;
    private final Group grpMesh;
    private final MapsListComposite mapsListComposite;
    private final DEMListComposite demListComposite;

    public PathPlannerToolComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Group grpPathPlanningSettings = new Group((Composite)this, 2048);
        grpPathPlanningSettings.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        grpPathPlanningSettings.setText("Path Planning");
        grpPathPlanningSettings.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label((Composite)grpPathPlanningSettings, 0);
        lblNewLabel.setText("Enable Auto Re-Plan:");
        this.btnAutoPathPlanEnabled = new Button((Composite)grpPathPlanningSettings, 32);
        this.btnAutoPathPlanEnabled.setToolTipText("Whether or not automatic path planning is enabled. When enabled, changing the destination will automatically start a replan of the path");
        this.btnPlanPath = new Button((Composite)grpPathPlanningSettings, 0);
        this.btnPlanPath.setText("Pan Path");
        this.btnPlanPath.setToolTipText("Initiate an update of the path.");
        this.btnPlanPath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (PathPlannerToolComposite.this.getPathPlannerTool() != null) {
                            PathPlannerToolComposite.this.getPathPlannerTool().getPathPlanner().setProgressMonitor(monitor);
                            PathPlannerToolComposite.this.getPathPlannerTool().planPath();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(PathPlannerToolComposite.this.getShell()).run(true, true, runnable);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.grpMesh = new Group((Composite)this, 2048);
        this.grpMesh.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.grpMesh.setText("Mesh");
        this.grpMesh.setLayout((Layout)new GridLayout(2, false));
        Label lblMapsLabel = new Label((Composite)this.grpMesh, 0);
        lblMapsLabel.setText("Maps");
        Label lblMeshesLabel = new Label((Composite)this.grpMesh, 0);
        lblMeshesLabel.setText("Meshes");
        this.mapsListComposite = new MapsListComposite((Composite)this.grpMesh, 2048, null){

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    Map map = (Map)this.getSelectedItemObjects().get(0);
                    PathPlannerToolComposite.this.demListComposite.setRootEObject((EObject)map);
                }
            }
        };
        this.mapsListComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        this.demListComposite = new DEMListComposite((Composite)this.grpMesh, 2048, null){

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    CartesianTriangularMeshMapLayer cartesianTriangularMeshMapLayer = (CartesianTriangularMeshMapLayer)this.getSelectedItemObjects().get(0);
                    if (PathPlannerToolComposite.this.getPathPlannerTool() != null) {
                        if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid((EObject)PathPlannerToolComposite.this.getPathPlannerTool(), (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__MESH_LAYER, (Object)cartesianTriangularMeshMapLayer, false) == EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)PathPlannerToolComposite.this.getPathPlannerTool(), (EStructuralFeature)ApogyAddonsVehiclePackage.Literals.PATH_PLANNER_TOOL__MESH_LAYER, (Object)cartesianTriangularMeshMapLayer);
                        } else {
                            PathPlannerToolComposite.this.getPathPlannerTool().setMeshLayer(cartesianTriangularMeshMapLayer);
                        }
                    }
                    PathPlannerToolComposite.this.newMeshSelected(cartesianTriangularMeshMapLayer);
                }
            }
        };
        this.demListComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PathPlannerToolComposite.this.m_bindingContext != null) {
                    PathPlannerToolComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public PathPlannerTool getPathPlannerTool() {
        return this.pathPlannerTool;
    }

    public void setPathPlannerTool(PathPlannerTool pathPlannerTool) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.pathPlannerTool = pathPlannerTool;
        if (pathPlannerTool != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
    }

    public SurfaceWorksite getSurfaceWorksite() {
        return this.surfaceWorksite;
    }

    public void setSurfaceWorksite(SurfaceWorksite newSurfaceWorksite) {
        this.surfaceWorksite = newSurfaceWorksite;
        if (newSurfaceWorksite != null) {
            this.mapsListComposite.setRootEObject((EObject)newSurfaceWorksite);
        } else {
            this.mapsListComposite.setRootEObject(null);
        }
    }

    protected void newMeshSelected(CartesianTriangularMeshMapLayer layer) {
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

