/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.impl;

import org.eclipse.apogy.addons.vehicle.ui.Activator;
import org.eclipse.apogy.addons.vehicle.ui.ThrusterSceneObject;
import org.eclipse.apogy.addons.vehicle.ui.impl.ThrusterPresentationImpl;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;

public class ThrusterPresentationCustomImpl
extends ThrusterPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected ThrusterPresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_THRUSTER_PLUME_ENVELOPE_COLOR_ID");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setPlumeEnvelopeVisible(store.getBoolean("DEFAULT_THRUSTER_PLUME_ENVELOPE_VISIBILITY_ID"));
        this.setPlumeEnvelopeLength(store.getDouble("DEFAULT_THRUSTER_PLUME_ENVELOPE_LENGTH_ID"));
        super.applyPreferences();
    }

    protected void updateSceneObject(Notification notification) {
        if (this.sceneObject != null) {
            ThrusterSceneObject thrusterSceneObject = (ThrusterSceneObject)this.sceneObject;
            int featureID = notification.getFeatureID(ThrusterPresentationCustomImpl.class);
            switch (featureID) {
                case 16: {
                    thrusterSceneObject.setPlumeEnvelopeVisible(notification.getNewBooleanValue());
                    break;
                }
                case 17: {
                    thrusterSceneObject.setPlumeEnvelopeLength(notification.getNewDoubleValue());
                    break;
                }
                case 2: {
                    if (!(notification.getNewValue() instanceof RGBA)) break;
                    RGBA color = (RGBA)notification.getNewValue();
                    thrusterSceneObject.setColor(color);
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected void initialSceneObject() {
        ThrusterSceneObject thrusterSceneObject = (ThrusterSceneObject)this.sceneObject;
        thrusterSceneObject.setPlumeEnvelopeVisible(this.isPlumeEnvelopeVisible());
        thrusterSceneObject.setPlumeEnvelopeLength(this.getPlumeEnvelopeLength());
        thrusterSceneObject.setColor(this.getColor());
        super.initialSceneObject();
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ThrusterPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }

    protected void finalize() throws Throwable {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPreferencesListener());
        super.finalize();
    }
}

