/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.apogy.addons.vehicle.ui.composites.VehiculePoseComposite;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehiclePosePart
extends AbstractSessionPart<VariableFeatureReference> {
    private static final Logger Logger = LoggerFactory.getLogger(VehiclePosePart.class);
    private double tripDistance = 0.0;
    private double alarmMinPitch = Math.toRadians(-20.0);
    private double alarmMaxPitch = Math.toRadians(20.0);
    private double warningMinPitch = Math.toRadians(-10.0);
    private double warningMaxPitch = Math.toRadians(10.0);
    private double alarmMinRoll = Math.toRadians(-20.0);
    private double alarmMaxRoll = Math.toRadians(20.0);
    private double warningMinRoll = Math.toRadians(-10.0);
    private double warningMaxRoll = Math.toRadians(10.0);
    private VehiculePoseComposite vehiculePoseComposite;
    private VariableFeatureReference variableFeatureReference = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
    @Inject
    public MPart mPart;

    protected void doSetContent(VariableFeatureReference rootEObject) {
        this.vehiculePoseComposite.setVariableFeatureReference(rootEObject);
    }

    protected void createComposite(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        VariablesList variables = null;
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null && ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment() != null) {
            ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getVariablesList();
        }
        ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)this.variableFeatureReference);
        this.vehiculePoseComposite = new VehiculePoseComposite(parent, style, variables, this.variableFeatureReference, this.tripDistance);
        this.vehiculePoseComposite.getAttitudeIndicatorComposite().setPitchAlarmValues(this.alarmMinPitch, this.alarmMaxPitch);
        this.vehiculePoseComposite.getAttitudeIndicatorComposite().setPitchWarningValues(this.warningMinPitch, this.warningMaxPitch);
        this.vehiculePoseComposite.getAttitudeIndicatorComposite().setRollAlarmValues(this.alarmMinRoll, this.alarmMaxRoll);
        this.vehiculePoseComposite.getAttitudeIndicatorComposite().setRollWarningValues(this.warningMinRoll, this.warningMaxRoll);
    }

    protected void sessionChanged(InvocatorSession invocatorSession) {
        if (invocatorSession != null) {
            this.readAllValuesFromPersistedState();
            System.out.println(this.variableFeatureReference);
            this.setContent((EObject)this.variableFeatureReference);
        }
    }

    protected String getNoContentMessage() {
        return "No Variable Pose to display.";
    }

    @Inject
    @PostConstruct
    public void postConstruct(MPart mPart) {
        try {
            this.readAllValuesFromPersistedState();
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    @Inject
    @PersistState
    public void persistState(MPart mPart) {
        if (this.vehiculePoseComposite != null) {
            ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(mPart, "variableFeatureReference", (EObject)this.variableFeatureReference);
            mPart.getPersistedState().put("distance", Double.toString(this.vehiculePoseComposite.getTripDistance()));
            mPart.getPersistedState().put("alarmMinPitch", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getPitchAlarmMinLimit()));
            mPart.getPersistedState().put("alarmMaxPitch", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getPitchAlarmMaxLimit()));
            mPart.getPersistedState().put("warningMinPitch", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getPitchWarningMinLimit()));
            mPart.getPersistedState().put("warningMaxPitch", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getPitchWarningMaxLimit()));
            mPart.getPersistedState().put("alarmMinRoll", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getRollAlarmMinLimit()));
            mPart.getPersistedState().put("alarmMaxRoll", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getRollAlarmMaxLimit()));
            mPart.getPersistedState().put("warningMinRoll", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getRollWarningMinLimit()));
            mPart.getPersistedState().put("warningMaxRoll", Double.toString(this.vehiculePoseComposite.getAttitudeIndicatorComposite().getRollWarningMaxLimit()));
        }
    }

    private void readAllValuesFromPersistedState() {
        VariableFeatureReference vfr;
        double value = this.getDoubleValueFromPersistedState("distance");
        if (!Double.isNaN(value)) {
            this.tripDistance = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("alarmMinPitch"))) {
            this.alarmMinPitch = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("alarmMaxPitch"))) {
            this.alarmMaxPitch = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("warningMinPitch"))) {
            this.warningMinPitch = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("warningMaxPitch"))) {
            this.warningMaxPitch = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("alarmMinRoll"))) {
            this.alarmMinRoll = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("alarmMaxRoll"))) {
            this.alarmMaxRoll = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("warningMinRoll"))) {
            this.warningMinRoll = value;
        }
        if (!Double.isNaN(value = this.getDoubleValueFromPersistedState("warningMaxRoll"))) {
            this.warningMaxRoll = value;
        }
        if ((vfr = (VariableFeatureReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, "variableFeatureReference")) != null) {
            this.variableFeatureReference = vfr;
        }
    }

    private double getDoubleValueFromPersistedState(String key) {
        double value = Double.NaN;
        String valueString = (String)this.mPart.getPersistedState().get(key);
        if (valueString != null) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }
}

