/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import java.util.Collection;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.ApogyAddonsFactory;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.TrajectoryPickingToolNode;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.impl.TrajectoryPickingToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryPickingToolCustomImpl
extends TrajectoryPickingToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TrajectoryPickingToolImpl.class);

    @Override
    public void setActivePath(WayPointPath newActivePath) {
        if (newActivePath == null || this.getPaths().contains((Object)newActivePath)) {
            super.setActivePath(newActivePath);
            Logger.info("Sucessfully set Active Path to <" + newActivePath + ">.");
        } else {
            Logger.error("Failed to set Active Path : The specified path <" + newActivePath + "> is not contained in the tool's path list.");
        }
    }

    @Override
    public void clearActivePath() {
        if (this.getActivePath() != null) {
            EList coords = this.getActivePath().getPoints();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Collection)coords, true);
            Logger.info("Active path cleared.");
            this.updateTotalLength();
        } else {
            Logger.info("Failed to clear active path : No active path selected.");
        }
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        if (this.getRootNode() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getRootNode();
            if (newVisible) {
                if (!parent.getChildren().contains((Object)this.getTrajectoryPickingToolNode())) {
                    parent.getChildren().add((Object)this.getTrajectoryPickingToolNode());
                }
            } else if (parent.getChildren().contains((Object)this.getTrajectoryPickingToolNode())) {
                parent.getChildren().remove((Object)this.getTrajectoryPickingToolNode());
            }
        }
        this.getTrajectoryPickingToolNode();
    }

    @Override
    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        TrajectoryPickingToolNode toolNode = this.getTrajectoryPickingToolNode();
        if (toolNode != null && newRootNode instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getRootNode();
            if (this.isVisible()) {
                parent.getChildren().add((Object)toolNode);
            } else {
                parent.getChildren().remove((Object)toolNode);
            }
        }
    }

    @Override
    public void selectionChanged(NodeSelection nodeSelection) {
        if (nodeSelection.getSelectedNode() instanceof ContentNode || nodeSelection.getSelectedNode() instanceof CartesianTriangularMeshMapLayerNode) {
            if (this.getActivePath() != null) {
                Point3d point = nodeSelection.getAbsoluteIntersectionPoint();
                point.z += this.getAltitudeOffset();
                CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)coord);
                this.updateTotalLength();
                Logger.info("Point added : (" + point.x + ", " + point.y + ", " + point.z + "), total lenght is " + this.getTotalLength());
            } else {
                Logger.error("Failed to add point : No active path selected.");
            }
        }
    }

    @Override
    public void mouseButtonClicked(MouseButton mouseButtonClicked) {
        if (mouseButtonClicked == MouseButton.RIGHT && this.getActivePath() != null && !this.getActivePath().getPoints().isEmpty()) {
            CartesianPositionCoordinates coord = (CartesianPositionCoordinates)this.getActivePath().getPoints().get(this.getActivePath().getPoints().size() - 1);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.getActivePath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)coord);
        }
    }

    @Override
    public void initialise() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY_PICKING_TOOL__TRAJECTORY_PICKING_TOOL_NODE, (Object)ApogyAddonsFactory.eINSTANCE.createTrajectoryPickingToolNode());
        super.initialise();
        this.updateTotalLength();
    }

    @Override
    public void dispose() {
        if (this.trajectoryPickingToolNode != null) {
            if (this.trajectoryPickingToolNode.getParent() instanceof GroupNode) {
                GroupNode parent = (GroupNode)this.trajectoryPickingToolNode.getParent();
                parent.getChildren().remove((Object)this.trajectoryPickingToolNode);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY_PICKING_TOOL__TRAJECTORY_PICKING_TOOL_NODE, null);
        }
        super.dispose();
    }

    private void updateTotalLength() {
        double distance = 0.0;
        for (WayPointPath wayPointPath : this.getPaths()) {
            distance += wayPointPath.getLength();
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY_PICKING_TOOL__TOTAL_LENGTH, (Object)distance);
    }
}

