/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToIntegerConverter
extends AbstractNumberConverter {
    private static final Logger Logger = LoggerFactory.getLogger(StringToIntegerConverter.class);

    public StringToIntegerConverter() {
        super(String.class, Integer.class);
    }

    public StringToIntegerConverter(NumberFormat numberFormat) {
        super(String.class, Integer.class);
        this.setNumberFormat(numberFormat);
    }

    public Object convert(Object fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Integer(this.getNumberFormat().parse((String)fromObject).intValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Integer((String)fromObject);
    }
}

