/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.pif.ui.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.pif.PifReader;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.core.resources.IFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsContextPifAdapter
implements GraphicsContextAdapter {
    private static final Logger Logger = LoggerFactory.getLogger(GraphicsContextPifAdapter.class);
    public static final String SUPPORTED_EXTENSION = "pf";

    public boolean isAdapterFor(Object obj) {
        boolean ok = false;
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            ok = file.getName().endsWith(".pf");
        }
        return ok;
    }

    public GraphicsContext getAdapter(Object obj, Object context) {
        GraphicsContext grContext = null;
        if (this.isAdapterFor(obj)) {
            IFile file = (IFile)obj;
            try {
                PifReader reader = new PifReader(file.getLocation().toOSString());
                List points = reader.getPoints();
                CartesianCoordinatesSet pts = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
                ArrayList<CartesianPositionCoordinates> pointList = new ArrayList<CartesianPositionCoordinates>(points.size());
                for (Point3f p : points) {
                    CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates((double)p.getX(), (double)p.getY(), (double)p.getZ());
                    pointList.add(point);
                }
                pts.getPoints().addAll(pointList);
                GroupNode root = ApogyCommonTopologyFactory.eINSTANCE.createGroupNode();
                ContentNode pointNode = ApogyCommonTopologyFacade.INSTANCE.createContentNode((Object)pts);
                root.getChildren().add((Object)pointNode);
                grContext = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
                grContext.setTopology((Node)root);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return grContext;
    }

    public Class<?> getAdaptedClass() {
        return IFile.class;
    }
}

