/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.pif.ui.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.vecmath.Point3f;
import org.eclipse.apogy.common.geometry.data3d.pif.PifReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIFToXYZExportCommandHandler
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(PIFToXYZExportCommandHandler.class);
    private static final String INPUT_FILE_EXTENSION = ".pf";
    private static final String OUTPUT_FILE_EXTENSION = ".xyz";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object selection : (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) {
            IFile file;
            String filePath;
            if (!(selection instanceof IFile) || !(filePath = (file = (IFile)selection).getLocation().toOSString()).endsWith(INPUT_FILE_EXTENSION)) continue;
            PIFToXYZExportJob job = new PIFToXYZExportJob(filePath);
            job.setUser(true);
            job.schedule();
            break;
        }
        return null;
    }

    private class PIFToXYZExportJob
    extends Job {
        private static final String JOB_NAME = "PIF to XYZ Export";
        private final String filePath;
        private final Shell shell;

        public PIFToXYZExportJob(String filePath) {
            super(JOB_NAME);
            this.filePath = filePath;
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Importing...", -1);
            try {
                try {
                    PifReader reader = new PifReader(this.filePath);
                    List points = reader.getPoints();
                    this.writePoints(points);
                }
                catch (IOException e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)PIFToXYZExportJob.this.shell, (String)"Error", (String)("Error while importing file " + PIFToXYZExportJob.this.filePath + ": " + e.getMessage()));
                        }
                    };
                    this.shell.getDisplay().asyncExec(run);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void writePoints(List<Point3f> points) throws FileNotFoundException {
            File f = new File(this.filePath);
            String dir = f.getParent();
            final String outputFile = String.valueOf(dir) + File.separator + f.getName().replace(PIFToXYZExportCommandHandler.INPUT_FILE_EXTENSION, PIFToXYZExportCommandHandler.OUTPUT_FILE_EXTENSION);
            FileOutputStream fos = new FileOutputStream(new File(outputFile));
            PrintWriter writer = new PrintWriter(fos);
            for (Point3f p : points) {
                writer.println(String.valueOf(p.x) + " " + p.y + " " + p.z);
            }
            writer.flush();
            writer.close();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PIFToXYZExportJob.this.shell, (String)"Info", (String)("File exported to " + outputFile));
                }
            };
            this.shell.getDisplay().asyncExec(run);
        }
    }
}

