/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.AdapterFactory;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Adapter;
import org.eclipse.apogy.common.topology.ui.jme3.JME3SceneObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);
    public static final String ID = "org.eclipse.apogy.common.topology.ui.jme3";
    public static final String JME3_EXTENSION_POINT_ID = "org.eclipse.apogy.common.topology.ui.jme3.jme3Adapter";
    private static final String JME3_EXTENSION_POINT_ID_CLASS = "Class";
    private static BundleContext context;
    private static Activator plugin;
    private AdapterFactory<JME3Adapter, JME3SceneObject, Node, Object> jme3AdapterFactory;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public AdapterFactory<JME3Adapter, JME3SceneObject, Node, Object> getJME3AdapterFactory() {
        if (this.jme3AdapterFactory == null) {
            List<JME3Adapter> adapters = this.getRegisteredJME3Adapters();
            this.jme3AdapterFactory = new AdapterFactory(adapters);
        }
        return this.jme3AdapterFactory;
    }

    public List<JME3Adapter> getRegisteredJME3Adapters() {
        ArrayList<JME3Adapter> adapters = new ArrayList<JME3Adapter>();
        IExtensionPoint nodePresentationExtPoint = Platform.getExtensionRegistry().getExtensionPoint(JME3_EXTENSION_POINT_ID);
        IConfigurationElement[] contributors = nodePresentationExtPoint.getConfigurationElements();
        int i = 0;
        while (i < contributors.length) {
            IConfigurationElement contributor = contributors[i];
            try {
                JME3Adapter adapter = (JME3Adapter)contributor.createExecutableExtension(JME3_EXTENSION_POINT_ID_CLASS);
                adapters.add(adapter);
            }
            catch (CoreException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return adapters;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

