/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.lwjgl.LwjglCanvas;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.internal.CreateSceneGraphHTMLActionListener;
import org.eclipse.apogy.common.topology.ui.jme3.internal.CustomCameraControl;
import org.eclipse.apogy.common.topology.ui.jme3.internal.CustomScreenshotAppState;
import org.eclipse.apogy.common.topology.ui.jme3.internal.ICameraControl;
import org.eclipse.apogy.common.topology.ui.jme3.internal.MouseClickListener;
import org.eclipse.apogy.common.topology.ui.jme3.internal.MousePickListener;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JME3Application
extends SimpleApplication {
    private static final Logger Logger = LoggerFactory.getLogger(JME3Application.class);
    public static final String JME3_CANVAS_INIT_DELAY_ENV_VAR = "JME3_CANVAS_INIT_DELAY";
    public static final long DEFAULT_JME3_CANVAS_DELAY = 5000L;
    private JME3RenderEngineDelegate jme3RenderEngineDelegate;
    private final Composite jme3Window;
    private final Frame jme3awtFrame;
    private boolean ambientLightEnabled = false;
    private Node sceneCentreTransform;
    private Node sceneRoot;
    private ICameraControl customCamera;
    private CustomScreenshotAppState customScreenshotAppState;
    private CreateSceneGraphHTMLActionListener createSceneGraphHTMLActionListener;
    private MousePickListener mousePickListener;
    private MouseClickListener mouseClickListener;
    private final DirectionalLight skyLight = new DirectionalLight();
    private final List<Light> lights = new ArrayList<Light>();

    public JME3Application(Composite parent) {
        AppSettings newSetting = new AppSettings(true);
        newSetting.setFrameRate(Activator.getDefault().getMaximumFrameRate());
        if (Activator.getDefault().isAntialiasing()) {
            newSetting.setSamples(4);
        } else {
            newSetting.setSamples(0);
        }
        newSetting.setMinResolution(640, 480);
        this.setSettings(newSetting);
        this.start(JmeContext.Type.Canvas);
        LwjglCanvas canvas = (LwjglCanvas)this.getContext();
        this.startCanvas(true);
        this.jme3Window = new Composite(parent, 0x1000000);
        this.jme3Window.addFocusListener(new FocusListener(){
            private long focusLostTime = 0L;

            public void focusLost(FocusEvent e) {
                this.focusLostTime = System.currentTimeMillis();
                JME3Application.this.enableMouseNavigation(false);
            }

            public void focusGained(FocusEvent e) {
                long now = System.currentTimeMillis();
                if (now - this.focusLostTime > 1000L) {
                    JME3Application.this.enableMouseNavigation(true);
                } else {
                    JME3Application.this.enableMouseNavigation(false);
                }
            }
        });
        this.jme3awtFrame = SWT_AWT.new_Frame((Composite)this.jme3Window);
        this.jme3awtFrame.add(canvas.getCanvas());
        canvas.getCanvas().setFocusable(false);
        this.setShowStatisticsEnabled(false);
    }

    public void setJMERenderEngineDelegate(JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        this.jme3RenderEngineDelegate = jme3RenderEngineDelegate;
    }

    public JME3RenderEngineDelegate getJMERenderEngineDelegate() {
        return this.jme3RenderEngineDelegate;
    }

    public void simpleInitApp() {
        this.waitForCanvasInitialization();
        this.setPauseOnLostFocus(false);
        this.createSceneGraph();
        this.getCamera().setFrustumFar(25000.0f);
        this.getCamera().setLocation(new Vector3f(-10.0f, 0.0f, 0.0f));
        this.getCamera().lookAt(new Vector3f(), Vector3f.UNIT_Z);
        this.initLighting();
        this.getFlyByCamera().setEnabled(false);
        this.customCamera = new CustomCameraControl(this.getCamera(), this.getSceneRoot(), this.inputManager, this);
        this.customCamera.setEnabled(true);
        this.createSceneGraphHTMLActionListener = new CreateSceneGraphHTMLActionListener(this.inputManager, this);
        this.createSceneGraphHTMLActionListener.setEnabled(true);
        this.getMousePickListener();
        this.getMouseClickListener();
    }

    public AssetManager getAssetManager() {
        int tries = 0;
        while (super.getAssetManager() == null && tries < 20) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.getAssetManager();
    }

    public void setShowStatisticsEnabled(boolean enable) {
        this.setDisplayFps(enable);
        this.setDisplayStatView(enable);
    }

    public void setAntiAliasing(boolean enable) {
        Logger.info("Setting anti aliasing to <" + enable + ">.");
        this.settings.setFrameRate(Activator.getDefault().getMaximumFrameRate());
        if (enable) {
            this.settings.setSamples(4);
        } else {
            this.settings.setSamples(0);
        }
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JME3Application.this.setSettings(JME3Application.this.settings);
                JME3Application.this.restart();
                return null;
            }
        });
    }

    public void setMaximumFrameRate(int maximumFrameRate) {
        Logger.info("Setting Maximum Frame Rate to <" + maximumFrameRate + "> fps.");
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        this.settings.setFrameRate(maximumFrameRate);
        this.setSettings(this.settings);
    }

    public void setSkyLightEnabled(boolean enable) {
        Logger.info("Setting Sky Light Enabled to <" + enable + ">.");
        boolean previousSkyLightEnabled = this.ambientLightEnabled;
        this.ambientLightEnabled = enable;
        if (previousSkyLightEnabled && !enable) {
            for (Light light : this.lights) {
                if (this.lightIsAttached(light)) continue;
                this.rootNode.addLight(light);
            }
            this.rootNode.removeLight((Light)this.skyLight);
        } else if (!previousSkyLightEnabled && enable) {
            this.lights.clear();
            Iterator it = this.rootNode.getLocalLightList().iterator();
            while (it.hasNext()) {
                this.lights.add((Light)it.next());
            }
            for (Light light : this.lights) {
                this.rootNode.removeLight(light);
            }
            if (!this.lightIsAttached((Light)this.skyLight)) {
                this.rootNode.addLight((Light)this.skyLight);
            }
        }
    }

    public void setSkyLightColor(int red, int green, int blue) {
        Logger.info("Setting Sky Light Color to <" + red + ", " + green + ", " + blue + "> .");
        this.skyLight.setColor(new ColorRGBA((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f));
    }

    public void setSkyLightDirection(float x, float y, float z) {
        Logger.info("Setting Sky Light Direction to <" + x + ", " + y + ", " + z + "> .");
        this.skyLight.setDirection(new Vector3f(x, y, z));
    }

    public BufferedImage takeScreenshot() {
        this.getCustomScreenshotAppState().takeSnapshot();
        int tries = 0;
        while (this.getCustomScreenshotAppState().getCapturedImage() == null && tries < 5) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            ++tries;
        }
        return this.getCustomScreenshotAppState().getCapturedImage();
    }

    public void levelViewPoint() {
        if (this.customCamera != null) {
            this.customCamera.levelPose();
        }
    }

    public void setHighSpeedMotionEnabled(boolean highSpeedMotionEnabled) {
        if (this.customCamera != null) {
            this.customCamera.setHighSpeedMotionEnabled(highSpeedMotionEnabled);
        }
    }

    public void setPickingModeEnabled(boolean pickingModeEnabled) {
        if (this.mousePickListener != null) {
            this.mousePickListener.setPickEnabled(pickingModeEnabled);
        }
    }

    public void dispose() {
        this.getCustomScreenshotAppState().setEnabled(false);
        this.stop();
        if (this.jme3awtFrame != null) {
            this.jme3awtFrame.dispose();
        }
    }

    public void setArbitraryViewPointLocation(Vector3f newLocation) {
        if (this.customCamera != null) {
            this.customCamera.setCurrentLocation(newLocation);
        }
    }

    public Vector3f getArbitraryViewPointLocation() {
        if (this.customCamera != null) {
            return this.customCamera.getCurrentLocation();
        }
        return new Vector3f();
    }

    public void setArbitraryViewPointRotation(Quaternion newRotation) {
        if (this.customCamera != null) {
            this.customCamera.setCurrentOrientation(newRotation);
        }
    }

    public Quaternion getArbitraryViewPointRotation() {
        if (this.customCamera != null) {
            return this.customCamera.getCurrentOrientation();
        }
        return new Quaternion();
    }

    public void attachViewPoint(final AbstractViewPoint viewPoint) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (JME3Application.this.customCamera != null && viewPoint != null) {
                        JME3Application.this.customCamera.attachViewPoint(viewPoint);
                        if (viewPoint instanceof AttachedViewPoint) {
                            AttachedViewPoint attachedViewPoint = (AttachedViewPoint)viewPoint;
                            JME3Application.this.customCamera.setTranslationEnabled(attachedViewPoint.isAllowTranslation());
                            JME3Application.this.customCamera.setRotationEnabled(attachedViewPoint.isAllowRotation());
                        } else {
                            JME3Application.this.customCamera.setTranslationEnabled(true);
                            JME3Application.this.customCamera.setRotationEnabled(true);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
    }

    public void setTranslationEnabled(boolean translationEnabled) {
        if (this.customCamera != null) {
            this.customCamera.setTranslationEnabled(translationEnabled);
        }
    }

    public void setRotationEnabled(boolean rotationEnabled) {
        if (this.customCamera != null) {
            this.customCamera.setRotationEnabled(rotationEnabled);
        }
    }

    public Node getSceneRoot() {
        if (this.sceneRoot == null) {
            this.sceneRoot = new Node("Scene Root");
            this.rootNode.attachChild((Spatial)this.sceneRoot);
        }
        return this.sceneRoot;
    }

    public AppSettings getAppSettings() {
        return this.settings;
    }

    protected void initLighting() {
        this.skyLight.setDirection(JME3Utilities.convertToVector3f(Activator.getDefault().getAmbientLightDirection().asTuple3d()));
        RGB rgb = Activator.getDefault().getAmbientLightColor();
        if (rgb != null) {
            this.skyLight.setColor(new ColorRGBA((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f, 1.0f));
        } else {
            this.skyLight.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        }
        if (this.ambientLightEnabled) {
            this.rootNode.addLight((Light)this.skyLight);
        }
    }

    private boolean lightIsAttached(Light light) {
        boolean isAttached = false;
        Iterator it = this.rootNode.getWorldLightList().iterator();
        while (it.hasNext() && !isAttached) {
            if (it.next() != light) continue;
            isAttached = true;
        }
        return isAttached;
    }

    private void waitForCanvasInitialization() {
        long delay = 5000L;
        String delayString = System.getenv(JME3_CANVAS_INIT_DELAY_ENV_VAR);
        if (delayString != null) {
            try {
                delay = Math.round(Math.abs(Double.parseDouble(delayString) * 1000.0));
            }
            catch (Exception e) {
                Logger.error("Invalid value of <" + delayString + "> found for " + JME3_CANVAS_INIT_DELAY_ENV_VAR + ", using default value of <" + 5000L + "> ms.");
            }
        }
        try {
            Logger.info("Waiting for <" + delay + "> ms for JMECanvas to initialize.");
            Thread.sleep(delay);
            Logger.info("Waiting for <" + delay + "> ms for JMECanvas to initialize completed.");
        }
        catch (InterruptedException e) {
            Logger.error("Unable to sleep.", (Throwable)e);
        }
    }

    private void createSceneGraph() {
        this.sceneCentreTransform = new Node("Scene Centre Transform");
        this.getSceneRoot().attachChild((Spatial)this.sceneCentreTransform);
    }

    private CustomScreenshotAppState getCustomScreenshotAppState() {
        if (this.customScreenshotAppState == null) {
            this.customScreenshotAppState = new CustomScreenshotAppState();
            this.stateManager.attach((AppState)this.customScreenshotAppState);
        }
        return this.customScreenshotAppState;
    }

    private void enableMouseNavigation(boolean mouseNavigationEnabled) {
        LwjglCanvas canvas = (LwjglCanvas)this.getContext();
        if (canvas != null) {
            canvas.getCanvas().setFocusable(mouseNavigationEnabled);
        }
    }

    private MousePickListener getMousePickListener() {
        if (this.mousePickListener == null) {
            this.mousePickListener = new MousePickListener(this.getCamera(), this, this.getInputManager()){

                @Override
                protected void pickingEnabled(boolean enable) {
                    if (JME3Application.this.customCamera != null) {
                        JME3Application.this.customCamera.setEnabled(!enable);
                    }
                }

                @Override
                protected void fireSelectionChanged(SelectionChangedEvent event) {
                    JME3Application.this.jme3RenderEngineDelegate.getTopologyViewer().setSelection(event.getSelection());
                }
            };
        }
        return this.mousePickListener;
    }

    private MouseClickListener getMouseClickListener() {
        if (this.mouseClickListener == null) {
            this.mouseClickListener = new MouseClickListener(this.getCamera(), this, this.getInputManager()){

                @Override
                protected void mouseClicked(int mouseButton) {
                    MouseButton button = null;
                    switch (mouseButton) {
                        case 0: {
                            button = MouseButton.LEFT;
                            break;
                        }
                        case 2: {
                            button = MouseButton.MIDDLE;
                            break;
                        }
                        case 1: {
                            button = MouseButton.RIGHT;
                            break;
                        }
                    }
                    if (button != null) {
                        JME3Application.this.jme3RenderEngineDelegate.getTopologyViewer().mouseClicked(button);
                    }
                }
            };
            this.mouseClickListener.setEnabled(true);
        }
        return this.mouseClickListener;
    }
}

