/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ui.ShadowMode;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;

public class JME3Utilities {
    private static OS os = OS.UNINITIALIZED;

    public static ColorRGBA convertToColorRGBA(RGB rgb) {
        if (rgb != null) {
            return new ColorRGBA((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f, 1.0f);
        }
        return new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    }

    public static ColorRGBA convertToColorRGBA(RGBA rgba) {
        if (rgba != null) {
            return new ColorRGBA((float)rgba.rgb.red / 255.0f, (float)rgba.rgb.green / 255.0f, (float)rgba.rgb.blue / 255.0f, (float)rgba.alpha / 255.0f);
        }
        return new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    }

    public static RGB convertToColorRGB(ColorRGBA colorRGBA) {
        int red = Math.round(colorRGBA.r * 255.0f);
        int green = Math.round(colorRGBA.g * 255.0f);
        int blue = Math.round(colorRGBA.b * 255.0f);
        return new RGB(red, green, blue);
    }

    public static ColorRGBA convertToColorRGBA(Color3f color3f) {
        return new ColorRGBA(color3f.x, color3f.y, color3f.z, 1.0f);
    }

    public static Color convertToAWTColor(ColorRGBA colorRGBA) {
        return new Color(colorRGBA.getRed(), colorRGBA.getGreen(), colorRGBA.getBlue(), colorRGBA.getAlpha());
    }

    public static int[] convertToColorIntRGBA(ColorRGBA colorRGBA) {
        int red = (int)Math.floor((double)colorRGBA.getRed() * 255.0);
        int green = (int)Math.floor((double)colorRGBA.getGreen() * 255.0);
        int blue = (int)Math.floor((double)colorRGBA.getBlue() * 255.0);
        int alpha = (int)Math.floor((double)colorRGBA.getAlpha() * 255.0);
        return new int[]{red, green, blue, alpha};
    }

    public static Geometry createAxis3D(float axisLength, AssetManager assetManager) {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(axisLength, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, axisLength, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, axisLength)};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] indexes = nArray;
        float[] colorArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.Lines);
        m.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        m.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])indexes));
        m.setBuffer(VertexBuffer.Type.Color, 4, colorArray);
        m.updateBound();
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setBoolean("VertexColor", true);
        Geometry geometry = new Geometry("Axis3D", m);
        geometry.setMaterial(mat);
        return geometry;
    }

    public static List<Geometry> getAllChildrenGeometry(Node node) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Spatial child : node.getChildren()) {
            if (child instanceof Geometry) {
                Geometry geometry = (Geometry)child;
                geometries.add(geometry);
                continue;
            }
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            geometries.addAll(JME3Utilities.getAllChildrenGeometry(childNode));
        }
        return geometries;
    }

    public static Matrix3f convertToJME3Matrix3f(Matrix3d matrix3d) {
        return new Matrix3f((float)matrix3d.m00, (float)matrix3d.m01, (float)matrix3d.m02, (float)matrix3d.m10, (float)matrix3d.m11, (float)matrix3d.m12, (float)matrix3d.m20, (float)matrix3d.m21, (float)matrix3d.m22);
    }

    public static Quaternion createQuaternion(Matrix3d matrix3d) {
        Matrix3f m = JME3Utilities.convertToJME3Matrix3f(matrix3d);
        Quaternion quaternion = new Quaternion();
        quaternion.fromRotationMatrix(m);
        return quaternion;
    }

    public static Transform createTransform(Matrix4d matrix4d) {
        Vector3d position = new Vector3d();
        matrix4d.get(position);
        Vector3f translation = new Vector3f((float)position.x, (float)position.y, (float)position.z);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setIdentity();
        matrix4d.get(matrix3d);
        Quaternion rotation = JME3Utilities.createQuaternion(matrix3d);
        return new Transform(translation, rotation);
    }

    public static Vector3f computeTriangleNormal(Vector3f p0, Vector3f p1, Vector3f p2) {
        Vector3f v1 = new Vector3f(p1);
        v1 = v1.subtract(p0);
        Vector3f v2 = new Vector3f(p2);
        v2 = v2.subtract(p1);
        Vector3f normal = v1.cross(v2);
        normal.normalize();
        return normal;
    }

    public static float[] convertToFloatArray(Vector2f[][] input) {
        int rows = input.length;
        int columns = input[0].length;
        float[] array = new float[rows * columns * 2];
        int i = 0;
        int x = 0;
        while (x < rows) {
            int y = 0;
            while (y < columns) {
                Vector2f v = input[x][y];
                array[2 * i] = v.x;
                array[2 * i + 1] = v.y;
                ++i;
                ++y;
            }
            ++x;
        }
        return array;
    }

    public static float[] convertListOfVector2fToFloatArray(List<Vector2f> list) {
        float[] array = new float[list.size() * 2];
        int i = 0;
        for (Vector2f v : list) {
            array[2 * i] = v.x;
            array[2 * i + 1] = v.y;
            ++i;
        }
        return array;
    }

    public static float[] convertToFloatArray(List<Vector3f> list) {
        float[] array = new float[list.size() * 3];
        int i = 0;
        for (Vector3f v : list) {
            array[3 * i] = v.x;
            array[3 * i + 1] = v.y;
            array[3 * i + 2] = v.z;
            ++i;
        }
        return array;
    }

    public static float[] convertVector2fListToFloatArray(List<Vector2f> list) {
        float[] array = new float[list.size() * 2];
        int i = 0;
        for (Vector2f v : list) {
            array[2 * i] = v.x;
            array[2 * i + 1] = v.y;
            ++i;
        }
        return array;
    }

    public static int[] convertToIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer value : list) {
            array[i] = value;
            ++i;
        }
        return array;
    }

    public static float[] convertRGBAListToFloatArray(List<ColorRGBA> list) {
        float[] array = new float[list.size() * 4];
        int i = 0;
        for (ColorRGBA color : list) {
            int indexBase = 4 * i;
            array[indexBase] = color.r;
            array[indexBase + 1] = color.g;
            array[indexBase + 2] = color.b;
            array[indexBase + 3] = color.a;
            ++i;
        }
        return array;
    }

    public static Vector3f convertToVector3f(Tuple3d tuple3d) {
        return new Vector3f((float)tuple3d.x, (float)tuple3d.y, (float)tuple3d.z);
    }

    public static javax.vecmath.Vector3f convertToJavaxVector3f(Vector3f vector3f) {
        return new javax.vecmath.Vector3f(vector3f.x, vector3f.y, vector3f.z);
    }

    public static Texture2D createTexture2D(BufferedImage bufferedImage, AssetManager assetManager) {
        AWTLoader awtLoader = new AWTLoader();
        Image img = awtLoader.load(bufferedImage, true);
        Texture2D texture = new Texture2D(img);
        return texture;
    }

    public static Material createMaterial(BufferedImage bufferedImage, AssetManager assetManager) {
        Texture2D texture = JME3Utilities.createTexture2D(bufferedImage, assetManager);
        Material material = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setTexture("ColorMap", (Texture)texture);
        return material;
    }

    public static RenderQueue.ShadowMode convertToJMEShadowMode(ShadowMode shadowMode) {
        RenderQueue.ShadowMode mode = RenderQueue.ShadowMode.Inherit;
        switch (shadowMode.getValue()) {
            case 1: {
                mode = RenderQueue.ShadowMode.Off;
                break;
            }
            case 0: {
                mode = RenderQueue.ShadowMode.Inherit;
                break;
            }
            case 2: {
                mode = RenderQueue.ShadowMode.Cast;
                break;
            }
            case 3: {
                mode = RenderQueue.ShadowMode.Receive;
                break;
            }
            case 4: {
                mode = RenderQueue.ShadowMode.CastAndReceive;
                break;
            }
        }
        return mode;
    }

    public static String sceneTopologyAsHTML(Spatial root) {
        return JME3Utilities.expandSpatialAsHTML(root);
    }

    public static OS getOS() {
        if (os == OS.UNINITIALIZED) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                os = OS.WINDOWS;
            } else if (osName.startsWith("Linux")) {
                os = OS.LINUX;
            } else if (osName.startsWith("Mac")) {
                os = OS.MACOS;
            }
        }
        return os;
    }

    private static String expandSpatialAsHTML(Spatial spatial) {
        String s = new String("<!DOCTYPE html>\n");
        s = String.valueOf(s) + "\t<html>\n";
        s = String.valueOf(s) + "\t\t<head>\n";
        s = String.valueOf(s) + "\t\t\t<script type='text/javascript' src='https://www.google.com/jsapi'></script>\n";
        s = String.valueOf(s) + "\t\t\t<script type='text/javascript'>\n";
        s = String.valueOf(s) + "\t\t\t google.load('visualization', '1', {packages:['orgchart']});\n";
        s = String.valueOf(s) + "\t\t\t google.setOnLoadCallback(drawChart);\n";
        s = String.valueOf(s) + "\t\t\t function drawChart() {\n";
        s = String.valueOf(s) + "\t\t\t\t var data = new google.visualization.DataTable();\n";
        s = String.valueOf(s) + "\t\t\t\t data.addColumn('string', 'Node');\n";
        s = String.valueOf(s) + "\t\t\t\t data.addColumn('string', 'Parent')\n;";
        s = String.valueOf(s) + "\t\t\t\t data.addRows([";
        HashMap<Spatial, String> spatialToNameMap = new HashMap<Spatial, String>();
        ArrayList<String[]> nodeParentList = new ArrayList<String[]>();
        JME3Utilities.expandSpatialAsHTMLRecursive(spatialToNameMap, nodeParentList, spatial);
        Iterator it = nodeParentList.iterator();
        while (it.hasNext()) {
            String[] parentNode = (String[])it.next();
            s = String.valueOf(s) + "\t\t\t\t\t['" + parentNode[0] + "' , '" + parentNode[1] + "']";
            s = it.hasNext() ? String.valueOf(s) + ",\n" : String.valueOf(s) + "\n";
        }
        s = String.valueOf(s) + "\t\t\t\t ]);\n";
        s = String.valueOf(s) + "\t\t\t\t var chart = new google.visualization.OrgChart(document.getElementById('chart_div'));\n";
        s = String.valueOf(s) + "\t\t\t\t chart.draw(data);\n";
        s = String.valueOf(s) + "\t\t\t}\n";
        s = String.valueOf(s) + "\t\t\t</script>\n";
        s = String.valueOf(s) + "\t\t</head>\n";
        s = String.valueOf(s) + "\t<body>\n";
        s = String.valueOf(s) + "\t\t<div id='chart_div'></div>\n";
        s = String.valueOf(s) + "\t</body>\n";
        s = String.valueOf(s) + "</html>\n";
        return s;
    }

    private static void expandSpatialAsHTMLRecursive(Map<Spatial, String> spatialToNameMap, List<String[]> nodeParentList, Spatial spatial) {
        String nodeName = JME3Utilities.getNameForSpatial(spatial);
        spatialToNameMap.put(spatial, nodeName);
        String parentName = spatialToNameMap.get(spatial.getParent());
        if (parentName == null) {
            parentName = "";
        }
        String[] nodeParent = new String[]{nodeName, parentName};
        nodeParentList.add(nodeParent);
        if (spatial instanceof Node) {
            Node parent = (Node)spatial;
            for (Spatial child : parent.getChildren()) {
                JME3Utilities.expandSpatialAsHTMLRecursive(spatialToNameMap, nodeParentList, child);
            }
        }
    }

    private static String getNameForSpatial(Spatial spatial) {
        String s = new String();
        s = spatial.getName() != null ? String.valueOf(s) + spatial.getName().replaceAll(" ", "_") + "(" + Integer.toString(spatial.hashCode()) + ")" : String.valueOf(s) + Integer.toString(spatial.hashCode());
        return s;
    }

    public static enum OS {
        UNINITIALIZED,
        LINUX,
        WINDOWS,
        MACOS;

    }
}

