/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.scene.Spatial;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjToJ3oConverter
extends SimpleApplication
implements IApplication {
    private static final Logger Logger = LoggerFactory.getLogger(ObjToJ3oConverter.class);

    public Object start(IApplicationContext context) throws Exception {
        final String[] argArray = (String[])context.getArguments().get("application.args");
        this.start();
        final ObjToJ3oConverter simpleApplication = this;
        Future future = this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ObjToJ3oConverter.this.getAssetManager().registerLocator("/", FileLocator.class);
                String[] stringArray = argArray;
                int n = argArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    System.out.println("Exporting <" + s + ">.");
                    ObjToJ3oConverter.this.export((Application)simpleApplication, s);
                    ++n2;
                }
                return new String("Done !");
            }
        });
        System.out.println(future.get());
        return IApplication.EXIT_OK;
    }

    public void stop() {
        this.stop(true);
    }

    private void export(Application application, String path) {
        try {
            Spatial loadedModel = application.getAssetManager().loadModel(path);
            String exportFileName = String.valueOf(this.stipFileExtension(path)) + ".j3o";
            BinaryExporter exporter = BinaryExporter.getInstance();
            File file = new File(exportFileName);
            exporter.save((Savable)loadedModel, file);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private String stipFileExtension(String path) {
        int index = path.lastIndexOf(".");
        return path.substring(0, index);
    }

    public void simpleInitApp() {
    }
}

