/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.internal;

import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSceneGraphHTMLActionListener
implements ActionListener {
    private static final Logger Logger = LoggerFactory.getLogger(CreateSceneGraphHTMLActionListener.class);
    public static final String F1_KEY = "F1_KEY";
    private final String[] inputs = new String[]{"F1_KEY"};
    private boolean enabled = true;
    private boolean busy = false;
    private boolean inputsRegistered = false;
    private final InputManager inputManager;
    private final JME3Application viewer;

    public CreateSceneGraphHTMLActionListener(InputManager inputManager, JME3Application viewer) {
        this.inputManager = inputManager;
        this.viewer = viewer;
        this.registerWithInput(inputManager);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            if (this.inputsRegistered && this.inputManager != null) {
                this.unregisterInput(this.inputManager);
            }
        } else if (!this.inputsRegistered && this.inputManager != null) {
            this.registerWithInput(this.inputManager);
        }
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (this.isEnabled() && !this.busy && name.equals(F1_KEY) && keyPressed) {
            this.busy = true;
            this.printNode(this.viewer.getRootNode());
            this.busy = false;
        }
    }

    private void registerWithInput(InputManager inputManager) {
        inputManager.addMapping(F1_KEY, new Trigger[]{new KeyTrigger(59)});
        inputManager.addListener((InputListener)this, this.inputs);
        this.inputsRegistered = true;
    }

    private void unregisterInput(InputManager inputManager) {
        int i = 0;
        while (i < this.inputs.length) {
            inputManager.deleteMapping(this.inputs[i]);
            ++i;
        }
        inputManager.removeListener((InputListener)this);
        this.inputsRegistered = false;
    }

    private void printNode(Node node) {
        try {
            final String fileName = String.valueOf(System.getProperty("user.dir")) + File.separator + "scene_graph.html";
            Logger.info("Printing Scene Graph to file <" + fileName + ">.");
            String html = JME3Utilities.sceneTopologyAsHTML((Spatial)node);
            final File f = new File(fileName);
            FileWriter fw = new FileWriter(f);
            fw.write(html);
            fw.flush();
            fw.close();
            Logger.info("Printing Scene Graph to file <" + fileName + "> completed.");
            Job job = new Job("Opening JME3Viewer Scenegraph file..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Logger.info("Opening <" + fileName + "> with web browser.");
                        Desktop.getDesktop().open(f);
                        Logger.info("Opening <" + fileName + "> with web browser completed.");
                        return Status.OK_STATUS;
                    }
                    catch (Throwable t) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            job.schedule(3000L);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }
}

