/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.topology.AbstractNodeVisitor;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodePresentationAdapter;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.apogy.common.topology.ui.impl.TopologyPresentationRegistryImpl;
import org.eclipse.apogy.common.topology.ui.internal.MultiNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyPresentationRegistryCustomImpl
extends TopologyPresentationRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyPresentationRegistryImpl.class);
    private MultiNodeListener multiNodeListener = null;
    private final Map<Node, NodePresentation> nodeToNodePresentationMap = new HashMap<Node, NodePresentation>(100);

    @Override
    public TopologyPresentationSet createTopologyPresentationSet(Node topologyRoot) {
        final TopologyPresentationSet topologyPresentationSet = ApogyCommonTopologyUIFactory.eINSTANCE.createTopologyPresentationSet();
        AbstractNodeVisitor visitor = new AbstractNodeVisitor(){

            public void visit(Node node) {
                NodePresentation nodePresentation = TopologyPresentationRegistryCustomImpl.this.getPresentationNode(node);
                if (nodePresentation == null && (nodePresentation = TopologyPresentationRegistryCustomImpl.this.createNodePresentation(node)) != null) {
                    TopologyPresentationRegistryCustomImpl.this.addNodePresentation(nodePresentation);
                }
                if (nodePresentation != null) {
                    topologyPresentationSet.getNodePresentationList().add((Object)nodePresentation);
                    nodePresentation.getTopologyPresentationSet().add((Object)topologyPresentationSet);
                }
            }
        };
        topologyRoot.accept((INodeVisitor)visitor);
        this.getTopologyPresentationSetList().add((Object)topologyPresentationSet);
        return topologyPresentationSet;
    }

    @Override
    public void release(TopologyPresentationSet topologyPresentationSet) {
        if (topologyPresentationSet != null) {
            for (Node node : topologyPresentationSet.getNodes()) {
                NodePresentation nodePresentation = this.getPresentationNode(node);
                if (nodePresentation == null) continue;
                nodePresentation.getTopologyPresentationSet().remove((Object)topologyPresentationSet);
                if (!nodePresentation.getTopologyPresentationSet().isEmpty()) continue;
                this.removeNodePresentation(nodePresentation);
            }
            topologyPresentationSet.getNodePresentationList().clear();
            topologyPresentationSet.setTopologyPresentationRegistry(null);
        }
    }

    @Override
    public NodePresentation getPresentationNode(Node node) {
        return this.nodeToNodePresentationMap.get(node);
    }

    private NodePresentation createNodePresentation(Node node) {
        Logger.debug("TopologyPresentationRegistryImpl.createNodePresentation(" + node + ")");
        NodePresentation nodePresentation = null;
        NodePresentationAdapter adapter = Activator.getDefault().getNodePresentationAdapterFactory().getAdapterFor(node);
        if (adapter != null) {
            nodePresentation = (NodePresentation)adapter.getAdapter(node, null);
        }
        return nodePresentation;
    }

    private synchronized void addNodePresentation(NodePresentation nodePresentation) {
        this.getNodePresentationList().add((Object)nodePresentation);
        this.nodeToNodePresentationMap.put(nodePresentation.getNode(), nodePresentation);
        this.getMultiNodeListener().registerNode(nodePresentation.getNode());
        if (nodePresentation.getNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)nodePresentation.getNode().getParent();
            List<TopologyPresentationSet> affectedTopologyPresentationSet = this.getAffectedTopologyPresentationSet((Node)parent);
            for (TopologyPresentationSet topologyPresentationSet : affectedTopologyPresentationSet) {
                try {
                    topologyPresentationSet.getNodePresentationList().add((Object)nodePresentation);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    private synchronized void removeNodePresentation(NodePresentation nodePresentation) {
        this.getMultiNodeListener().unregisterNode(nodePresentation.getNode());
        ArrayList<TopologyPresentationSet> affectedTopologyPresentationSet = new ArrayList<TopologyPresentationSet>((Collection<TopologyPresentationSet>)nodePresentation.getTopologyPresentationSet());
        for (TopologyPresentationSet topologyPresentationSet : affectedTopologyPresentationSet) {
            try {
                topologyPresentationSet.getNodePresentationList().remove((Object)nodePresentation);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        this.nodeToNodePresentationMap.remove(nodePresentation.getNode());
        this.getNodePresentationList().remove((Object)nodePresentation);
    }

    private synchronized void addNodeAndChildrens(Node topologyRoot) {
        Logger.debug("TopologyPresentationRegistryImpl.addNodeAndChildrens(" + topologyRoot + ")");
        AbstractNodeVisitor visitor = new AbstractNodeVisitor(){

            public void visit(Node node) {
                Logger.debug("/t CHILD " + node);
                NodePresentation nodePresentation = TopologyPresentationRegistryCustomImpl.this.getPresentationNode(node);
                if (nodePresentation == null) {
                    nodePresentation = TopologyPresentationRegistryCustomImpl.this.createNodePresentation(node);
                    if (nodePresentation != null) {
                        TopologyPresentationRegistryCustomImpl.this.addNodePresentation(nodePresentation);
                    } else {
                        Logger.warn("No NodePresentation found for node <" + node + ">.");
                    }
                }
            }
        };
        topologyRoot.accept((INodeVisitor)visitor);
    }

    private synchronized void removeNodeAndChildrens(Node topologyRoot) {
        AbstractNodeVisitor visitor = new AbstractNodeVisitor(){

            public void visit(Node node) {
                NodePresentation nodePresentation = TopologyPresentationRegistryCustomImpl.this.getPresentationNode(node);
                if (nodePresentation != null) {
                    TopologyPresentationRegistryCustomImpl.this.removeNodePresentation(nodePresentation);
                }
            }
        };
        topologyRoot.accept((INodeVisitor)visitor);
    }

    private MultiNodeListener getMultiNodeListener() {
        if (this.multiNodeListener == null) {
            this.multiNodeListener = new MultiNodeListener(){

                @Override
                protected void nodeAdded(GroupNode parent, Node nodeAdded) {
                    TopologyPresentationRegistryCustomImpl.this.addNodeAndChildrens(nodeAdded);
                }

                @Override
                protected void nodesAdded(GroupNode parent, List<Node> nodesAdded) {
                    for (Node node : nodesAdded) {
                        TopologyPresentationRegistryCustomImpl.this.addNodeAndChildrens(node);
                    }
                }

                @Override
                protected void nodeRemoved(GroupNode parent, Node nodeRemoved) {
                    TopologyPresentationRegistryCustomImpl.this.removeNodeAndChildrens(nodeRemoved);
                }

                @Override
                protected void nodesRemoved(GroupNode parent, List<Node> nodesRemoved) {
                    for (Node node : nodesRemoved) {
                        TopologyPresentationRegistryCustomImpl.this.removeNodeAndChildrens(node);
                    }
                }
            };
        }
        return this.multiNodeListener;
    }

    private List<TopologyPresentationSet> getAffectedTopologyPresentationSet(Node node) {
        ArrayList<TopologyPresentationSet> topologyPresentationSetList = new ArrayList<TopologyPresentationSet>();
        NodePresentation nodePresentation = this.getPresentationNode(node);
        if (nodePresentation != null) {
            topologyPresentationSetList.addAll((Collection<TopologyPresentationSet>)nodePresentation.getTopologyPresentationSet());
        }
        return topologyPresentationSetList;
    }
}

