/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lidar.impl;

import java.util.ArrayList;
import java.util.Random;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.eclipse.apogy.examples.lidar.impl.LidarSimulatedImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LidarSimulatedCustomImpl
extends LidarSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(LidarSimulatedImpl.class);
    private static final String DEGREE_SYM = "\u00b0";
    protected static final double FOV_DEF_HORIZONTAL_SPAN = Math.toRadians(90.0);
    protected static final double FOV_DEF_VERTICAL_SPAN = Math.toRadians(45.0);
    protected static final double FOV_DEF_MINIMUM_RANGE = 0.5;
    protected static final double FOV_DEF_MAXIMUM_RANGE = 50.0;
    protected static final long SCAN_DELAY_BLOCKING = 0L;
    protected static final long SCAN_DELAY_NON_BLOCKING = 200L;
    protected Random rangeRandom;

    @Override
    public RectangularFrustrumFieldOfView getFov() {
        RectangularFrustrumFieldOfView tmp = super.getFov();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(0.5, 50.0, FOV_DEF_HORIZONTAL_SPAN, FOV_DEF_VERTICAL_SPAN);
            this.setFov(tmp);
        }
        return tmp;
    }

    @Override
    public boolean init() {
        if (this.isInitialized()) {
            Logger.warn("Ignored: The lidar has already been successfully called.");
            return true;
        }
        this.rangeRandom = new Random();
        Logger.info("The Lidar unit has been initialized.");
        this.setInitialized(true);
        return true;
    }

    public CartesianCoordinatesSet acquireScanOLD(double horizontalResolution, double verticalResolution) {
        if (!this.isInitialized()) {
            throw new RuntimeException("Rejected: The Lidar unit is not initialized.");
        }
        CartesianCoordinatesSet cartesianCoordinatesSet = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        Logger.info("Starting the Lidar unit's (blocking) scan acquistion.");
        this.fillScan(horizontalResolution, verticalResolution, cartesianCoordinatesSet, 0L);
        Logger.info("Lidar unit's blocking scan completed.");
        return cartesianCoordinatesSet;
    }

    @Override
    public CartesianCoordinatesSet acquireScan(double horizontalResolution, double verticalResolution) {
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        ColoredCartesianPositionCoordinates p0 = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(-1.0, -1.0, 0.0, (short)255, (short)0, (short)0);
        ColoredCartesianPositionCoordinates p1 = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(1.0, -1.0, 0.0, (short)255, (short)0, (short)0);
        ColoredCartesianPositionCoordinates p2 = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(1.0, 1.0, 0.0, (short)0, (short)0, (short)255);
        CartesianPositionCoordinates p3 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(-1.0, 1.0, 0.0);
        mesh.getPoints().add((Object)p0);
        mesh.getPoints().add((Object)p1);
        mesh.getPoints().add((Object)p2);
        mesh.getPoints().add((Object)p3);
        CartesianTriangle t0 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle((CartesianPositionCoordinates)p0, (CartesianPositionCoordinates)p1, (CartesianPositionCoordinates)p2);
        CartesianTriangle t1 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle((CartesianPositionCoordinates)p2, p3, (CartesianPositionCoordinates)p0);
        mesh.getPolygons().add((Object)t0);
        mesh.getPolygons().add((Object)t1);
        return mesh;
    }

    @Override
    public CartesianCoordinatesSet acquireScanNonBlocking(final double horizontalResolution, final double verticalResolution) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + "acquireScanNonBlocking(" + Math.toDegrees(horizontalResolution) + DEGREE_SYM + ", " + Math.toDegrees(verticalResolution) + DEGREE_SYM + "): ";
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the Lidar unit is not initialized (with init())";
            throw new RuntimeException(message);
        }
        final CartesianCoordinatesSet cartesianCoordinatesSet = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        Job job = new Job(LOG_PREFIX.substring(0, LOG_PREFIX.length() - 2)){

            protected IStatus run(IProgressMonitor monitor) {
                Logger.info("Starting the Lidar unit's non-blocking scan acquistion.");
                LidarSimulatedCustomImpl.this.fillScan(horizontalResolution, verticalResolution, cartesianCoordinatesSet, 200L);
                Logger.info("Lidar unit's non-blocking scan completed.");
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return cartesianCoordinatesSet;
    }

    private void fillScan(double horizontalResolutionAngle, double verticalResolutionAngle, CartesianCoordinatesSet cartesianCoordinatesSet, long scanLineDelay) {
        long horizontalNumberPoints = Math.round(this.getFov().getHorizontalFieldOfViewAngle() / horizontalResolutionAngle);
        long verticalNumberPoints = Math.round(this.getFov().getVerticalFieldOfViewAngle() / verticalResolutionAngle);
        double azimuthAngle = -(this.getFov().getHorizontalFieldOfViewAngle() * 0.5);
        int h = 0;
        while ((long)h < horizontalNumberPoints) {
            double elevationAngle = -(this.getFov().getVerticalFieldOfViewAngle() * 0.5);
            ArrayList<Object> scanLine = new ArrayList<Object>();
            int v = 0;
            while ((long)v < verticalNumberPoints) {
                double range = this.generateRandomRange();
                double x = range * Math.sin(elevationAngle);
                double y = range * Math.cos(elevationAngle) * Math.sin(azimuthAngle);
                double z = range * Math.cos(elevationAngle) * Math.cos(azimuthAngle);
                if (Math.IEEEremainder(v, 2.0) > 0.0) {
                    double ratio = Math.sqrt(x * x + y * y + z * z) / this.getFov().getRange().getMaximumDistance();
                    short color = (short)(ratio * 255.0);
                    if (color > 255) {
                        color = 255;
                    }
                    ColoredCartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(x, y, z, (short)0, (short)0, color);
                    scanLine.add(point);
                } else {
                    CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                    scanLine.add(point);
                }
                elevationAngle += verticalResolutionAngle;
                ++v;
            }
            cartesianCoordinatesSet.getPoints().addAll(scanLine);
            try {
                Thread.sleep(scanLineDelay);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            azimuthAngle += horizontalResolutionAngle;
            ++h;
        }
    }

    private double generateRandomRange() {
        double range = this.getFov().getRange().getMinimumDistance() + this.rangeRandom.nextDouble() * this.getFov().getRange().getDistance();
        return range;
    }
}

