/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPerspectiveDialog
extends Dialog {
    private static final Logger Logger = LoggerFactory.getLogger(AddPerspectiveDialog.class);
    TableViewer viewer;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    private final MApplication application;
    private final IResourceUtilities<?> resourceUtilities;

    @Inject
    public AddPerspectiveDialog(@Named(value="activeShell") Shell parentShell, MApplication application) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.application = application;
        this.resourceUtilities = (IResourceUtilities)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IResourceUtilities.class);
    }

    protected void configureShell(Shell shell) {
        shell.setText("Add Perspective");
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(composite, 2820);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddPerspectiveDialog.this.okPressed();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new perspectivesLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new perspectivesContentProvider());
        this.viewer.setInput((Object)this.application);
        return composite;
    }

    protected void okPressed() {
        if (this.viewer.getStructuredSelection() != null && this.viewer.getStructuredSelection().getFirstElement() instanceof MPerspective) {
            MPerspective perspective = (MPerspective)this.viewer.getStructuredSelection().getFirstElement();
            HashMap<String, String> parameters = new HashMap<String, String>(1);
            parameters.put("org.eclipse.apogy.rcp.commandparameter.addPerspective.perspectiveID", perspective.getElementId());
            ParameterizedCommand command = this.commandService.createCommand("org.eclipse.apogy.rcp.command.addPerspective", parameters);
            this.handlerService.executeHandler(command);
        }
        super.okPressed();
    }

    private class perspectivesContentProvider
    implements IStructuredContentProvider {
        private perspectivesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<MPerspective> perspectives = new ArrayList<MPerspective>();
            for (MUIElement element : AddPerspectiveDialog.this.application.getSnippets()) {
                if (!(element instanceof MPerspective) || !element.getPersistedState().containsKey("Standalone") || !Boolean.parseBoolean((String)element.getPersistedState().get("Standalone"))) continue;
                perspectives.add((MPerspective)element);
            }
            List<MPerspective> sorted = this.sortMPerspectiveAlphabetically(perspectives);
            return sorted.toArray();
        }

        private List<MPerspective> sortMPerspectiveAlphabetically(List<MPerspective> mUIElements) {
            TreeSet<MPerspective> sorted = new TreeSet<MPerspective>(new Comparator<MPerspective>(){

                @Override
                public int compare(MPerspective arg0, MPerspective arg1) {
                    if (arg0.getLabel() != null && arg1.getLabel() != null) {
                        if (arg0.getLabel().compareTo(arg1.getLabel()) > 0) {
                            return 1;
                        }
                        if (arg0.getLabel().compareTo(arg1.getLabel()) < 0) {
                            return -1;
                        }
                        if (arg0.hashCode() > arg1.hashCode()) {
                            return 1;
                        }
                        return -1;
                    }
                    if (arg0.hashCode() > arg1.hashCode()) {
                        return 1;
                    }
                    return -1;
                }
            });
            sorted.addAll(mUIElements);
            ArrayList<MPerspective> result = new ArrayList<MPerspective>();
            result.addAll(sorted);
            return result;
        }
    }

    private class perspectivesLabelProvider
    extends ColumnLabelProvider {
        private perspectivesLabelProvider() {
        }

        public String getText(Object element) {
            return ((MPerspective)element).getLabel();
        }

        public Image getImage(Object element) {
            ImageDescriptor descriptor = null;
            try {
                String str_uri = ((MPerspective)element).getIconURI();
                if (str_uri != null) {
                    URI uri = URI.createURI((String)str_uri);
                    descriptor = (ImageDescriptor)AddPerspectiveDialog.this.resourceUtilities.imageDescriptorFromURI(uri);
                    if (descriptor != null) {
                        return descriptor.createImage();
                    }
                    return null;
                }
            }
            catch (RuntimeException e) {
                Logger.error("Unable to display the icon", (Throwable)e);
            }
            return null;
        }
    }
}

