/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.toolcontrols;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.rcp.dialogs.ModifyPerspectiveShortcutDialog;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.E4Util;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.EPerspectiveSwitcher;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.IPerspectiveSwitcherControl;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.PerspectiveSwitcherSwtTrim;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveSwitcherToolControl
implements IPerspectiveSwitcherControl {
    private static final Logger Logger = LoggerFactory.getLogger(PerspectiveSwitcherToolControl.class);
    private final String DEFAULT_ICON_URI = "icons/full/eview16/new_persp.gif";
    private ToolBar toolBar;
    private Composite composite;
    @Inject
    private MApplication application;
    private MWindow window;
    @Inject
    private IResourceUtilities<?> resourceUtilities;
    @Inject
    private EPerspectiveSwitcher perspectiveSwitcher;
    @Inject
    private ECommandService commandService;
    @Inject
    private EModelService modelService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private Shell shell;

    @PostConstruct
    public void createControls(Composite parent) {
        this.window = (MWindow)this.modelService.find("org.eclipse.apogy.rcp.windows.main", (MUIElement)this.application);
        this.perspectiveSwitcher.setControlProvider((IPerspectiveSwitcherControl)this);
        this.composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = this.window.getWidth();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.justify = false;
        rowLayout.center = false;
        this.composite.setLayout((Layout)rowLayout);
        this.toolBar = new ToolBar(this.composite, 8519744);
        this.toolBar.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                ToolBar tb = (ToolBar)event.widget;
                Point p = new Point(event.x, event.y);
                p = PerspectiveSwitcherToolControl.this.toolBar.getDisplay().map(null, (Control)PerspectiveSwitcherToolControl.this.toolBar, p);
                final ToolItem item = tb.getItem(p);
                if (item != null && item.getData() != null) {
                    final MPerspective perspective = (MPerspective)item.getData();
                    final Menu menu = new Menu((Control)PerspectiveSwitcherToolControl.this.toolBar);
                    menu.setData((Object)perspective);
                    MPerspectiveStack stack = (MPerspectiveStack)PerspectiveSwitcherToolControl.this.modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)PerspectiveSwitcherToolControl.this.window);
                    if (stack.getSelectedElement() == perspective) {
                        MenuItem resetMenuItem = new MenuItem(menu, 26);
                        resetMenuItem.setText("Reset");
                        resetMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                page.resetPerspective();
                            }
                        });
                    }
                    MenuItem changeShortcutMenuItem = new MenuItem(menu, 26);
                    changeShortcutMenuItem.setText("Modify shortcut");
                    changeShortcutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ModifyPerspectiveShortcutDialog dialog = new ModifyPerspectiveShortcutDialog(PerspectiveSwitcherToolControl.this.shell, (MPerspective)item.getData(), PerspectiveSwitcherToolControl.this.resourceUtilities);
                            dialog.open();
                            PerspectiveSwitcherToolControl.this.toolBar.layout();
                            PerspectiveSwitcherToolControl.this.composite.layout();
                        }
                    });
                    new MenuItem(menu, 2);
                    MenuItem saveAsMenuItem = new MenuItem(menu, 26);
                    saveAsMenuItem.setText("Save as");
                    saveAsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            FileDialog dialog = new FileDialog(PerspectiveSwitcherToolControl.this.shell, 8192);
                            dialog.setFileName("perspective");
                            dialog.setFilterExtensions(new String[]{"*.e4xmi"});
                            String path = dialog.open();
                            if (path != null) {
                                try {
                                    File tmpFile = new File(path);
                                    URI uri = URI.createURI((String)tmpFile.toURI().toString());
                                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                                    Resource resource = resourceSet.createResource(uri);
                                    MPerspective clonedPerspective = (MPerspective)PerspectiveSwitcherToolControl.this.modelService.cloneElement((MUIElement)perspective, null);
                                    PerspectiveSwitcherToolControl.this.preparePerspective(clonedPerspective);
                                    resource.getContents().add((Object)((EObject)clonedPerspective));
                                    resource.save(Collections.EMPTY_MAP);
                                }
                                catch (IOException e) {
                                    Logger.error("Error in url file creation.", (Throwable)e);
                                }
                            }
                        }
                    });
                    MenuItem closeMenuItem = new MenuItem(menu, 26);
                    closeMenuItem.setText("Close");
                    closeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            PerspectiveSwitcherToolControl.this.closePerspective(perspective, item);
                        }
                    });
                    Rectangle bounds = item.getBounds();
                    Point point = PerspectiveSwitcherToolControl.this.toolBar.toDisplay(bounds.x, bounds.y + bounds.height);
                    menu.setLocation(point);
                    menu.setVisible(true);
                    menu.addMenuListener(new MenuListener(){

                        public void menuShown(MenuEvent e) {
                        }

                        public void menuHidden(MenuEvent e) {
                            PerspectiveSwitcherToolControl.this.toolBar.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    menu.dispose();
                                }
                            });
                        }
                    });
                }
            }
        });
        ToolItem addPerspectiveItem = new ToolItem(this.toolBar, 8);
        Bundle bundle = FrameworkUtil.getBundle(PerspectiveSwitcherSwtTrim.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/eview16/new_persp.gif"), null);
        ImageDescriptor imageDescr = ImageDescriptor.createFromURL((URL)url);
        addPerspectiveItem.setImage(imageDescr.createImage());
        addPerspectiveItem.setToolTipText("Open New Perspective");
        addPerspectiveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterizedCommand command = PerspectiveSwitcherToolControl.this.commandService.createCommand("org.eclipse.apogy.rcp.command.addPerspective", Collections.emptyMap());
                PerspectiveSwitcherToolControl.this.handlerService.executeHandler(command);
            }
        });
        new ToolItem(this.toolBar, 2);
        MPerspectiveStack stack = (MPerspectiveStack)this.modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)this.window);
        for (MPerspective perspective : stack.getChildren()) {
            if (!perspective.isToBeRendered()) continue;
            this.addPerspectiveShortcut(perspective);
        }
    }

    private void closePerspective(MPerspective perspective, ToolItem item) {
        MPerspective snippetPerspective;
        MPerspectiveStack stack = (MPerspectiveStack)perspective.getParent();
        int index = stack.getChildren().indexOf(perspective);
        perspective.setToBeRendered(false);
        stack.getChildren().remove(perspective);
        item.dispose();
        if (stack.getSelectedElement() == null) {
            if (stack.getChildren().isEmpty()) {
                Object widget = perspective.getWidget();
                if (widget instanceof Composite) {
                    ((Composite)widget).dispose();
                }
            } else if (index < stack.getChildren().size()) {
                stack.setSelectedElement((MUIElement)((MPerspective)stack.getChildren().get(index)));
            } else {
                stack.setSelectedElement((MUIElement)((MPerspective)stack.getChildren().get(stack.getChildren().size() - 1)));
            }
        }
        if (!((snippetPerspective = (MPerspective)this.modelService.cloneSnippet((MSnippetContainer)this.application, perspective.getElementId(), this.window)) == null || snippetPerspective.getPersistedState().containsKey("Standalone") && Boolean.parseBoolean((String)snippetPerspective.getPersistedState().get("Standalone")))) {
            PlatformUI.getWorkbench().getPerspectiveRegistry().deletePerspective(PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(snippetPerspective.getElementId()));
            this.application.getSnippets().remove(this.modelService.findSnippet((MSnippetContainer)this.application, snippetPerspective.getElementId()));
        }
    }

    private ToolItem getToolItemFor(MPerspective perspective) {
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            ToolItem[] toolItemArray = this.toolBar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                if (item.getData() == perspective) {
                    return item;
                }
                ++n2;
            }
        }
        return null;
    }

    public void addPerspectiveShortcut(MPerspective perspective) {
        ImageDescriptor descriptor;
        ToolItem perspectiveItem = new ToolItem(this.toolBar, 16);
        perspectiveItem.setData((Object)perspective);
        if (!perspective.getPersistedState().containsKey("Label") && !perspective.getPersistedState().containsKey("Icon")) {
            perspective.getPersistedState().put("Icon", "true");
            perspective.getPersistedState().put("Label", "true");
        }
        if ((descriptor = this.getIconFor(perspective.getIconURI())) != null && perspective.getPersistedState().containsKey("Icon") && ((String)perspective.getPersistedState().get("Icon")).equals("true")) {
            Image icon = descriptor.createImage();
            perspectiveItem.setImage(icon);
            if (perspectiveItem.getText() == null) {
                perspectiveItem.setText("");
            }
            perspectiveItem.setToolTipText(perspective.getLocalizedLabel());
        }
        if (perspective.getPersistedState().containsKey("Label") && ((String)perspective.getPersistedState().get("Label")).equals("true")) {
            String label = perspective.getLocalizedLabel();
            if (label != null) {
                perspectiveItem.setText(label);
            } else {
                perspectiveItem.setText("");
            }
            perspectiveItem.setToolTipText(perspective.getLocalizedTooltip());
        }
        perspectiveItem.setSelection(E4Util.isSelectedElement((MUIElement)perspective));
        perspectiveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MPerspective perspective = (MPerspective)event.widget.getData();
                E4Util.setWindowSelectedElement((MUIElement)perspective);
            }
        });
        this.toolBar.layout();
        this.composite.layout();
    }

    public void removePerspectiveShortcut(MPerspective perspective) {
        ToolItem item = this.getToolItemFor(perspective);
        if (item != null && !item.isDisposed()) {
            Image icon = item.getImage();
            if (icon != null) {
                item.setImage(null);
                icon.dispose();
                icon = null;
            }
            item.dispose();
        }
    }

    public void setSelectedElement(MPerspective perspective) {
        if (this.getToolItemFor(perspective) == null) {
            this.addPerspectiveShortcut(perspective);
        }
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item;
            item.setSelection((item = toolItemArray[n2]).getData() == perspective);
            ++n2;
        }
    }

    public void updateAttributeFor(MPerspective perspective, String attributeName, Object newValue) {
        if (this.getToolItemFor(perspective) == null) {
            this.addPerspectiveShortcut(perspective);
        }
        if (newValue instanceof Map.Entry) {
            newValue = ((Map.Entry)newValue).getValue();
        }
        ToolItem item = this.getToolItemFor(perspective);
        if ("label".equals(attributeName) || "persistedState".equals(attributeName)) {
            if (perspective.getPersistedState().containsKey("Label") && ((String)perspective.getPersistedState().get("Label")).equals("true")) {
                if (perspective.getLabel() != null) {
                    item.setText(perspective.getLabel());
                } else {
                    item.setText("");
                }
            } else {
                item.setText("");
            }
        }
        if ("tooltip".equals(attributeName)) {
            if (perspective.getTooltip() != null) {
                item.setToolTipText(perspective.getTooltip());
            } else {
                item.setToolTipText("");
            }
        }
        if ("iconURI".equals(attributeName) || "persistedState".equals(attributeName)) {
            if (perspective.getPersistedState().containsKey("Icon") && ((String)perspective.getPersistedState().get("Icon")).equals("true")) {
                ImageDescriptor descriptor = this.getIconFor(perspective.getIconURI());
                Image oldIcon = item.getImage();
                Image newIcon = null;
                if (descriptor != null) {
                    newIcon = descriptor.createImage();
                }
                item.setImage(newIcon);
                if (oldIcon != null) {
                    oldIcon.dispose();
                    oldIcon = null;
                }
            } else {
                item.setImage(null);
            }
        }
        this.toolBar.layout();
        this.composite.layout();
    }

    private ImageDescriptor getIconFor(String iconURI) {
        ImageDescriptor descriptor = null;
        try {
            URI uri = URI.createURI((String)iconURI);
            descriptor = (ImageDescriptor)this.resourceUtilities.imageDescriptorFromURI(uri);
        }
        catch (RuntimeException e) {
            Logger.error("Error while getting the icon for the perspective.", (Throwable)e);
        }
        return descriptor;
    }

    @PreDestroy
    void cleanUp() {
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.setControlProvider(null);
        }
        this.perspectiveSwitcher = null;
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            ToolItem[] toolItemArray = this.toolBar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                Image icon = item.getImage();
                if (icon != null) {
                    item.setImage(null);
                    icon.dispose();
                    icon = null;
                }
                ++n2;
            }
        }
    }

    private void preparePerspective(MPerspective perspective) {
    }
}

