/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.perspectiveswitcher.internal.dialogs;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.E4Util;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

@Creatable
public class PerspectiveLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    @Inject
    private Logger logger;
    @Inject
    private IResourceUtilities<ImageDescriptor> resourceUtilities;
    @Inject
    private TranslationService translationService;
    private final HashMap<ImageDescriptor, Image> imageCache = new HashMap(5);
    private final boolean markActive = true;

    public final Image getImage(Object element) {
        Assert.isTrue((boolean)(element instanceof MPerspective));
        Image icon = null;
        MPerspective perspective = (MPerspective)element;
        String _uri = perspective.getIconURI();
        ImageDescriptor descriptor = null;
        try {
            URI iconURI = URI.createURI((String)_uri);
            descriptor = (ImageDescriptor)this.resourceUtilities.imageDescriptorFromURI(iconURI);
        }
        catch (RuntimeException ex) {
            this.logger.error("PerspectiveLabelProvider: uri=" + _uri);
        }
        if (descriptor != null && (icon = this.imageCache.get(descriptor)) == null) {
            icon = descriptor.createImage();
            this.imageCache.put(descriptor, icon);
        }
        return icon;
    }

    public final void dispose() {
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
    }

    public final String getText(Object element) {
        String label = this.translationService.translate("unknown", "platform:/plugin/org.eclipse.e4.ui.workbench.perspectiveswitcher");
        if (element instanceof MPerspective) {
            MPerspective perspective = (MPerspective)element;
            String _lbl = perspective.getLocalizedLabel();
            if (_lbl != null && !_lbl.equals("")) {
                label = _lbl;
            }
            if (E4Util.isSelectedElement((MUIElement)perspective)) {
                label = String.valueOf(label) + "\t(" + this.translationService.translate("active", "platform:/plugin/org.eclipse.e4.ui.workbench.perspectiveswitcher") + ")";
            }
        }
        return label;
    }

    public final Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }

    public final String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }
}

