/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.perspectiveswitcher.tools;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.perspectiveswitcher.tools.IPerspectiveSwitcherControl;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
public class EPerspectiveSwitcher {
    @Inject
    EModelService modelService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    MWindow window;
    IPerspectiveSwitcherControl control;
    private final EventHandler labelHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.isToBeRendered()) {
                return;
            }
            if (perspective != null && perspective.getContext() != null) {
                MWindow perspectiveWindow = (MWindow)perspective.getContext().get(MWindow.class);
                if (EPerspectiveSwitcher.this.window != perspectiveWindow) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                EPerspectiveSwitcher.this.control.updateAttributeFor(perspective, attName, newValue);
            }
        }
    };
    private final EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.getParent().isToBeRendered()) {
                return;
            }
            IEclipseContext context = perspective.getContext();
            if (context == null) {
                return;
            }
            MWindow perspectiveWindow = (MWindow)context.get(MWindow.class);
            if (EPerspectiveSwitcher.this.window != perspectiveWindow) {
                return;
            }
            if (perspective.isToBeRendered()) {
                EPerspectiveSwitcher.this.control.addPerspectiveShortcut(perspective);
            } else {
                EPerspectiveSwitcher.this.control.removePerspectiveShortcut(perspective);
            }
        }
    };
    private final EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
            if (!perspectiveStack.isToBeRendered()) {
                return;
            }
            MWindow stackWindow = (MWindow)EPerspectiveSwitcher.this.modelService.getContainingContext((MUIElement)perspectiveStack).get(MWindow.class);
            if (EPerspectiveSwitcher.this.window != stackWindow) {
                return;
            }
            MPerspective selectedElement = (MPerspective)perspectiveStack.getSelectedElement();
            EPerspectiveSwitcher.this.control.setSelectedElement(selectedElement);
        }
    };
    private final EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            block6: {
                block7: {
                    if (EPerspectiveSwitcher.this.window == null) {
                        return;
                    }
                    MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
                    if (!(changedElement instanceof MPerspective)) {
                        return;
                    }
                    if (!(changedElement instanceof MPerspectiveStack)) break block6;
                    MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
                    if (!perspectiveStack.isToBeRendered()) {
                        return;
                    }
                    MWindow stackWindow = (MWindow)EPerspectiveSwitcher.this.modelService.getContainingContext((MUIElement)perspectiveStack).get(MWindow.class);
                    if (EPerspectiveSwitcher.this.window != stackWindow) {
                        return;
                    }
                    if (!UIEvents.isADD((Event)event)) break block7;
                    for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                        MPerspective added = (MPerspective)o;
                        if (!added.isToBeRendered()) continue;
                        EPerspectiveSwitcher.this.control.addPerspectiveShortcut(added);
                    }
                    break block6;
                }
                if (!UIEvents.isREMOVE((Event)event)) break block6;
                for (Object o : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                    MPerspective removed = (MPerspective)o;
                    if (!removed.isToBeRendered()) continue;
                    EPerspectiveSwitcher.this.control.removePerspectiveShortcut(removed);
                }
            }
        }
    };
    private final EventHandler persistedStateHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = null;
            if (!(event.getProperty("ChangedElement") instanceof MUIElement)) {
                return;
            }
            changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.isToBeRendered()) {
                return;
            }
            if (perspective != null) {
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                EPerspectiveSwitcher.this.control.updateAttributeFor(perspective, attName, newValue);
            }
        }
    };

    void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.labelHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/persistedState/*", this.persistedStateHandler);
    }

    @PreDestroy
    void cleanUp() {
        this.eventBroker.unsubscribe(this.labelHandler);
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.persistedStateHandler);
    }

    public void setControlProvider(IPerspectiveSwitcherControl uiControl) {
        if (uiControl == null) {
            this.control = null;
            this.cleanUp();
        } else {
            if (this.control == null) {
                this.init();
            }
            this.control = uiControl;
        }
    }
}

