/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.DefaultTextSearchQueryProvider;

public class TextSearchQueryProviderRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.search.textSearchQueryProvider";
    private static final String PROVIDER_NODE_NAME = "textSearchQueryProvider";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_LABEL = "label";
    private static final String ATTRIB_CLASS = "class";
    private TextSearchQueryProvider fPreferredProvider = null;
    private String fPreferredProviderId = null;

    public TextSearchQueryProvider getPreferred() {
        String preferredId = this.getPreferredEngineID();
        if (!preferredId.equals(this.fPreferredProviderId)) {
            this.updateProvider(preferredId);
        }
        return this.fPreferredProvider;
    }

    private void updateProvider(String preferredId) {
        this.fPreferredProviderId = preferredId;
        this.fPreferredProvider = null;
        if (preferredId.length() != 0) {
            this.fPreferredProvider = this.createFromExtension(preferredId);
        }
        if (this.fPreferredProvider == null) {
            this.fPreferredProvider = new DefaultTextSearchQueryProvider();
        }
    }

    private String getPreferredEngineID() {
        IPreferenceStore prefs = SearchPlugin.getDefault().getPreferenceStore();
        String preferedEngine = prefs.getString(EXTENSION_POINT_ID);
        return preferedEngine;
    }

    private TextSearchQueryProvider createFromExtension(final String id) {
        final TextSearchQueryProvider[] res = new TextSearchQueryProvider[1];
        SafeRunnable safe = new SafeRunnable(){

            public void run() throws Exception {
                IConfigurationElement[] extensions;
                IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(TextSearchQueryProviderRegistry.EXTENSION_POINT_ID);
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement curr = iConfigurationElementArray[n2];
                    if (TextSearchQueryProviderRegistry.PROVIDER_NODE_NAME.equals(curr.getName()) && id.equals(curr.getAttribute(TextSearchQueryProviderRegistry.ATTRIB_ID))) {
                        res[0] = (TextSearchQueryProvider)curr.createExecutableExtension(TextSearchQueryProviderRegistry.ATTRIB_CLASS);
                        return;
                    }
                    ++n2;
                }
            }

            public void handleException(Throwable e) {
                SearchPlugin.log(e);
            }
        };
        SafeRunnable.run((ISafeRunnable)safe);
        return res[0];
    }

    public String[][] getAvailableProviders() {
        IConfigurationElement[] extensions;
        ArrayList<String[]> res = new ArrayList<String[]>();
        res.add(new String[]{SearchMessages.TextSearchQueryProviderRegistry_defaultProviderLabel, ""});
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement engine = iConfigurationElementArray[n2];
            if (PROVIDER_NODE_NAME.equals(engine.getName())) {
                res.add(new String[]{engine.getAttribute(ATTRIB_LABEL), engine.getAttribute(ATTRIB_ID)});
            }
            ++n2;
        }
        return (String[][])res.toArray((T[])new String[res.size()][]);
    }
}

