/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.ClassBasedVertexFactory;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public final class CompleteGraphDemo {
    static Graph<Object, DefaultEdge> completeGraph;
    static int size;

    static {
        size = 10;
    }

    public static void main(String[] args) {
        completeGraph = new SimpleGraph<Object, DefaultEdge>(DefaultEdge.class);
        CompleteGraphGenerator<Object, DefaultEdge> completeGenerator = new CompleteGraphGenerator<Object, DefaultEdge>(size);
        ClassBasedVertexFactory<Object> vFactory = new ClassBasedVertexFactory<Object>(Object.class);
        completeGenerator.generateGraph(completeGraph, (VertexFactory<Object>)vFactory, (Map<String, Object>)null);
        HashSet<Object> vertices = new HashSet<Object>();
        vertices.addAll(completeGraph.vertexSet());
        Integer counter = 0;
        for (Object e : vertices) {
            Integer n = counter;
            counter = n + 1;
            CompleteGraphDemo.replaceVertex(e, n);
        }
        DepthFirstIterator<Object, DefaultEdge> depthFirstIterator = new DepthFirstIterator<Object, DefaultEdge>(completeGraph);
        while (depthFirstIterator.hasNext()) {
            Object vertex = depthFirstIterator.next();
            System.out.println("Vertex " + vertex.toString() + " is connected to: " + completeGraph.edgesOf(vertex).toString());
        }
    }

    public static boolean replaceVertex(Object oldVertex, Object newVertex) {
        if (oldVertex == null || newVertex == null) {
            return false;
        }
        Set<DefaultEdge> relatedEdges = completeGraph.edgesOf(oldVertex);
        completeGraph.addVertex(newVertex);
        for (DefaultEdge e : relatedEdges) {
            Object sourceVertex = completeGraph.getEdgeSource(e);
            Object targetVertex = completeGraph.getEdgeTarget(e);
            if (sourceVertex.equals(oldVertex) && targetVertex.equals(oldVertex)) {
                completeGraph.addEdge(newVertex, newVertex);
                continue;
            }
            if (sourceVertex.equals(oldVertex)) {
                completeGraph.addEdge(newVertex, targetVertex);
                continue;
            }
            completeGraph.addEdge(sourceVertex, newVertex);
        }
        completeGraph.removeVertex(oldVertex);
        return true;
    }
}

