/*
 * Decompiled with CFR 0.152.
 */
package wiimote;

import geometry_msgs.Vector3;
import java.util.List;
import org.ros.internal.message.Message;
import org.ros.message.Time;
import std_msgs.Header;
import wiimote.IrSourceInfo;

public interface State
extends Message {
    public static final String _TYPE = "wiimote/State";
    public static final String _DEFINITION = "#\n#          Wiimote State message containing one complete Wiimote state\n\n# Note: For ease of manipulation this message often uses\n#       int8[] when a bit vector would work. One might\n#       wish to use uint8[], but then Python takes\n#       the respective structure as a string and disallows\n#       item assignment.\n\nint8    INVALID       = -1\nfloat32 INVALID_FLOAT = -1.0\n\nint8 MSG_BTN_1     = 0\nint8 MSG_BTN_2     = 1\nint8 MSG_BTN_A     = 2\nint8 MSG_BTN_B     = 3\nint8 MSG_BTN_PLUS  = 4\nint8 MSG_BTN_MINUS = 5\nint8 MSG_BTN_LEFT  = 6\nint8 MSG_BTN_RIGHT = 7\nint8 MSG_BTN_UP    = 8\nint8 MSG_BTN_DOWN  = 9\nint8 MSG_BTN_HOME  = 10\nint8 MSG_BTN_Z     = 0\nint8 MSG_BTN_C     = 1\nint8 MSG_CLASSIC_BTN_X       = 0\nint8 MSG_CLASSIC_BTN_Y       = 1\nint8 MSG_CLASSIC_BTN_A       = 2\nint8 MSG_CLASSIC_BTN_B       = 3\nint8 MSG_CLASSIC_BTN_PLUS    = 4\nint8 MSG_CLASSIC_BTN_MINUS   = 5\nint8 MSG_CLASSIC_BTN_LEFT    = 6\nint8 MSG_CLASSIC_BTN_RIGHT   = 7\nint8 MSG_CLASSIC_BTN_UP      = 8\nint8 MSG_CLASSIC_BTN_DOWN    = 9\nint8 MSG_CLASSIC_BTN_HOME    = 10\nint8 MSG_CLASSIC_BTN_L       = 11\nint8 MSG_CLASSIC_BTN_R       = 12\nint8 MSG_CLASSIC_BTN_ZL      = 13\nint8 MSG_CLASSIC_BTN_ZR      = 14\n\n#-----------------------------\n# Header\n#----------------------\n\nHeader header\n\n#----------------------\n# Gyro reading\n#-----------------------------\n# In radians/sec. If reading is invalid,\n# for instance b/c no gyro is attached to the Wii, then\n# set first element of covariance to -1 (same as imu_data.msg):\n# Covariance matrix (roll, pitch, yaw) in radians^2/sec^2.\n\ngeometry_msgs/Vector3 angular_velocity_zeroed\ngeometry_msgs/Vector3 angular_velocity_raw\nfloat64[9] angular_velocity_covariance\n\n#----------------------\n# Accelerometer reading\n#-----------------------------\n# Acceleration in m/sec^2. Covariance matrix\n# (x,y,z) in m^2/sec^4.  (all same as imu_data.msg)\n\ngeometry_msgs/Vector3 linear_acceleration_zeroed\ngeometry_msgs/Vector3 linear_acceleration_raw\nfloat64[9] linear_acceleration_covariance\n\n#------------------------------\n# Nunchuk Accelerometer reading\n#------------------------------\ngeometry_msgs/Vector3 nunchuk_acceleration_zeroed\ngeometry_msgs/Vector3 nunchuk_acceleration_raw\n\n#-----------------\n# Nunchuk Joystick\n#-----------------\nfloat32[2] nunchuk_joystick_zeroed\nfloat32[2] nunchuk_joystick_raw\n\n#----------------------\n# Wiimote buttons\n#-----------------------------\n# Mappings from Wiimote button name\n# to array position are defined above.\n#\nbool[11] buttons\nbool[2] nunchuk_buttons\n\n#----------------------\n# Wiimote LED states:\n#-----------------------------\n\nbool[4] LEDs\n\n#----------------------\n# Wiimote Rumble\n#-----------------------------\n# State (True or False)\n\nbool rumble\n\n#----------------------\n# IR Light sensor (Camera)\n#-----------------------------\n# The Wiimote handles up to four light sources, \n# and the wiimote_node.py software is written to \n# that limit as well. For future expansion\n# we make the following array extensible, rather\n# than locking its length down to four:\n\nwiimote/IrSourceInfo[] ir_tracking\n\n#----------------------\n# Wiimote battery\n#-----------------------------\n# A battery reading consists of two numbers: \n# the battery percentage, and the raw reading.\n# Maximum battery is 208 units (unknown how this\n# relates to electrical properties): \n\nfloat32 raw_battery\nfloat32 percent_battery\n\n#----------------------\n# Time of most recent zeroing:\n#-----------------------------\n\ntime zeroing_time\n\n#----------------------\n# Error vector\n#-----------------------------\n# For error condition definitions see wiimoteConstants.py\n# Value of zero means all is well. (Currently NOT used).\n\nuint64 errors\n";
    public static final byte INVALID = -1;
    public static final float INVALID_FLOAT = -1.0f;
    public static final byte MSG_BTN_1 = 0;
    public static final byte MSG_BTN_2 = 1;
    public static final byte MSG_BTN_A = 2;
    public static final byte MSG_BTN_B = 3;
    public static final byte MSG_BTN_PLUS = 4;
    public static final byte MSG_BTN_MINUS = 5;
    public static final byte MSG_BTN_LEFT = 6;
    public static final byte MSG_BTN_RIGHT = 7;
    public static final byte MSG_BTN_UP = 8;
    public static final byte MSG_BTN_DOWN = 9;
    public static final byte MSG_BTN_HOME = 10;
    public static final byte MSG_BTN_Z = 0;
    public static final byte MSG_BTN_C = 1;
    public static final byte MSG_CLASSIC_BTN_X = 0;
    public static final byte MSG_CLASSIC_BTN_Y = 1;
    public static final byte MSG_CLASSIC_BTN_A = 2;
    public static final byte MSG_CLASSIC_BTN_B = 3;
    public static final byte MSG_CLASSIC_BTN_PLUS = 4;
    public static final byte MSG_CLASSIC_BTN_MINUS = 5;
    public static final byte MSG_CLASSIC_BTN_LEFT = 6;
    public static final byte MSG_CLASSIC_BTN_RIGHT = 7;
    public static final byte MSG_CLASSIC_BTN_UP = 8;
    public static final byte MSG_CLASSIC_BTN_DOWN = 9;
    public static final byte MSG_CLASSIC_BTN_HOME = 10;
    public static final byte MSG_CLASSIC_BTN_L = 11;
    public static final byte MSG_CLASSIC_BTN_R = 12;
    public static final byte MSG_CLASSIC_BTN_ZL = 13;
    public static final byte MSG_CLASSIC_BTN_ZR = 14;

    public Header getHeader();

    public void setHeader(Header var1);

    public Vector3 getAngularVelocityZeroed();

    public void setAngularVelocityZeroed(Vector3 var1);

    public Vector3 getAngularVelocityRaw();

    public void setAngularVelocityRaw(Vector3 var1);

    public double[] getAngularVelocityCovariance();

    public void setAngularVelocityCovariance(double[] var1);

    public Vector3 getLinearAccelerationZeroed();

    public void setLinearAccelerationZeroed(Vector3 var1);

    public Vector3 getLinearAccelerationRaw();

    public void setLinearAccelerationRaw(Vector3 var1);

    public double[] getLinearAccelerationCovariance();

    public void setLinearAccelerationCovariance(double[] var1);

    public Vector3 getNunchukAccelerationZeroed();

    public void setNunchukAccelerationZeroed(Vector3 var1);

    public Vector3 getNunchukAccelerationRaw();

    public void setNunchukAccelerationRaw(Vector3 var1);

    public float[] getNunchukJoystickZeroed();

    public void setNunchukJoystickZeroed(float[] var1);

    public float[] getNunchukJoystickRaw();

    public void setNunchukJoystickRaw(float[] var1);

    public boolean[] getButtons();

    public void setButtons(boolean[] var1);

    public boolean[] getNunchukButtons();

    public void setNunchukButtons(boolean[] var1);

    public boolean[] getLEDs();

    public void setLEDs(boolean[] var1);

    public boolean getRumble();

    public void setRumble(boolean var1);

    public List<IrSourceInfo> getIrTracking();

    public void setIrTracking(List<IrSourceInfo> var1);

    public float getRawBattery();

    public void setRawBattery(float var1);

    public float getPercentBattery();

    public void setPercentBattery(float var1);

    public Time getZeroingTime();

    public void setZeroingTime(Time var1);

    public long getErrors();

    public void setErrors(long var1);
}

