/*
 * Decompiled with CFR 0.152.
 */
package org.ros.concurrent;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.CancellableLoop;
import org.ros.exception.RosRuntimeException;

public class RetryingExecutorService {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(RetryingExecutorService.class);
    private static final long DEFAULT_RETRY_DELAY = 5L;
    private static final TimeUnit DEFAULT_RETRY_TIME_UNIT = TimeUnit.SECONDS;
    private final ScheduledExecutorService scheduledExecutorService;
    private final RetryLoop retryLoop;
    private final Map<Callable<Boolean>, CountDownLatch> latches;
    private final Map<Future<Boolean>, Callable<Boolean>> callables;
    private final CompletionService<Boolean> completionService;
    private final Object mutex;
    private long retryDelay;
    private TimeUnit retryTimeUnit;
    private boolean running;

    public RetryingExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.retryLoop = new RetryLoop();
        this.latches = Maps.newConcurrentMap();
        this.callables = Maps.newConcurrentMap();
        this.completionService = new ExecutorCompletionService<Boolean>(scheduledExecutorService);
        this.mutex = new Object();
        this.retryDelay = 5L;
        this.retryTimeUnit = DEFAULT_RETRY_TIME_UNIT;
        this.running = true;
        scheduledExecutorService.execute(this.retryLoop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Callable<Boolean> callable) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.running) {
                throw new RejectedExecutionException();
            }
            Future<Boolean> future = this.completionService.submit(callable);
            this.latches.put(callable, new CountDownLatch(1));
            this.callables.put(future, callable);
        }
    }

    public void setRetryDelay(long delay, TimeUnit unit) {
        this.retryDelay = delay;
        this.retryTimeUnit = unit;
    }

    public void shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.running = false;
        for (CountDownLatch latch : this.latches.values()) {
            latch.await(timeout, unit);
        }
        this.retryLoop.cancel();
    }

    private class RetryLoop
    extends CancellableLoop {
        private RetryLoop() {
        }

        @Override
        public void loop() throws InterruptedException {
            boolean retry;
            Future future = RetryingExecutorService.this.completionService.take();
            final Callable callable = (Callable)RetryingExecutorService.this.callables.remove(future);
            try {
                retry = (Boolean)future.get();
            }
            catch (ExecutionException e) {
                throw new RosRuntimeException(e.getCause());
            }
            if (retry) {
                RetryingExecutorService.this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        RetryingExecutorService.this.submit(callable);
                    }
                }, RetryingExecutorService.this.retryDelay, RetryingExecutorService.this.retryTimeUnit);
            } else {
                ((CountDownLatch)RetryingExecutorService.this.latches.get(callable)).countDown();
            }
        }
    }
}

