/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.response;

import com.google.common.collect.Lists;
import java.util.List;
import org.ros.exception.RemoteException;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.response.ResultFactory;
import org.ros.internal.node.response.StatusCode;

public class Response<T> {
    private final StatusCode statusCode;
    private final String statusMessage;
    private final T result;

    public static <T> Response<T> newError(String message, T value) {
        return new Response<T>(StatusCode.ERROR, message, value);
    }

    public static <T> Response<T> newFailure(String message, T value) {
        return new Response<T>(StatusCode.FAILURE, message, value);
    }

    public static <T> Response<T> newSuccess(String message, T value) {
        return new Response<T>(StatusCode.SUCCESS, message, value);
    }

    public static <T> Response<T> fromListCheckedFailure(List<Object> response, ResultFactory<T> resultFactory) throws RemoteException {
        String message;
        StatusCode statusCode;
        try {
            statusCode = StatusCode.fromInt((Integer)response.get(0));
            message = (String)response.get(1);
            if (statusCode == StatusCode.FAILURE) {
                throw new RemoteException(statusCode, message);
            }
        }
        catch (ClassCastException e) {
            throw new RosRuntimeException("Remote side did not return correct type (status code/message).", e);
        }
        try {
            return new Response<T>(statusCode, message, resultFactory.newFromValue(response.get(2)));
        }
        catch (ClassCastException e) {
            throw new RosRuntimeException("Remote side did not return correct value type.", e);
        }
    }

    public static <T> Response<T> fromListChecked(List<Object> response, ResultFactory<T> resultFactory) throws RemoteException {
        String message;
        StatusCode statusCode;
        try {
            statusCode = StatusCode.fromInt((Integer)response.get(0));
            message = (String)response.get(1);
            if (statusCode != StatusCode.SUCCESS) {
                throw new RemoteException(statusCode, message);
            }
        }
        catch (ClassCastException e) {
            throw new RosRuntimeException("Remote side did not return correct type (status code/message).", e);
        }
        try {
            return new Response<T>(statusCode, message, resultFactory.newFromValue(response.get(2)));
        }
        catch (ClassCastException e) {
            throw new RosRuntimeException("Remote side did not return correct value type.", e);
        }
    }

    public Response(int statusCode, String statusMessage, T value) {
        this(StatusCode.fromInt(statusCode), statusMessage, value);
    }

    public Response(StatusCode statusCode, String statusMessage, T value) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.result = value;
    }

    public List<Object> toList() {
        return Lists.newArrayList((Object[])new Object[]{this.statusCode.toInt(), this.statusMessage, this.result == null ? "null" : this.result});
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public T getResult() {
        return this.result;
    }

    public String toString() {
        return "Response<" + (Object)((Object)this.statusCode) + ", " + this.statusMessage + ", " + this.result + ">";
    }

    public boolean isSuccess() {
        return this.statusCode == StatusCode.SUCCESS;
    }
}

